<?php
Wind::import('WIND:cache.AbstractWindCache');
/**
 * Dbʵ
 * 
 * Dbûһݱ,ݱ浽.
 * ṩԷʽӿ:
 * <ul>
 *   <li>set($key, $value, $expire): ̳{@link AbstractWindCache::set()}.</li>
 *   <li>get($key): ̳{@link AbstractWindCache::get()}.</li>
 *   <li>delete($key): ̳{@link AbstractWindCache::delete()}.</li>
 *   <li>batchGet($keys): ̳{@link AbstractWindCache::batchGet()}.</li>
 *   <li>batchDelete($keys): ̳{@link AbstractWindCache::batchDelete()}.</li>
 *   <li>{@link setConfig($config)}: д˸{@link AbstractWindCache::setConfig()}.</li>
 * </ul>
 * 
 * :
 * <code>
 * 	array(
 * 		'table-name' => 'cache',	//ı 
 *		'field-key' => 'key',	//keyֶΨһֵ
 *		'field-value' => 'value',	//ݴ洢ֶ
 *		'field-expire' => 'expire',	//ݵĹʱֶ,Ϊint,ĬΪ0
 *		'security-code' => '',	//̳AbstractWindCache,ȫ
 *		'key-prefix' => '',	 //̳AbstractWindCache,keyǰ׺
 *		'expires' => '0',	//̳AbstractWindCache,ʱ
 *	)
 * </code>
 * <i>Dbʹ:</i><br/>
 * 1ʹͨһʹø:
 * <code>
 *  Wind::import('WIND:cache.strategy.WindDbCache');
 * 	$cache = new WindDbCache($dbHandler, array('table-name' => 'pw_cache', 'field-key' => 'key', 'field-value' => 'value', 'field-expire' => '0'));
 *  $cache->set('name', 'windDbTest');
 * </code>
 * <note><b>ע: </b>ҪdbHandlerݿӶ</note>
 * 2õķʽͨƵ
 * Ӧõcomponentsÿ,dbCache(<i>ֽõʱʹõ</i>):
 * <pre>
 *  'dbCache' => array(
 *  	'path' => 'WIND:cache.strategy.WindDbCache',
 *		'scope' => 'singleton',
 *		'properties' => array(
 *			'connection' => array('ref' => 'db');
 *      ),
 *		'config' => array(
 *			'table-name' => 'cache',
 *			'field-key' => 'key',
 *			'field-value' => 'value',
 *			'field-expire' => 'expire',
 *			'security-code' => '', 
 * 	    	'key-prefix' => '',
 *      	'expires' => '0',
 *		),
 *  ),
 * </pre>
 * Ӧпͨ·ʽdbCache:
 * <code>
 * $cache = Wind::getComponent('dbCache');	//dbCacheе
 * $cache->set('name', 'test');
 * </code>
 * <note><b>ע: </b>Ҫ(preperties)connectionֵΪdbһ</note>
 * 
 * the last known user to change this file in the repository  <LastChangedBy: xiaoxiao >
 * @author xiaoxiao <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindDbCache.php 3791 2012-10-30 04:01:29Z liusanbian $
 * @package strategy
 */
class WindDbCache extends AbstractWindCache {
	
	/**
	 * Ӿ
	 * 
	 * @var WindConnection 
	 */
	protected $connection;
	
	/**
	 * 
	 * 
	 * @var string 
	 */
	private $table = 'cache';
	
	/**
	 * ļֶ
	 * 
	 * @var string 
	 */
	private $keyField = 'key';
	
	/**
	 * ֵֶ
	 * 
	 * @var string 
	 */
	private $valueField = 'value';
	
	/**
	 * ʱֶ
	 * 
	 * @var string 
	 */
	private $expireField = 'expire';

	/**
	 * 캯
	 * 
	 * ʼ
	 * 
	 * @param WindConnection $connection ݿӶ,ȱʡֵΪnull
	 * @param array $config ļ,ȱʡֵΪarray()
	 */
	public function __construct(WindConnection $connection = null, $config = array()) {
		$connection && $this->setConnection($connection);
		$config && $this->setConfig($config);
	}

	/* (non-PHPdoc)
	 * @see AbstractWindCache::setValue()
	 */
	protected function setValue($key, $value, $expire = 0) {
		return $this->store($key, $value, $expire);
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::addValue()
	 */
	protected function addValue($key, $value, $expire = 0) {
		return $this->store($key, $value, $expire, 'add');
	}

	/* (non-PHPdoc)
	 * @see AbstractWindCache::getValue()
	 */
	protected function getValue($key) {
		$sql = 'SELECT * FROM ' . $this->getTableName() . ' WHERE `' . $this->keyField . '` =? ';
		$data = $this->getConnection()->createStatement($sql)->getOne(array($key));
		if (!$data) return false;
		return $this->_checkExpire($data[$this->expireField], time()) ? false : $data[$this->valueField];
	}

	/* (non-PHPdoc)
	 * @see AbstractWindCache::batchGet()
	 */
	public function batchGet(array $keys) {
		if (!$keys) return array();
		$_temp = $result = array();
		foreach ($keys as $value) {
			$_temp[$value] = $this->buildSecurityKey($value);
		}
		$sql = 'SELECT * FROM ' . $this->getTableName() . ' WHERE `' . $this->keyField . '` IN ' . $this->getConnection()->quoteArray($_temp);
		$data = $this->getConnection()->createStatement($sql)->queryAll(array(), $this->keyField);
		$_now = time();
		foreach ($_temp as $key => $cacheKey) {
			$result[$key] = false;
			if (!isset($data[$cacheKey])) continue;
			$tmp = $data[$cacheKey];
			$result[$key] = $this->_checkExpire($tmp[$this->expireField], $_now) ? false :  $this->formatData($key, $tmp[$this->valueField]);
		}
		return $result;
	}

	/* (non-PHPdoc)
	 * @see AbstractWindCache::deleteValue()
	 */
	protected function deleteValue($key) {
		$sql = 'DELETE FROM ' . $this->getTableName() . ' WHERE `' . $this->keyField . '` = ? ';
		return $this->getConnection()->createStatement($sql)->update(array($key));
	}

	/* (non-PHPdoc)
	 * @see AbstractWindCache::batchDelete()
	 */
	public function batchDelete(array $keys) {
		array_walk($keys, array($this, 'buildSecurityKey'));
		$sql = 'DELETE FROM ' . $this->getTableName() . ' WHERE `' . $this->keyField . '` IN ' . $this->getConnection()->quoteArray($keys);
		return $this->getConnection()->execute($sql);
	}

	/**
	 * 
	 * <ul>
	 *  <li>$expireOnly=trueֻɾڵݡ</li>
	 *  <li>$expireOnly=falseɾлݡ</li>
	 * </ul>
	 * 
	 * @param boolean $expireOnly ɾΪtrueȫ涼ɾΪfalseȱʡֵΪtrue
	 * @return int
	 */
	public function clear($expireOnly = true) {
		$sql = sprintf('DELETE FROM `%s`', $this->getTableName());
		if ($expireOnly) {
			$sql = sprintf('DELETE FROM `%s` WHERE `%s` < ', $this->getTableName(), $this->expireField) . $this->getConnection()->quote(time());
		}
		return $this->getConnection()->execute($sql);
	}

	/* (non-PHPdoc)
	 * @see AbstractWindCache::setConfig()
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		$this->table = $this->getConfig('table-name', '', 'cache', $config);
		$this->keyField = $this->getConfig('field-key', '', 'key', $config);
		$this->valueField = $this->getConfig('field-value', '', 'value', $config);
		$this->expireField = $this->getConfig('field-expire', '', 'expire', $config);
	}

	/**
	 * Ӷ
	 * 
	 * @param WindConnection $connection
	 */
	public function setConnection($connection) {
		if ($connection instanceof WindConnection) $this->connection = $connection;
	}

	/**
	 * ػ
	 * 
	 * @return string
	 */
	private function getTableName() {
		return $this->getConnection()->getTablePrefix() . $this->table;
	}

	/**
	 * 洢
	 * 
	 * @param string $key Ļkey
	 * @param string $value Ļ
	 * @param int $expires 汣ʱ䣬Ϊ0ڣĬΪ0
	 * @param string $type ı淽ʽĬΪsetʹreplaceʽ
	 * @return int 
	 */
	private function store($key, $value, $expires = 0, $type="set") {
		($expires > 0) ? $expires += time() : $expire = 0;
		$db = array($this->keyField => $key, $this->valueField => $value, $this->expireField => $expires);
		if ($type == 'add') {
			$sql = 'INSERT INTO ' . $this->getTableName() . ' SET ' . $this->getConnection()->sqlSingle($db);
		} else {
			$sql = 'REPLACE INTO ' . $this->getTableName() . ' SET ' . $this->getConnection()->sqlSingle($db);
		}
		return $this->getConnection()->createStatement($sql)->update();
	}
	
	/**
	 * жǷ
	 * 򷵻true/򷵻false
	 *
	 * @param int $endTime
	 * @param int $nowTime
	 * @return boolean
	 */
	private function _checkExpire($endTime, $nowTime) {
		if ($endTime == 0) return false;
		return $endTime <= $nowTime;
	}

	/**
	 * Ӷ
	 * 
	 * @return WindConnection 
	 */
	private function getConnection() {
		return $this->_getConnection();
	}
}