<?php
Wind::import('WIND:cache.AbstractWindCache');
Wind::import('WIND:utility.WindFile');
/**
 * fileʵ
 * ṩԷʽӿ:
 * <ul>
 * <li>set($key, $value, $expire): ̳{@link AbstractWindCache::set()}.</li>
 * <li>get($key): ̳{@link AbstractWindCache::get()}.</li>
 * <li>delete($key): ̳{@link AbstractWindCache::delete()}.</li>
 * <li>batchGet($keys): ̳{@link AbstractWindCache::batchGet()}.</li>
 * <li>batchDelete($keys): ̳{@link AbstractWindCache::batchDelete()}.</li>
 * <li>{@link setConfig($config)}: д˸{@link
 * AbstractWindCache::setConfig()}.</li>
 * </ul>
 * :
 * <code>
 * array(
 * 'dir' => 'data',	//ļŵĿ¼,עɶд
 * 'suffix' => 'txt',	//ļĺ׺,ĬΪtxt׺
 * 'dir-level' => '0',	//ļĿ¼Ŀ¼,ĬΪ0Ŀ¼
 * 'security-code' => '',	//̳AbstractWindCache,ȫ
 * 'key-prefix' => '', //̳AbstractWindCache,keyǰ׺
 * 'expires' => '0',	//̳AbstractWindCache,ʱ
 * )
 * </code>
 * <i>ʹ÷:</i><br/>
 * 1ʹͨһʹø:
 * <code>
 * Wind::import('WIND:cache.strategy.WindFileCache');
 * $cache = new WindFileCache();
 * $cache->setConfig(array('dir' => 'data', 'suffix' => 'php'));
 * $cache->set('name', 'fileCacheTest');
 * </code>
 * 2õķʽͨƵ
 * Ӧõcomponentsÿ,fileCache(<i>ֽõʱʹõ</i>):
 * <pre>
 * 'fileCache' => array(
 * 'path' => 'WIND:cache.strategy.WindFileCache',
 * 'scope' => 'singleton',
 * 'config' => array(
 * 'dir' => 'data',
 * 'suffix' => 'txt',
 * 'dir-level' => '0',
 * 'security-code' => '',
 * 'key-prefix' => '',
 * 'expires' => '0',
 * ),
 * ),
 * </pre>
 * Ӧпͨ·ʽdbCache:
 * <code>
 * $fileCache = Wind::getComponent('fileCache'); //dbCacheе
 * </code>
 * the last known user to change this file in the repository <LastChangedBy:
 * xiaoxiao >
 * 
 * @author xiaoxiao <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindFileCache.php 3791 2012-10-30 04:01:29Z liusanbian $
 * @package strategy
 */
class WindFileCache extends AbstractWindCache {
	
	/**
	 * Ŀ¼
	 * 
	 * @var string
	 */
	private $cacheDir;
	
	/**
	 * ׺
	 * 
	 * @var string
	 */
	private $cacheFileSuffix = 'txt';
	
	/**
	 * Ŀ¼ĳ
	 * 
	 * @var int
	 */
	private $cacheDirectoryLevel = 0;
	
	/**
	 * 滺Ŀ¼б
	 * ûѾʹͳһ棬ֱӴӸблȡþֵ¼㡣
	 * 
	 * @var array
	 */
	private $cacheFileList = array();
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::setValue()
	 */
	protected function setValue($key, $value, $expire = 0) {
		return WindFile::write($key, $value) == strlen($value);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::addValue()
	 */
	protected function addValue($key, $value, $expire = 0) {
		return WindFile::write($key, $value) == strlen($value);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::get()
	 */
	protected function getValue($key) {
		if (!is_file($key)) return null;
		return WindFile::read($key);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::deleteValue()
	 */
	protected function deleteValue($key) {
		return WindFile::write($key, '');
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::clear()
	 */
	public function clear() {
		return WindFolder::clearRecur($this->getCacheDir());
	}

	/**
	 * ûkeyȡǻļ
	 * keyڰȫ֮,жϸkeyǷѾʹ
	 * <ul>
	 * <li>ʹ,ֱӷظʵļ</li>
	 * <li>ûзʹ,򽫻.
	 * <ol>
	 * <li>ø˻Ŀ¼ĳn
	 * <ul>
	 * <li>ûkeymd5ֵ0~nִΪӻĿ¼;</li>
	 * <li>ļڸûĿ¼.ͬʱûļ·浽ѷʵĻ·б,´ֱӵ.</li>
	 * </ul>
	 * </li>
	 * <li>ûûĿ¼,ֱӽļڻĿ¼,ͬʱҲûļ·ѷʵĻ·б.</li>
	 * </ol>
	 * </li>
	 * </ul>
	 * 
	 * @param string $key ûĻļkey
	 * @return string ʵĻļ
	 */
	protected function buildSecurityKey($key) {
		$key = parent::buildSecurityKey($key);
		if (false !== ($dir = $this->checkCacheDir($key))) return $dir;
		$_dir = $this->getCacheDir();
		if (0 < ($level = $this->getCacheDirectoryLevel())) {
			$_subdir = substr(md5($key), 0, $level);
			$_dir .= '/' . $_subdir;
			WindFolder::isDir($_dir) || WindFolder::mk($_dir);
		}
		$filename = $key . '.' . $this->getCacheFileSuffix();
		$this->cacheFileList[$key] = ($_dir ? $_dir . '/' . $filename : $filename);
		return $this->cacheFileList[$key];
	}

	/**
	 * Ƿ񻺴keyѾڻб
	 * <ul>
	 * <li>keyѾڻб,򽫻ֱӷشڵֵ</li>
	 * <li>򷵻false.</li>
	 * </ul>
	 * 
	 * @param string $key Ļkey
	 * @return string boolean
	 */
	private function checkCacheDir($key) {
		return isset($this->cacheFileList[$key]) ? $this->cacheFileList[$key] : false;
	}

	/**
	 * ûĿ¼
	 * 
	 * @param string $dir Ŀ¼<b>дɶ</b>Ȩ
	 */
	public function setCacheDir($dir) {
		$_dir = Wind::getRealPath($dir, false, true);
		WindFolder::mkRecur($_dir);
		$this->cacheDir = realpath($_dir);
	}

	/**
	 * ûĿ¼
	 * 
	 * @return string $cacheDir õĻĿ¼
	 */
	private function getCacheDir() {
		return $this->cacheDir;
	}

	/**
	 * ûļĺ׺
	 * 
	 * @param string $cacheFileSuffix ļĺ׺ĬΪtxt
	 */
	public function setCacheFileSuffix($cacheFileSuffix) {
		$this->cacheFileSuffix = $cacheFileSuffix;
	}

	/**
	 * ûļĺ׺
	 * 
	 * @return string $cacheFileSuffix ļĺ׺
	 */
	private function getCacheFileSuffix() {
		return $this->cacheFileSuffix;
	}

	/**
	 * ûŵĿ¼Ŀ¼ĳ
	 * 
	 * @param int $cacheDirectoryLevel
	 *        ֵĿ¼ӻĿ¼ĳȣСΪ0Ŀ¼Ϊ32md5ֵ32ȱʡΪ0
	 */
	public function setCacheDirectoryLevel($cacheDirectoryLevel) {
		$this->cacheDirectoryLevel = $cacheDirectoryLevel;
	}

	/**
	 * ػŵĿ¼Ŀ¼ĳ
	 * ֵĿ¼ӻĿ¼ĳȣСΪ0Ŀ¼Ϊ32md5ֵ32ȱʡΪ0
	 * 
	 * @return int $cacheDirectoryLevel
	 */
	public function getCacheDirectoryLevel() {
		return $this->cacheDirectoryLevel;
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::setConfig()
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		$this->setCacheDir($this->getConfig('dir'));
		$this->setCacheFileSuffix($this->getConfig('suffix', '', 'txt'));
		$this->setCacheDirectoryLevel($this->getConfig('dir-level', '', 0));
	}
}