<?php
Wind::import('WIND:cache.AbstractWindCache');
/**
 * memCachedʵ
 * 
 * memCached汣浽memCacheڴ滺.
 * ṩԷʽӿ:
 * <ul>
 * <li>set($key, $value, $expire): ̳{@link AbstractWindCache::set()}.</li>
 * <li>get($key): ̳{@link AbstractWindCache::get()}.</li>
 * <li>delete($key): ̳{@link AbstractWindCache::delete()}.</li>
 * <li>batchGet($keys): ̳{@link AbstractWindCache::batchGet()}.</li>
 * <li>batchDelete($keys): ̳{@link AbstractWindCache::batchDelete()}.</li>
 * <li>{@link setConfig($config)}: д˸{@link AbstractWindCache::setConfig()}.</li>
 * </ul>
 * 
 * :
 * <code>
 * array(
 * 'security-code' => '',	//̳AbstractWindCache,ȫ.
 * 'key-prefix' => '',	 //̳AbstractWindCache,keyǰ׺.
 * 'expires' => '0',	//̳AbstractWindCache,ʱ.
 * 'compress' => '0',	//ѹȼ,ĬΪ0
 * 'servers' => array(
 * 'host' => array(
 * 'host'=>'localhost',	//Ҫӵmemcached˼λ.
 * 'port'=>11211,	//Ҫӵmemcached˼Ķ˿.
 * 'weight' => 1,	//Ϊ˷Ͱ,ƴ˷ѡеȨ,ѡеĸзweightܺͶԵ.
 * ),
 * ),
 * )
 * </code>
 * <i>ʹ÷</i><br/>
 * 1ͨĵķʽȥ:
 * <code>
 * Wind::import("WIND:cache.strategy.WindMemCached");
 * $cache = new WindMemCached();
 * $cache->setConfig(array('host' => 'localhost', 'port' => 11211));
 * $cache->set('name', 'test');
 * </code>
 * 2õķʽͨƵ
 * Ӧõcomponentsÿ,memCache(<i>ֽõʱʹõ</i>):
 * <code>
 * 'memCache' => array(
 * 'path' => 'WIND:cache.strategy.WindMemCached',
		'scope' => 'singleton',
 * 		'config' = array(
 * 			'security-code' => '',
 * 			'key-prefix' => '',
 * 			'expires' => '0',
 * 			'compress' => '0',
 * 			'servers' => array(
 * 				'host1' => array(
 * 					'host'=>'localhost',
 * 					'port'=>11211,
 * 					'pconn'=>true,
 * 					'weight' => 1,
 * 				),
 * 			),
 * 		),
 * ),
 * </code>
 * жmemCache,öhostconfig,host1,host2,keyֵҲԶ.
 * 
 * <note><b>ע⣺</b>ҪʹøҪװmemcacheչ.</note>
 * 
 * the last known user to change this file in the repository  <LastChangedBy: xiaoxiao >
 * @author xiaoxiao <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindMemCached.php 3891 2013-01-08 03:44:46Z xiaoxia.xuxx $
 * @package strategy
 */
class WindMemCached extends AbstractWindCache {
	
	/**
	 * memcache
	 * 
	 * @var WindMemcache 
	 */
	protected $memcache = null;

	/**
	 * 캯
	 * 
	 * жǷ֧memCache,ûаװչ⽫׳쳣,<br/>
	 * ȳʹmemcachedչȻԴmemcache
	 * 
	 * @throws WindCacheException ûаװmemcacheչ׳쳣
	 */
	public function __construct() {
		$this->memcache = new Memcached();
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::setValue()
	 */
	protected function setValue($key, $value, $expire = 0) {
		return $this->memcache->set($key, $value, (int) $expire);
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::addValue()
	 */
	protected function addValue($key, $value, $expires = 0) {
		return $this->memcache->add($key, $value, (int) $expires);
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::getValue()
	 */
	protected function getValue($key) {
		return $this->memcache->get($key);
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::deleteValue()
	 */
	protected function deleteValue($key) {
		return $this->memcache->delete($key);
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::clear()
	 */
	public function clear() {
		return $this->memcache->flush();
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::increment()
	 */
	public function increment($key, $step = 1) {
		return $this->memcache->increment($this->buildSecurityKey($key), $step);
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::decrement()
	 */
	public function decrement($key, $step = 1) {
		return $this->memcache->decrement($this->buildSecurityKey($key), $step);
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::batchGet()
	 */
	public function batchGet(array $keys) {
		$_keys = array_map(array($this, 'buildSecurityKey'), $keys);
		$_datas = $this->memcache->getMulti($_keys);
		$_return = array();
		foreach ($keys as $_i => $key) {
			$_return[$key] = isset($_datas[$_keys[$_i]]) ? $this->formatData($key, $_datas[$_keys[$_i]]) : false;
		}
		return $_return;
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::buildData()
	*/
	protected function buildData($value, $expires = 0, IWindCacheDependency $dependency = null) {
		return $value;
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::formatData()
	*/
	protected function formatData($key, $value) {
		return $value;
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::setConfig()
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		$servers = $this->getConfig('servers', '', array());
		foreach ((array) $servers as $server) {
			if (!is_array($server)) throw new WindCacheException('[cache.strategy.WindMemCached.setConfig] The memcache config is incorrect');
			if (!isset($server['host'])) throw new WindCacheException('[cache.strategy.WindMemCached.setConfig] The memcache server ip address is not exist');
			if (!isset($server['port'])) throw new WindCacheException('[cache.strategy.WindMemCached.setConfig] The memcache server port is not exist');
			$this->memcache->addServer($server['host'], $server['port'], isset($server['weight']) ? $server['weight'] : null);
		}
	}
}