<?php
Wind::import('WIND:cache.AbstractWindCache');
/**
 * phpredisչredisCacheʵ
 * <note><b>ע⣺</b>ʹø͵Ļ棬Ҫװphpredisչ</note>
 * ļʽ
 * <code>
 * array(
 * 'security-code' => '',	//̳AbstractWindCache,ȫ.
 * 'key-prefix' => '', //̳AbstractWindCache,keyǰ׺.
 * 'expires' => '0',	//̳AbstractWindCache,ʱ.
 * 'auth' => '',	//֤룬redis->auth
 * 'servers' => array(
 * array(
 * 'host'=>'127.0.0.1',	//Ҫӵredis˼λ.
 * 'port'=>6379,	//Ҫӵredis˼Ķ˿.
 * 'timeout' => 0,	//ӳʱʱ䣨λ룩,Ĭֵ0.
 * 'pconn'=>true,	//Ƿʹó־û,Ĭtrue.
 * ),
 * ),
 * )
 * </code>
 * 1ͨĵķʽȥ:
 * <code>
 * Wind::import("WIND:cache.strategy.WindRedisCache");
 * $cache = new WindRedisCache();
 * $cache->setConfig(array('host' => '127.0.0.1', 'port' => 6379));
 * $cache->set('name', 'test');
 * echo $cache->get('name');
 * </code>
 * 2õķʽͨƵ
 * Ӧõcomponentsÿ,redisCache(<i>ֽõʱʹõ</i>):
 * <code>
 * //
 * 'redisCache' => array(
 * 'path' => 'WIND:cache.strategy.WindRedisCache',
 * 'scope' => 'singleton',
 * 'config' = array(
 * 'security-code' => '',
 * 'key-prefix' => '',
 * 'expires' => '0',
 * 'auth' => '',
 * 'servers' => array(
 * 'host1' => array(
 * 'host' => '127.0.0.1',
 * 'port' => 6379,
 * 'pconn' => true,
 * 'timeout' => 0,
 * ),
 * ),
 * ),
 * ),
 * //ʹã
 * $redis = Wind::getComponent('redisCache');
 * $redis->set('name', 'windFramework');
 * echo $redis->get('name');
 * </code>
 * 
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindRedisCache.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package wind.cache.strategy
 */
class WindRedisCache extends AbstractWindCache {
	/**
	 * redis
	 * 
	 * @var Redis
	 */
	protected $redis = null;
	
	/**
	 * redisʹõ֤
	 * 
	 * @var string
	 */
	protected $auth = '';

	/**
	 * 캯
	 * 
	 * @throws WindCacheException
	 */
	public function __construct() {
		$this->redis = new Redis();
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::setValue()
	 */
	protected function setValue($key, $value, $expires = 0) {
		$r = $this->redis->set($key, $value);
		if ($r && $expires) $this->redis->setTimeout($key, $expires);
		return $r;
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::addValue()
	 */
	protected function addValue($key, $value, $expires = 0) {
		$r = $this->redis->setnx($key, $value);
		if ($r && $expires) {
			$this->redis->setTimeout($key, $expires);
		}
		return $r;
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::getValue()
	 */
	protected function getValue($key) {
		return $this->redis->get($key);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::deleteValue()
	 */
	protected function deleteValue($key) {
		return $this->redis->delete($key);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::clear()
	 */
	public function clear() {
		$this->redis->flushAll();
	}
	
	/*
	 * //TODO ŵãع @see WindModule::__call()
	 */
	public function __call($methodName, $args) {
		if (!method_exists($this->redis, $methodName)) throw new WindCacheException('[cache.strategy.WindRedisCache] The method "' . $methodName . '" is no in redis');
		return call_user_func_array(array($this->redis, $methodName), $args);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::setConfig()
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		$auth = $this->getConfig('auth', '', '');
		if ($auth && (true !== $this->redis->auth($auth))) {
			throw new WindCacheException('[cache.strategy.WindRedisCache.setConfig] Authenticate the redis connection error');
		}
		$servers = $this->getConfig('servers', '', array());
		$defaultServer = array('host' => '', 'port' => 6379, 'timeout' => 0, 'pconn' => false, 'persistent_id' => '');
		foreach ((array) $servers as $server) {
			if (!is_array($server)) throw new WindCacheException('[cache.strategy.WindRedisCache.setConfig] The redis config is incorrect');
			$args = array_merge($defaultServer, $server);
			if (!isset($server['host'])) throw new WindCacheException('[cache.strategy.WindRedisCache.setConfig] The redis server ip address is not exist');
			$method = $args['pconn'] === true ? 'pconnect' : 'connect';
			$m_args = array($args['host'], $args['port'], $args['timeout']);
			// ǳӣһӵID
			($args['pconn'] === true && $args['persistent_id']) && $m_args[] = $args['persistent_id'];
			call_user_func_array(array($this->redis, $method), $m_args);
		}
	}
}