<?php
Wind::import('WIND:cache.AbstractWindCache');
/**
 * wincacheʵ
 * WindWinCache̳AbstractWindCache,ʵָṩĸԲӿ.
 * ṩԷʽӿ:
 * <ul>
 * <li>set($key, $value, $expire): ̳{@link AbstractWindCache::set()}.</li>
 * <li>get($key): ̳{@link AbstractWindCache::get()}.</li>
 * <li>delete($key): ̳{@link AbstractWindCache::delete()}.</li>
 * <li>batchGet($keys): ̳{@link AbstractWindCache::batchGet()}.</li>
 * <li>batchDelete($keys): ̳{@link AbstractWindCache::batchDelete()}.</li>
 * <li>setConfig($config): ̳{@link AbstractWindCache::setConfig()}.</li>
 * </ul>
 * ûԴAbstractWindCacheм̳
 * <code>
 * array(
 * 'security-code' => '',	//̳AbstractWindCache,ȫ
 * 'key-prefix' => '',		//̳AbstractWindCache,keyǰ׺
 * 'expires' => '0',	//̳AbstractWindCache,ʱ
 * )
 * </code>
 * <i>ʹ÷ʽ</i><br/>
 * 1ʹͨһʹø,:
 * <code>
 * Wind::import('WIND:cache.strategy.WindWinCache');
 * $cache = new WindWinCache();
 * $cache->set('name', 'windframework');
 * </code>
 * 2ͬʱΪ,WindWinCacheҲûͨõ÷ʽ,ͨܵøûв.
 * Ӧеÿ(components),ʹøΪwinCache£
 * <code>
 * 'winCache' => array(
 * 'path' => 'WIND:cache.strategy.WindwinCache',
 * 'scope' => 'singleton',
 * 'config' => array(
 * 'security-code' => '',
 * 'key-prefix' => '',
 * 'expires' => '0',
 * ),
 * ),
 * </code>
 * Ӧͨ·ʽʹ:
 * <code>
 * $cache = Wind::getComponent('winCache');	//עwinCacheƺõҪӦ
 * $cache->set('name', 'wf');
 * </code>
 * õ˵οһ.
 * <note><b>ע: </b>ҪʹWindWinCache,Ҫװwincacheչ֧.</note>
 * the last known user to change this file in the repository <LastChangedBy:
 * xiaoxiao >
 * 
 * @author xiaoxiao <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindWinCache.php 3791 2012-10-30 04:01:29Z liusanbian $
 * @package strategy
 */
class WindWinCache extends AbstractWindCache {
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::setValue()
	 */
	protected function setValue($key, $value, $expire = 0) {
		return wincache_ucache_set($key, $value, $expire);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::addValue()
	 */
	protected function addValue($key, $value, $expire = 0) {
		return wincache_ucache_add($key, $value, $expire);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::getValue()
	 */
	protected function getValue($key) {
		return wincache_ucache_get($key);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::deleteValue()
	 */
	protected function deleteValue($key) {
		return wincache_ucache_delete($key);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::clear()
	 */
	public function clear() {
		return wincache_ucache_clear();
	}
}