<?php
Wind::import('WIND:cache.AbstractWindCache');
/**
 * WindXCacheװxCacheʵֻ
 * ṩԷʽӿ:
 * <ul>
 * <li>set($key, $value, $expire): ̳{@link AbstractWindCache::set()}.</li>
 * <li>get($key): ̳{@link AbstractWindCache::get()}.</li>
 * <li>delete($key): ̳{@link AbstractWindCache::delete()}.</li>
 * <li>batchGet($keys): ̳{@link AbstractWindCache::batchGet()}.</li>
 * <li>batchDelete($keys): ̳{@link AbstractWindCache::batchDelete()}.</li>
 * <li>{@link setConfig($config)}: д˸{@link
 * AbstractWindCache::setConfig()}.</li>
 * </ul>
 * :
 * <code>
 * array(
 * 'user' => '',	//ӵxcacheݵȨû
 * 'pwd' => '',	//ӵxcacheݵȨû
 * 'security-code' => '',	//̳AbstractWindCache,ȫ
 * 'key-prefix' => '', //̳AbstractWindCache,keyǰ׺
 * 'expires' => '0',	//̳AbstractWindCache,ʱ
 * )
 * </code>
 * <i>xcacheʹ:</i><br/>
 * 1ʹͨһʹø:
 * <code>
 * Wind::import('WIND:cache.strategy.WindXCache');
 * $cache = new WindxCache();
 * $cache->set('name', 'windDbTest');
 * </code>
 * 2õķʽͨƵ
 * Ӧõcomponentsÿ,xCache(<i>ֽõʱʹõ</i>):
 * <code>
 * 'xCache' => array(
 * 'path' => 'WIND:cache.strategy.WindXCache',
 * 'scope' => 'singleton',
 * 'config' => array(
 * 'user' => '',
 * 'pwd' => '',
 * 'security-code' => '',
 * 'key-prefix' => '',
 * 'expires' => '0',
 * ),
 * ),
 * </code>
 * Ӧпͨ·ʽxCache:
 * <code>
 * $cache = Wind::getComponent('xCache');	//xCacheе
 * $cache->set('name', 'test');
 * </code>
 * <note><b>ע: </b>Ҫװչxcache.</note>
 * the last known user to change this file in the repository <LastChangedBy:
 * xiaoxiao >
 * 
 * @author xiaoxiao <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindXCache.php 3791 2012-10-30 04:01:29Z liusanbian $
 * @package strategy
 */
class WindXCache extends AbstractWindCache {
	/**
	 * ӵɾݵȨû
	 * xcacheջʱҪȨ޵û
	 * 
	 * @var string
	 */
	private $authUser = '';
	/**
	 * ӵɾݵȨû
	 * xcacheջʱҪȨ޵û
	 * 
	 * @var string
	 */
	private $authPwd = '';
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::setValue()
	 */
	protected function setValue($key, $value, $expire = 0) {
		return xcache_set($key, $value, $expire);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::addValue()
	 */
	protected function addValue($key, $value, $expire = 0) {
		return xcache_set($key, $value, $expire);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::getValue()
	 */
	protected function getValue($key) {
		return xcache_get($key);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::deleteValue()
	 */
	protected function deleteValue($key) {
		return xcache_unset($key);
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::clear()
	 */
	public function clear() {
		// xcache_clear_cacheҪ֤Ȩ
		$tmp['user'] = isset($_SERVER['PHP_AUTH_USER']) ? null : $_SERVER['PHP_AUTH_USER'];
		$tmp['pwd'] = isset($_SERVER['PHP_AUTH_PW']) ? null : $_SERVER['PHP_AUTH_PW'];
		$_SERVER['PHP_AUTH_USER'] = $this->authUser;
		$_SERVER['PHP_AUTH_PW'] = $this->authPwd;
		// xcache.var_count > 0 xcache_clear_cache(XC_TYPE_VAR, 0)ķʽɾ
		$max = xcache_count(XC_TYPE_VAR);
		for ($i = 0; $i < $max; $i++) {
			xcache_clear_cache(XC_TYPE_VAR, $i);
		}
		// ָ֮ǰȨ
		$_SERVER['PHP_AUTH_USER'] = $tmp['user'];
		$_SERVER['PHP_AUTH_PW'] = $tmp['pwd'];
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindCache::setConfig()
	 */
	public function setConfig($config = array()) {
		if (!$config) return false;
		parent::setConfig($config);
		$this->authUser = $this->getConfig('user');
		$this->authPwd = $this->getConfig('pwd');
	}
}