<?php
/**
 * в
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindCommandController.php 3859 2012-12-18 09:25:51Z yishuo $
 * @package command
 */
abstract class WindCommandController extends WindModule implements IWindController {

	/**
	 * ĬϵĲ
	 * 
	 * @return void
	 */
	abstract public function run();

	/**
	 * actionʼǰ
	 *
	 * @param AbstractWindRouter $handlerAdapter
	 */
	protected function beforeAction($handlerAdapter) {}

	/**
	 * action
	 *
	 * @param AbstractWindRouter $handlerAdapter
	 */
	protected function afterAction($handlerAdapter) {}
	
	/* (non-PHPdoc)
	 * @see IWindController::doAction()
	 */
	public function doAction($handlerAdapter) {
		$this->beforeAction($handlerAdapter);
		$action = $handlerAdapter->getAction();
		if ($action !== 'run') $action = $this->resolvedActionName($action);
		$args = $this->getRequest()->getRequest('argv');
		call_user_func_array(array($this, $action), $args);
		print_r($args);
		if ($this->errorMessage !== null) $this->getErrorMessage()->sendError();
		$this->afterAction($handlerAdapter);
		return $this->forward;
	}

	/**
	 * ģ
	 *
	 * @param string|array|object $data
	 * @param string $key
	 * @return void
	 */
	protected function setOutput($data, $key = '') {
		$this->getForward()->setVars($data, $key);
	}
	
	/*  */
	/**
	 * ӴϢ
	 *
	 * @param string $message
	 * @param string $key ĬΪַ
	 * @return void
	 */
	protected function addMessage($message, $key = '') {
		$this->getErrorMessage()->addError($message, $key);
	}

	/**
	 * һ
	 *
	 * @param string $message ĬΪַ
	 * @param string $key ĬΪַ
	 * @param string $errorAction ĬΪַ
	 * @return void
	 */
	protected function showMessage($message = '', $key = '', $errorAction = '') {
		$this->addMessage($message, $key);
		$errorAction && $this->getErrorMessage()->setErrorAction($errorAction);
		$this->getErrorMessage()->sendError();
	}
	
	// 	/**
	// 	 * ʾϢ
	// 	 * 
	// 	 * @param string $error
	// 	 */
	// 	protected function showError($error) {
	// 		echo "Error: " . $error . "\r\n";
	// 		echo "Try: command help -m someModule -c someController -a someAction";
	// 		exit();
	// 	}
	

	// 	/**
	// 	 * ʾϢ
	// 	 * 
	// 	 * @param string $message ĬΪַ
	// 	 * @return void
	// 	 */
	// 	protected function showMessage($message) {
	// 		if (is_array($message)) {
	// 			foreach ($message as $key => $value)
	// 				echo "'" . $key . "' => '" . $value . "',\r\n";
	// 		} else
	// 			echo $message, "\r\n";
	// 	}
	

	/**
	 * action
	 * 
	 * ĬϽ,actionƺ'Action'׺<code>
	 * actionΪ 'add',ӦĴΪ 'addAction',ͨǱ,޸Ľ</code>
	 * @param string $action
	 * @return void
	 */
	protected function resolvedActionName($action) {
		return $action . 'Action';
	}

	/**
	 * ȡ
	 *
	 * @return string
	 */
	protected function getLine($message) {
		echo $message;
		return trim(fgets(STDIN));
	}

	/**
	 *
	 * @return WindForward
	 */
	public function getForward() {
		return $this->_getForward();
	}

	/**
	 *
	 * @return WindErrorMessage
	 */
	public function getErrorMessage() {
		return $this->_getErrorMessage();
	}

	/**
	 *
	 * @param WindForward $forward
	 */
	public function setForward($forward) {
		$this->forward = $forward;
	}

	/**
	 *
	 * @param WindErrorMessage $errorMessage
	 */
	public function setErrorMessage($errorMessage) {
		$this->errorMessage = $errorMessage;
	}
}

?>