<?php
/**
 * request
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindCommandRequest.php 3668 2012-06-12 03:36:18Z yishuo $
 * @package command
 */
class WindCommandRequest implements IWindRequest {
	/**
	 * Ϣ
	 * 
	 * @var array
	 */
	private $_attribute = array();
	
	/**
	 * Ӧ
	 * 
	 * @var WindCommandResponse
	 */
	private $_response = null;

	/**
	 * û
	 * 
	 * @param string $key ȡĲname,ĬΪnull$_GET$_POSTֵ
	 * @param mixed $defaultValue ȡֵʧܵʱ򷵻ȱʡֵ,ĬֵΪnull
	 * @return mixed
	 */
	public function getRequest($key, $defaultValue = null) {
		if (isset($_SERVER[$key])) return $_SERVER[$key];
		if (isset($_ENV[$key])) return $_ENV[$key];
		return $defaultValue;
	}

	/**
	 * ƻ÷ִлϢ
	 * 
	 * Ҫȡ˳Ϊ_attribute$_SERVER$_ENV
	 * 
	 * @param string $name ȡݵkeyֵ
	 * @param string $defaultValue ȱʡֵ,ȡֵʧܵʱ򷵻ȱʡֵ,ĬϸֵΪִ
	 * @return string|object|array ػֵ
	 */
	public function getAttribute($key, $defaultValue = '') {
		if (isset($this->_attribute[$key]))
			return $this->_attribute[$key];
		else if (isset($_SERVER[$key]))
			return $_SERVER[$key];
		else if (isset($_ENV[$key]))
			return $_ENV[$key];
		else
			return $defaultValue;
	}

	/**
	 * 
	 * 
	 * @param string|array|object $data Ҫõ
	 * @param string $key õݱõkey,ĬΪ,object͵ʱ򽫻ִarray_merge
	 * @return void
	 */
	public function setAttribute($data, $key = '') {
		if ($key) {
			$this->_attribute[$key] = $data;
			return;
		}
		if (is_object($data)) $data = get_object_vars($data);
		if (is_array($data)) $this->_attribute = array_merge($this->_attribute, $data);
	}

	/**
	 * 
	 * 
	 * @return string  
	 */
	public function getRequestType() {
		return 'command';
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::getPathInfo()
	 */
	public function getPathInfo() {
		return '';
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::getHostInfo()
	 */
	public function getHostInfo() {
		return '';
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::getServerName()
	 */
	public function getServerName() {
		return '';
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::getServerPort()
	 */
	public function getServerPort() {
		return '';
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::getResponse()
	 */
	public function getResponse() {
		if ($this->_response === null) {
			$this->_response = new WindCommandResponse();
		}
		return $this->_response;
	}
	
	/* (non-PHPdoc)
	 * @see IWindRequest::getAcceptLanguage()
	 */
	public function getAcceptLanguage() {
		return '';
	}
}

?>