<?php
/**
 * dbඨ
 * 
 * @author Qiong Wu <papa0924@gmail.com> 2011-9-22
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AbstractWindPdoAdapter.php 3113 2011-11-11 07:28:09Z yishuo $
 * @package db
 */
abstract class AbstractWindPdoAdapter extends PDO {
	private $_typeMap = array(
		'boolean' => PDO::PARAM_BOOL, 
		'integer' => PDO::PARAM_INT, 
		'string' => PDO::PARAM_STR, 
		'NULL' => PDO::PARAM_NULL);

	/**
	 * ð󶨲
	 * 
	 * @param string $variable
	 * @return int
	 */
	protected function _getPdoDataType($variable) {
		return isset($this->_typeMap[gettype($variable)]) ? $this->_typeMap[gettype($variable)] : PDO::PARAM_STR;
	}

	/* (non-PHPdoc)
	 * @see PDO::quote()
	 */
	public function quote($value, $type = null) {
		if (is_array($value) || is_object($value)) return "''";
		return parent::quote($value, $type ? $type : $this->_getPdoDataType(gettype($value)));
	}

	/**
	 * SQLԪݣݿ(ֶ֣ε)
	 *
	 * @param array $data
	 * @return string
	 */
	abstract public function fieldMeta($data);

	/**
	 * 鲢װ key=value ʽSQLѯֵ(insert/update)
	 * 
	 * @param array $array
	 * @return string
	 */
	abstract public function sqlSingle($array);
	
	/**
	 * 鲢תΪsqlַ
	 *
	 * @param array $variable  Ҫװ
	 * @return string
	 */
	abstract public function quoteArray($variable);
	
	/** 
	 * ˶ά齫תΪsqlַ
	 *
	 * @param array $var
	 * @return string
	 */
	abstract public function quoteMultiArray($var);

	/**
	 * ݱ
	 * 
	 * ݱ<note><b>ע:</b>һ'$replace',ȡֵ'true,false',ֵΪfalseʱʾݱڲ±,
	 * ֵΪtrueʱɾѾڵݱ±</note>
	 * @param string $tableName ݱ
	 * @param string|array $values ݱֶϢ
	 * @param boolean $replace ѾǷ񸲸,ֵtrue|false
	 * @return boolean
	 */
	abstract public function createTable($tableName, $values, $replace = false);

	/**
	 * ݿõı뷽ʽ
	 *
	 * @param string $charset ʽ
	 */
	abstract public function setCharset($charset);

}

?>