<?php
Wind::import("WIND:db.exception.WindDbException");
Wind::import("WIND:db.WindSqlStatement");
Wind::import("WIND:db.WindResultSet");
/**
 * ݿ,ṩݿӷ,Լݲ.
 * 
 * ṩ˻ӷ,ʹ:<code>
 * $connection = new WindConnection('mysql:host=localhost;dbname=test', 'root', 'root');
 * $stm = $connection->createStatement('SELECT * FROM {members} WHERE uid<=:uid', true);
 * $stm->queryAll();
 * //ʵʵ:
 * 'db' => array(
 * 'path' => 'WIND:db.WindConnection',
 * 'scope' => 'singleton',
 * 'config' => array(
 * 'resource' => 'db_config.php',
 * ),),
 * //db_config :
 * array(
 * 'dsn' => 'mysql:host=localhost;dbname=test',
 * 'user' => 'root',
 * 'pwd' => 'root',
 * 'charset' => 'utf8')
 * </code>
 *
 * @author Qiong Wu <papa0924@gmail.com> 2011-9-23
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindConnection.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package db
 */
class WindConnection extends WindModule {
	/**
	 * ַ,Я,Ϣ,
	 * 
	 * <code>mysql:host=localhost;dbname=test</code>
	 * @var string
	 */
	protected $_dsn;
	/**
	 * 
	 *
	 * @var string
	 */
	protected $_driverName;
	/**
	 * û
	 *
	 * @var string
	 */
	protected $_user;
	/**
	 * 
	 *
	 * @var string
	 */
	protected $_pwd;
	/**
	 * ݱǰ׺
	 *
	 * @var string
	 */
	protected $_tablePrefix;
	/**
	 * ӱ뷽ʽ
	 * 
	 * @var string
	 */
	protected $_charset;
	/**
	 * ֵ
	 * 
	 * @var array
	 */
	protected $_attributes = array();
	/**
	 * Ӿ
	 * 
	 * @var PDO
	 */
	protected $_dbHandle = null;

	/**
	 * @param string $dsn
	 * @param string $username
	 * @param string $password
	 */
	public function __construct($dsn = '', $username = '', $password = '') {
		$this->_dsn = $dsn;
		$this->_user = $username;
		$this->_pwd = $password;
	}

	/**
	 * һsql䣬sqlStatement
	 * 
	 * @param string $sql sql
	 * @return WindSqlStatement
	 */
	public function createStatement($sql = null) {
		/* @var $statement WindSqlStatement */
		$statement = Wind::getComponent('sqlStatement');
		$statement->setConnection($this);
		$statement->setQueryString($this->parseQueryString($sql));
		return $statement;
	}

	/**
	 * ݿӶ
	 * 
	 * @return AbstractWindPdoAdapter
	 */
	public function getDbHandle() {
		$this->init();
		return $this->_dbHandle;
	}

	/**
	 * 
	 * 
	 * @param string $attribute
	 * @return string
	 * */
	public function getAttribute($attribute) {
		if ($this->_dbHandle !== null) {
			return $this->_dbHandle->getAttribute($attribute);
		} else
			return isset($this->_attributes[$attribute]) ? $this->_attributes[$attribute] : '';
	}

	/**
	 * 
	 * 
	 * @param string $attribute
	 * @param string $value ĬֵΪnull
	 * @return void
	 */
	public function setAttribute($attribute, $value = null) {
		if (!$attribute) return;
		if ($this->_dbHandle !== null) {
			$this->_dbHandle->setAttribute($attribute, $value);
		} else
			$this->_attributes[$attribute] = $value;
	}

	/**
	 * DB
	 * 
	 * @return string
	 */
	public function getDriverName() {
		if ($this->_driverName) return $this->_driverName;
		if ($this->_dbHandle !== null) {
			$this->_driverName = $this->_dbHandle->getAttribute(PDO::ATTR_DRIVER_NAME);
		} elseif (($pos = strpos($this->_dsn, ':')) !== false) {
			$this->_driverName = strtolower(substr($this->_dsn, 0, $pos));
		}
		return $this->_driverName;
	}

	/**
	 * ִһsql ͬʱӰ
	 * 
	 * @param string $sql sql
	 * @return int
	 */
	public function execute($sql) {
		try {
			$statement = $this->createStatement($sql);
			return $statement->execute();
		} catch (PDOException $e) {
			$this->close();
			throw new WindDbException('[db.WindConnection.execute] ' . $e->getMessage(). "\r\nSQL:$sql", WindDbException::DB_QUERY_ERROR);
		}
	}

	/**
	 * ִһѯͬʱؽ
	 * @param string $sql sql
	 * @return WindResultSet
	 */
	public function query($sql) {
		try {
			$sql = $this->parseQueryString($sql);
			return new WindResultSet($this->getDbHandle()->query($sql));
		} catch (PDOException $e) {
			throw new WindDbException('[db.WindConnection.query] ' . $e->getMessage(). "\r\nSQL:$sql", WindDbException::DB_QUERY_ERROR);
		}
	}

	/**
	 * SQLԪݣݿ(ֶ֣ε)
	 * 
	 * @param string $data
	 * @throws WindDbException
	 */
	public function sqlMetadata($data) {
		return $this->getDbHandle()->fieldMeta($data);
	}

	/**
	 * תΪַöŷָÿԪֶ֧ά
	 * 
	 * @param array $array
	 * @return string
	 */
	public function quoteArray($array) {
		return $this->getDbHandle()->quoteArray($array);
	}

	/**
	 * ˶ά齫תΪsqlַ
	 *
	 * @param array $array
	 * @return string
	 */
	public function quoteMultiArray($array) {
		return $this->getDbHandle()->quoteMultiArray($array);
	}

	/**
	 * sqlԪݰȫ,ع˺ֵ
	 * 
	 * @param string $string
	 * @return string
	 */
	public function quote($string) {
		return $this->getDbHandle()->quote($string);
	}

	/**
	 * ֵ(insert/update)sqlʽ
	 * 
	 * ÷һ,аȫ,װ key=value ʽSQLѯֵ (insert/update valueֵװ).
	 * ÷ľʵָݿͲͬͬ.
	 * @param array $array
	 * @return string
	 * @see AbstractWindPdoAdapter::sqlSingle()
	 */
	public function sqlSingle($array) {
		return $this->getDbHandle()->sqlSingle($array);
	}

	/**
	 * ,Ƿ񴴽ɹ
	 * 
	 * Ƿ񴴽ɹ'$values'ΪֶϢ.÷ľʵָݿͲͬͬ.
	 * @param string $tableName 
	 * @param array $values ֵֶϢ
	 * @param boolean $replace Ƿ񸲸
	 * @return boolean
	 * @see AbstractWindPdoAdapter::createTable()
	 */
	public function createTable($tableName, $values, $replace = false) {
		return $this->getDbHandle()->createTable($tableName, $values, $replace);
	}

	/**
	 * һֵ,һ'name'÷,򷵻'name'Ӧֵ
	 * 
	 * @param string $name ĬΪַ
	 * @return int 
	 */
	public function lastInsertId($name = '') {
		if ($name)
			return $this->getDbHandle()->lastInsertId($name);
		else
			return $this->getDbHandle()->lastInsertId();
	}

	/**
	 * رݿ
	 * 
	 * @return void
	 */
	public function close() {
		$this->_dbHandle = null;
	}

	/**
	 * ʼDB
	 * 
	 * @return void
	 * @throws WindDbException
	 */
	public function init() {
		try {
			if ($this->_dbHandle !== null) return;
			$driverName = $this->getDriverName();
			$dbHandleClass = "WIND:db." . $driverName . ".Wind" . ucfirst($driverName) . "PdoAdapter";
			$dbHandleClass = Wind::import($dbHandleClass);
			$this->_dbHandle = new $dbHandleClass($this->_dsn, $this->_user, $this->_pwd, (array) $this->_attributes);
			$this->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$this->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, true);
			$this->_dbHandle->setCharset($this->_charset);
		} catch (PDOException $e) {
			$this->close();
			throw new WindDbException('[db.WindConnection.init] ' . $e->getMessage());
		}
	}

	/**
	 * (non-PHPdoc)
	 * @see WindModule::setConfig()
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		$this->_initConfig();
		$this->_attributes = array();
	}

	/**
	 * ϢʼǰӶ
	 * 
	 * @param array $config ,ĬΪ
	 */
	protected function _initConfig($config = array()) {
		$this->_dsn = $this->getConfig('dsn', '', '', $config);
		$this->_user = $this->getConfig('user', '', '', $config);
		$this->_pwd = $this->getConfig('pwd', '', '', $config);
		$this->_charset = $this->getConfig('charset', '', '', $config);
		$this->_tablePrefix = $this->getConfig('tableprefix', '', '', $config);
	}

	/**
	 * ǰѯ,ؽ
	 * 
	 * @param string $sql
	 */
	protected function parseQueryString($sql) {
		if ($_prefix = $this->getTablePrefix()) {
			list($new, $old) = explode('|', $_prefix . '|');
			$sql = preg_replace('/{{(' . $old . ')?(.*?)}}/', $new . '\2', $sql);
		}
		return $sql;
	}

	/**
	 * ñǰ׺
	 * 
	 * @return string $tablePrefix
	 */
	public function getTablePrefix() {
		return $this->_tablePrefix;
	}

	/**
	 * ñǰ׺
	 * 
	 * @param string $tablePrefix
	 */
	public function setTablePrefix($tablePrefix) {
		$this->_tablePrefix = $tablePrefix;
	}
}
?>