<?php
Wind::import("WIND:db.WindConnection");
/**
 * ݿӹ
 * ˵<code>
 * 1. ûκβԲʱ ĬϷصǰеĵһӾ
 * 2. ûκβԲʱsqlӾָʱ򷵻ָӾ
 * 磺'{db1:tableName}'db1ָӾ
 * 3. ǰвԲʱղԲ򷵻
 * 4. createStatement($sql = null, $forceMaster = false)
 * $forceMasterΪtrueʱǿ
 * øʽ£
 * <connections except='*:db1;user*,tablename2:db1|db2;'>
 * <connection name='db1'>
 * <dsn>mysql:host=localhost;dbname=test</dsn>
 * <user>root</user>
 * <pwd>root</pwd>
 * <charset>utf8</charset>
 * <tablePrefix>pw_</tablePrefix>
 * </connection>
 * <connection name='db2'>
 * <dsn>mysql:host=localhost;dbname=test</dsn>
 * <user>root</user>
 * <pwd>root</pwd>
 * <charset>utf8</charset>
 * <tablePrefix>pw_</tablePrefix>
 * </connection>
 * </connections></code>
 * 
 * @author Qiong Wu <papa0924@gmail.com> 2011-9-23
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindConnectionManager.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package db
 */
class WindConnectionManager extends WindConnection {
	/**
	 * ͨ
	 * 
	 * @var string
	 */
	private $wildcard = '*';
	/**
	 * ӳ,ʱ浱ǰݿӾ
	 * 
	 * @var array
	 */
	private $pool = array();
	/**
	 * ǰݱ
	 * 
	 * @var string
	 */
	private $tableName;
	/**
	 * ǰsqlѯ
	 * 
	 * @var string
	 */
	private $sqlType;
	/**
	 * ݿӳزԲϢ
	 * 
	 * @var array
	 */
	private $except = array('_current' => '', '_default' => array(), '_except' => array(), '_db' => array());
	
	/**
	 * Ƿǿ,ĬΪfalse
	 * 
	 * @var boolean
	 */
	private $forceMaster = false;
	
	/*
	 * (non-PHPdoc) @see WindConnection::createStatement()
	 */
	public function createStatement($sql = null, $forceMaster = false) {
		$this->forceMaster = $forceMaster;
		return parent::createStatement($sql);
	}
	
	/*
	 * (non-PHPdoc) @see WindConnection::getDbHandle()
	 */
	public function getDbHandle() {
		$this->init();
		return $this->_dbHandle;
	}
	
	/*
	 * (non-PHPdoc) @see WindConnection::init()
	 */
	public function init() {
		try {
			if (!isset($this->pool[$this->except['_current']])) {
				parent::init();
				$this->pool[$this->except['_current']] = $this->_dbHandle;
			} else
				$this->_dbHandle = $this->pool[$this->except['_current']];
		} catch (PDOException $e) {
			$this->close();
			throw new WindDbException('[db.WindConnectionManager.init] ' . $e->getMessage());
		}
	}
	
	/*
	 * (non-PHPdoc) @see WindConnection::parseQueryString()
	 */
	protected function parseQueryString($sql) {
		$sql = preg_replace_callback(
			'/^([a-zA-Z]*)\s[\w\*\s]+(\{\{([\w]+\:)?([\w]+\.)?([\w]+)\}\})?[\w\s\<\=\:]*/i', 
			array($this, '_pregQueryString'), $sql);
		if (!$this->except['_current']) {
			if (!isset($this->except['_db'][$this->tableName])) {
				foreach ((array) $this->except['_except'] as $value) {
					preg_match('/' . str_replace($this->wildcard, '\w*', $value) . '/i', 
						$this->tableName, $matchs);
					if (!empty($matchs)) {
						$_c = $this->except['_db'][$value];
						break;
					}
				}
				$_c || $_c = $this->except['_default'];
			} else
				$_c = $this->except['_db'][$this->tableName];
			$this->_resolveCurrentDb($_c);
		}
		if ($this->except['_current']) {
			$_config = $this->getConfig($this->except['_current']);
			if (!$_config) throw new WindDbException(
				'[db.WindConnectionManager.parseQueryString] db connection ' . $this->except['_current'] . ' is not exist.');
			parent::_initConfig($_config);
		}
		return parent::parseQueryString($sql);
	}

	/**
	 * ݵǰsql,һнϢ,õǰdb
	 * 
	 * @param array $_c
	 * @return void
	 */
	private function _resolveCurrentDb($_c) {
		if (empty($_c) || empty($_c['_m'])) throw new WindDbException(
			'[db.WindConnectionManager._resolveCurrentDb] db error.', 
			WindDbException::DB_BUILDER_NOT_EXIST);
		
		switch ($this->sqlType) {
			case 'SELECT':
				if (!$this->forceMaster && !empty($_c['_s'])) {
					$_count = count($_c['_s']);
					$_index = $_count > 1 ? mt_rand(0, $_count - 1) : 0;
					$this->except['_current'] = $_c['_s'][$_index];
					break;
				}
			default:
				$this->except['_current'] = $_c['_m'];
				break;
		}
	}

	/**
	 * sql
	 * sql,sqlȡݿϢ,ؽsql<code>
	 * Array(
	 * [0] => SELECT * FROM {db1:database.members} WHERE uid<=:uid	| ƥ䵽str
	 * [1] => SELECT												| ǰsql
	 * [2] => {db1:database.members}								| ǰtable
	 * [3] => db1:													| ǰtableԶ
	 * [4] => database.												| ǰdatabase
	 * [5] => members												| ǰ
	 * )</code>
	 * 
	 * @param array $matchs
	 * @return string
	 */
	private function _pregQueryString($matchs) {
		$this->sqlType = $matchs[1];
		if (isset($matchs[2])) {
			$this->tableName = $matchs[5];
			$this->except['_current'] = trim($matchs[3], ':');
			$matchs[0] = str_replace($matchs[3] . $matchs[4], '', $matchs[0]);
		} else
			$this->except['_current'] = $this->tableName = '';
		return $matchs[0];
	}
	
	/*
	 * (non-PHPdoc) @see WindConnection::_initConfig()
	 */
	protected function _initConfig() {
		$_except = $this->getConfig('connections', 'except');
		unset($this->_config['connections']['except']);
		$this->_config = $this->_config['connections'];
		$_dbNames = array_keys($this->_config);
		if (empty($_dbNames)) throw new WindDbException(
			'[db.WindConnectionManager._initConfig] db config is required.');
		$this->_resetConnection($_dbNames[0]);
		$this->except['_default']['_m'] = $_dbNames[0];
		if ($_except) preg_replace_callback('/([\w\*\,]+):([\w]+)\|*([\w\,]+)*/i', 
			array($this, '_pregExcept'), $_except);
	}

	/**
	 * Ϣ
	 * 
	 * @param string $db
	 * @return void
	 */
	private function _resetConnection($db) {
		$_config = $this->getConfig($db);
		if (!$_config) throw new WindDbException(
			'[db.WindConnectionManager._initConfig] db connection ' . $db . ' is not exist.');
		parent::_initConfig($_config);
	}

	/**
	 * ӹӲ
	 * dbӹϢ:<code>except='*:(db1);user*,tablename2:(db1|db2);'</code>
	 * һ'*:(db1);'һ,ʽ:'tableName1,tableName2,tableName3:(db1|db2,db3,db4)'.
	 * ݱ':',':'ǰʾһݱ,ǶҲһ,','.
	 * ':''()'бʾһݲ,вԵ˼'db1'(master),'db2,db3,db4'Ϊ(slaves).
	 * ÷ݿ,洢 'except' .
	 * 
	 * @param array $matchs
	 * @return void
	 */
	private function _pregExcept($matchs) {
		$_keys = explode(',', $matchs[1]);
		foreach ($_keys as $_v) {
			if ($_v === $this->wildcard) {
				$this->except['_default']['_m'] = $matchs[2];
				$this->except['_default']['_s'] = isset($matchs[3]) ? explode(',', $matchs[3]) : array();
				break;
			}
			if (strpos($_v, $this->wildcard) !== false) $this->except['_except'][] = $_v;
			$this->except['_db'][$_v]['_m'] = $matchs[2];
			$this->except['_db'][$_v]['_s'] = isset($matchs[3]) ? explode(',', $matchs[3]) : array();
		}
	}
}