<?php
/**
 * sqlѯ
 * 
 * @author Qiong Wu <papa0924@gmail.com> 2011-9-23
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindResultSet.php 3829 2012-11-19 11:13:22Z yishuo $
 * @package db
 */
class WindResultSet {
	/**
	 *
	 * @var PDOStatement
	 */
	private $_statement = null;
	/**
	 * PDO fetchMode, default fetchMode PDO::FETCH_ASSOC
	 * 
	 * @var number
	 */
	private $_fetchMode = PDO::FETCH_ASSOC;
	/**
	 * PDO fetchType, default fetchType PDO::FETCH_ORI_FIRST
	 * 
	 * @var number
	 */
	private $_fetchType = PDO::FETCH_ORI_FIRST;
	private $_columns = array();

	/**
	 *
	 * @param WindSqlStatement $sqlStatement
	 *        Ԥ
	 * @param int $fetchMode
	 *        ýģʽPDO::FETCH_BOTH/PDO::FETCH_ASSOC/PDO::FETCH_NUM
	 * @param int $fetchType
	 *        ýĶȡʽPDO::FETCH_ORI_NEXT/PDO::FETCH_ORI_PREעҪʹøԣ
	 *        ͨsetAttributePDO::ATTR_CURSOR=PDO::CURSOR_SCROLL
	 */
	public function __construct($sqlStatement, $fetchMode = 0, $fetchType = 0) {
		if ($sqlStatement instanceof WindSqlStatement) {
			$this->_statement = $sqlStatement->getStatement();
			$this->_columns = $sqlStatement->getColumns();
		} else
			$this->_statement = $sqlStatement;
		if ($fetchMode != 0) $this->_fetchMode = $fetchMode;
		if ($fetchType != 0) $this->_fetchType = $fetchType;
	}

	/**
	 * ûȡģʽ
	 * 
	 * @param int $fetchMode
	 *        ûȡģʽPDO::FETCH_BOTH/PDO::FETCH_ASSOC/PDO::FETCH_NUM...
	 * @param boolean $flush
	 *        ǷͳһPDOStatementеĻȡʽ
	 */
	public function setFetchMode($fetchMode, $flush = false) {
		$this->_fetchMode = $fetchMode;
		$flush && $this->_statement->setFetchMode($fetchMode);
	}

	/**
	 * һSqlӰ
	 * 
	 * @return int
	 */
	public function rowCount() {
		return $this->_statement->rowCount();
	}

	/**
	 * ؽе
	 * 
	 * @return number
	 */
	public function columnCount() {
		return $this->_statement->columnCount();
	}

	/**
	 * ýһ
	 * 
	 * @param int $fetchMode
	 *        ýģʽPDO::FETCH_BOTH/PDO::FETCH_ASSOC/PDO::FETCH_NUM
	 * @param int $fetchType
	 *        ýĶȡʽPDO::FETCH_ORI_NEXT/PDO::FETCH_ORI_PREעҪʹøԣ
	 *        StatementPDO::ATTR_CURSOR=PDO::CURSOR_SCROLL
	 * @return array
	 */
	public function fetch($fetchMode = 0, $fetchType = 0) {
		if ($fetchMode === 0) $fetchMode = $this->_fetchMode;
		if ($fetchType === 0) $fetchType = $this->_fetchType;
		return $this->_fetch($fetchMode, $fetchType);
	}

	/**
	 *
	 * @param string $fetchMode        
	 * @param string $fetchType        
	 */
	private function _fetch($fetchMode, $fetchType) {
		if (!empty($this->_columns)) $fetchMode = PDO::FETCH_BOUND;
		$result = array();
		if ($row = $this->_statement->fetch($fetchMode, $fetchType)) {
			if (empty($this->_columns))
				$result = $row;
			else
				foreach ($this->_columns as $key => $value) {
					$result[$key] = $value;
				}
		}
		return $result;
	}

	/**
	 * еĲѯ
	 * 
	 * @param string $index
	 *        ±
	 * @param int $fetchMode
	 *        ýģʽPDO::FETCH_BOTH/PDO::FETCH_ASSOC/PDO::FETCH_NUM
	 * @return array
	 */
	public function fetchAll($index = '', $fetchMode = 0) {
		if ($fetchMode === 0) $fetchMode = $this->_fetchMode;
		$result = array();
		if (!$index)
			while ($row = $this->fetch($fetchMode))
				$result[] = $row;
		else
			while ($row = $this->fetch($fetchMode)) {
				if (!isset($row[$index])) continue;
				$result[$row[$index]] = $row;
			}
		return $result;
	}

	/**
	 * һм¼л±$indexֵȡʧ򷵻false
	 * 
	 * @param int $index
	 *        ±
	 * @return string bool
	 */
	public function fetchColumn($index = 0) {
		return $this->_statement->fetchColumn($index);
	}

	/**
	 * ýеһУͬʱõ෵û򷵻صʹStdClass
	 * 
	 * @param string $className
	 *        ʹõ
	 * @param array $ctor_args
	 *        ʼ
	 * @return object
	 */
	public function fetchObject($className = '', $ctor_args = array()) {
		if ($className === '')
			return $this->_statement->fetchObject();
		else
			return $this->_statement->fetchObject($className, $ctor_args);
	}
}
?>