<?php
Wind::import("WIND:db.exception.WindDbException");
Wind::import("WIND:db.WindResultSet");
/**
 * sql䴦,װ˻sql
 * 
 * ʵ˻,ݰ,Լѯӿ.
 * ͨ'WindConnection''createStatement()',Իһstatement.
 *
 * @author Qiong Wu <papa0924@gmail.com> 2011-9-23
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindSqlStatement.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package db
 */
class WindSqlStatement {
	/**
	 * @var WindConnection
	 */
	private $_connection;
	/**
	 * @var PDOStatement
	 */
	private $_statement = null;
	/**
	 * @var string
	 */
	private $_queryString;
	/**
	 * PDOӳ
	 * 
	 * @var array
	 */
	private $_typeMap = array(
		'boolean' => PDO::PARAM_BOOL, 
		'integer' => PDO::PARAM_INT, 
		'string' => PDO::PARAM_STR, 
		'NULL' => PDO::PARAM_NULL);
	/**
	 * @var array
	 */
	private $_columns = array();
	/**
	 * @var array
	 */
	private $_param = array();

	/**
	 * @param WindConnection $connection   WindConnection
	 * @param string $query  Ԥ
	 */
	public function __construct($connection = null, $query = '') {
		$connection && $this->_connection = $connection;
		$query && $this->setQueryString($query);
	}

	/**
	 * 
	 * 
	 * @param mixed $parameter   ԤĴ󶨵λ
	 * @param mixed &$variable   󶨵ֵ
	 * @param int $dataType    ֵ(PDO::PARAM_STR/PDO::PARAM_INT...)
	 * @param int $length         ֵĳ
	 * @param mixed $driverOptions   
	 * @return WindSqlStatement
	 * @see PDOStatement::bindParam()
	 * @throws WindDbException
	 */
	public function bindParam($parameter, &$variable, $dataType = null, $length = null, $driverOptions = null) {
		try {
			if ($dataType === null) {
				$dataType = $this->_getPdoDataType($variable);
			}
			if ($length === null)
				$this->getStatement()->bindParam($parameter, $variable, $dataType);
			else
				$this->getStatement()->bindParam($parameter, $variable, $dataType, $length, $driverOptions);
			$this->_param[$parameter] = $variable;
			return $this;
		} catch (PDOException $e) {
			throw new WindDbException('[db.WindSqlStatement.bindParam] ' . $e->getMessage());
		}
	}

	/**
	 * 󶨱
	 * 
	 * һά飬ʹkey=>valueʽkeyλãvalue滻ֵ滻ֵҪֵͨж---׼ȷ
	 * һά飬key=>array(0=>value, 1=>data_type, 2=>length, 3=>driver_options)ķʽݱ
	 * 
	 * @param array $parameters 
	 * @return WindSqlStatement
	 * @see PDOStatement::bindParam()
	 * @throws WindDbException
	 */
	public function bindParams(&$parameters) {
		if (!is_array($parameters)) throw new WindDbException(
			'[db.WindSqlStatement.bindParams] Error unexpected paraments type ' . gettype($parameters));
		
		$keied = (array_keys($parameters) !== range(0, sizeof($parameters) - 1));
		foreach ($parameters as $key => $value) {
			$_key = $keied ? $key : $key + 1;
			if (is_array($value)) {
				$dataType = isset($value[1]) ? $value[1] : $this->_getPdoDataType($value[0]);
				$length = isset($value[2]) ? $value[2] : null;
				$driverOptions = isset($value[3]) ? $value[3] : null;
				$this->bindParam($_key, $parameters[$key][0], $dataType, $length, $driverOptions);
			} else
				$this->bindParam($_key, $parameters[$key], $this->_getPdoDataType($value));
		}
		return $this;
	}

	/**
	 * 
	 * 
	 * @param string $parameter  ԤĴ󶨵λ
	 * @param string $value      󶨵ֵ
	 * @param int $data_type     ֵ
	 * @return WindSqlStatement
	 * @see PDOStatement::bindValue()
	 * @throws WindDbException
	 */
	public function bindValue($parameter, $value, $data_type = null) {
		try {
			if ($data_type === null) $data_type = $this->_getPdoDataType($value);
			$this->getStatement()->bindValue($parameter, $value, $data_type);
			$this->_param[$parameter] = $value;
			return $this;
		} catch (PDOException $e) {
			throw new WindDbException('[db.WindSqlStatement.bindValue] ' . $e->getMessage());
		}
	}

	/**
	 * bindValue󶨲
	 * 
	 * @param array $values 󶨵Ĳֵ
	 * @return WindSqlStatement
	 * @see PDOStatement::bindValue()
	 * @throws WindDbException
	 */
	public function bindValues($values) {
		if (!is_array($values)) throw new WindDbException(
			'[db.WindSqlStatement.bindValues] Error unexpected paraments type \'' . gettype($values) . '\'');
		
		$keied = (array_keys($values) !== range(0, sizeof($values) - 1));
		foreach ($values as $key => $value) {
			if (!$keied) $key = $key + 1;
			$this->bindValue($key, $value, $this->_getPdoDataType($value));
		}
		return $this;
	}

	/**
	 * еPHP
	 * 
	 * @param mixed $column Ҫ󶨵ֶбֶҲֶεĶӦ±
	 * @param mixed &$param  Ҫ󶨵php
	 * @param int $type  PDO::PARAM_*
	 * @param int $maxlen  A hint for pre-allocation.
	 * @param mixed $driverdata  Optional parameter(s) for the driver. 
	 * @return WindSqlStatement
	 * @see PDOStatement::bindColumn()
	 * @throws WindDbException
	 */
	public function bindColumn($column, &$param = '', $type = null, $maxlen = null, $driverdata = null) {
		try {
			if ($type == null) $type = $this->_getPdoDataType($param);
			if ($type == null)
				$this->getStatement()->bindColumn($column, $param);
			elseif ($maxlen == null)
				$this->getStatement()->bindColumn($column, $param, $type);
			else
				$this->getStatement()->bindColumn($column, $param, $type, $maxlen, $driverdata);
			$this->_columns[$column] = & $param;
			return $this;
		} catch (PDOException $e) {
			throw new WindDbException('[db.WindSqlStatement.bindColumn] ' . $e->getMessage());
		}
	}

	/**
	 * еPHP
	 * 
	 * @param array $columns 󶨵
	 * @param array &$param  Ҫ󶨵php
	 * @see PDOStatement::bindColumn()
	 * @return WindSqlStatement
	 */
	public function bindColumns($columns, &$param = array()) {
		$int = 0;
		foreach ($columns as $value) {
			$this->bindColumn($value, $param[$int++]);
		}
		return $this;
	}

	/**
	 * 󶨲ִSQL䣬ظӰ
	 * 
	 * @param array $params ԤҪ󶨵Ĳ
	 * @param boolean $rowCount Ƿ񷵻Ӱ
	 * @return int|boolean
	 * @throws WindDbException
	 */
	public function update($params = array(), $rowCount = false) {
		return $this->execute($params, $rowCount);
	}

	/**
	 * 󶨲ִSQL䣬زѯ
	 * 
	 * @param array $params  ԤҪ󶨵Ĳ
	 * @param int $fetchMode  ýģʽPDO::FETCH_BOTH/PDO::FETCH_ASSOC/PDO::FETCH_NUM
	 * @param int $fetchType ýĶȡʽPDO::FETCH_ORI_NEXT/PDO::FETCH_ORI_PREעҪʹøԣͨsetAttributePDO::ATTR_CURSOR=PDO::CURSOR_SCROLL
	 * @return WindResultSet
	 */
	public function query($params = array(), $fetchMode = 0, $fetchType = 0) {
		$this->execute($params, false);
		return new WindResultSet($this, $fetchMode, $fetchType);
	}

	/**
	 * 󶨲ִSQL䣬زѯ
	 * 
	 * @param array $params  ԤҪ󶨵Ĳ
	 * @param string $index  ص±Ӧֶ
	 * @param int $fetchMode  ýģʽPDO::FETCH_BOTH/PDO::FETCH_ASSOC/PDO::FETCH_NUM
	 * @param int $fetchType ýĶȡʽPDO::FETCH_ORI_NEXT/PDO::FETCH_ORI_PREעҪʹøԣͨsetAttributePDO::ATTR_CURSOR=PDO::CURSOR_SCROLL
	 * @return array شĽ
	 */
	public function queryAll($params = array(), $index = '', $fetchMode = 0, $fetchType = 0) {
		$this->execute($params, false);
		$rs = new WindResultSet($this, $fetchMode, $fetchType);
		return $rs->fetchAll($index);
	}

	/**
	 * 󶨲ִSQL䣬زѯĽĳһеֵ
	 * 
	 * @param array $params  ԤҪ󶨵Ĳ
	 * @param int $column е±꣬ĬΪ0һ
	 * @return string  
	 */
	public function getValue($params = array(), $column = 0) {
		$this->execute($params, false);
		$rs = new WindResultSet($this, PDO::FETCH_NUM, 0);
		return $rs->fetchColumn($column);
	}

	/**
	 * 󶨲ִSQL䣬һвѯ
	 * 
	 * @param array $params  ԤҪ󶨵Ĳ
	 * @param int $fetchMode ýģʽPDO::FETCH_BOTH/PDO::FETCH_ASSOC/PDO::FETCH_NUM
	 * @param int $fetchType ýĶȡʽPDO::FETCH_ORI_NEXT/PDO::FETCH_ORI_PREעҪʹøԣͨsetAttributePDO::ATTR_CURSOR=PDO::CURSOR_SCROLL
	 * @return array
	 */
	public function getOne($params = array(), $fetchMode = 0, $fetchType = 0) {
		$this->execute($params, false);
		$rs = new WindResultSet($this, $fetchMode, $fetchType);
		return $rs->fetch();
	}
	
	/* (non-PHPdoc) 
	 * @see WindConnection::lastInsterId()
	 */
	public function lastInsertId($name = '') {
		return $this->getConnection()->lastInsertId($name);
	}

	/**
	 * 󶨲ִSQL䣬Ӱ
	 * 
	 * @param array $params  --  󶨵ĲbindValuesĲһ
	 * @param boolean $rowCount Ƿ񷵻ӡ
	 * @return rowCount
	 */
	public function execute($params = array(), $rowCount = true) {
		try {
			$this->bindValues($params);
			$this->getStatement()->execute();
			$_result = $rowCount ? $this->getStatement()->rowCount() : true;
			return $_result;
		} catch (PDOException $e) {
			throw new WindDbException('[db.WindSqlStatement.execute] ' . $e->getMessage() . "\r\nSQL:" . $this->getQueryString());
		}
	}

	/**
	 * @param string $sql
	 */
	public function setQueryString($sql) {
		try {
			$this->_queryString = $sql;
			$this->_statement = $this->getConnection()->getDbHandle()->prepare($sql);
		} catch (PDOException $e) {
			throw new WindDbException("[db.WindSqlStatement.setQueryString] Initialization WindSqlStatement failed." . $e->getMessage());
		}
	}

	/**
	 * òѯԤ
	 * 
	 * @return string
	 */
	public function getQueryString() {
		return $this->_queryString;
	}

	/**
	 * @param WindConnection $connection
	 */
	public function setConnection($connection) {
		$this->_connection = $connection;
	}

	/**
	 * PDOӶ
	 * 
	 * @return WindConnection
	 */
	public function getConnection() {
		return $this->_connection;
	}

	/**
	 * PDOStatement
	 * 
	 * @return PDOStatement
	 */
	public function getStatement() {
		return $this->_statement;
	}

	/**
	 * ȡб
	 *
	 * @return array
	 */
	public function getParams() {
		return $this->_param;
	}

	/**
	 * Ҫ󶨵Ľֵ
	 * 
	 * @return array
	 */
	public function getColumns() {
		return $this->_columns;
	}

	/**
	 * ð󶨲
	 * 
	 * @param string $variable
	 * @return int
	 */
	private function _getPdoDataType($variable) {
		return isset($this->_typeMap[gettype($variable)]) ? $this->_typeMap[gettype($variable)] : PDO::PARAM_STR;
	}
}
?>