<?php
/**
 * 
 * ʵ,ڴʱʵز.
 * the last known user to change this file in the repository <$LastChangedBy:
 * yishuo $>
 * 
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindHandlerInterceptorChain.php 3776 2012-10-23 09:30:30Z
 *          yishuo $
 * @package filter
 */
class WindHandlerInterceptorChain extends WindModule {
	/**
	 * 
	 * 
	 * @var array
	 */
	protected $_interceptors = array('_Na' => null);
	/**
	 * Ļص
	 * 
	 * @var string array
	 */
	protected $_callBack = null;
	/**
	 * صĲ
	 * 
	 * @var array
	 */
	protected $_args = array();

	/**
	 * ûص
	 * 
	 * @param string|array $callBack
	 *        ص,ַ: Ҳ: еķ
	 * @param array $args
	 *        صĲб
	 */
	public function setCallBack($callBack, $args = array()) {
		$this->_callBack = $callBack;
		$this->_args = $args;
	}

	/**
	 * ִcallback
	 * 
	 * @return mixed $var=.. callBackûб򷵻null,򷵻ػصĽ
	 * @throws WindException صʧ׳쳣
	 */
	public function handle() {
		reset($this->_interceptors);
		if ($this->_callBack === null) return null;
		if (is_string($this->_callBack) && !function_exists($this->_callBack)) {
			throw new WindException('[filter.WindHandlerInterceptorChain.handle] ' . $this->_callBack, 
				WindException::ERROR_FUNCTION_NOT_EXIST);
		}
		$this->_args || $this->_args = func_get_args();
		return call_user_func_array($this->_callBack, (array) $this->_args);
	}

	/**
	 * еһ
	 * 
	 * @return WindHandlerInterceptor
	 */
	public function getHandler() {
		if (count($this->_interceptors) <= 1) {
			return $this;
		}
		$handler = next($this->_interceptors);
		if ($handler === false) {
			reset($this->_interceptors);
			return null;
		}
		if (method_exists($handler, 'handle')) {
			$handler->setHandlerInterceptorChain($this);
			return $handler;
		}
		return $this->getHandler();
	}

	/**
	 * е
	 * ֧Ͷͣarray_mergeֱӽ׷Ӳ
	 * 
	 * @param array|WindHandlerInterceptor $interceptors
	 *        ǵ
	 */
	public function addInterceptors($interceptors) {
		if (is_array($interceptors))
			$this->_interceptors = array_merge($this->_interceptors, $interceptors);
		else
			$this->_interceptors[] = $interceptors;
	}

	/**
	 * ʼϢ
	 * 
	 * @return boolean
	 */
	public function reset() {
		$this->_interceptors = array('_Na' => null);
		$this->_callBack = null;
		$this->_args = array();
		return true;
	}
}
?>