<?php
/**
 * 
 * 
 * ͨʹ,ʵֶ෽Եļ˻.<code>
 * //,ֻ proxyΪtrue,Ϳͨһдܵʵ.
 * <component name='windApplication' path='WIND:web.WindWebApplication'
 * scope='singleton' proxy='true'>
 * <properties>
 * <property name='dispatcher' ref='dispatcher' />
 * <property name='handlerAdapter' ref='router' />
 * </properties>
 * </component>
 * $object = Wind::getComponents('windApplication');
 * $object->registerEventListener('runProcess', new Listener());
 * </code>
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindClassProxy.php 3681 2012-06-18 02:45:28Z yishuo $
 * @package base
 */
class WindClassProxy {
	/**
	 * ĬϹͶ
	 * 
	 * @var string
	 */
	protected $_class_interceptorChain = 'WIND:filter.WindHandlerInterceptorChain';
	
	/**
	 * 
	 * 
	 * @var WindHandlerInterceptorChain
	 */
	private $_interceptorChain = null;
	protected $_className = '';
	protected $_classPath = '';
	protected $_instance = null;
	protected $_listener = array();

	/**
	 * @param object $targetObj Ҫʵ  ĬΪnull
	 */
	public function __construct($targetObject = null) {
		$targetObject && $this->registerTargetObject($targetObject);
	}

	/**
	 * ע¼Լ¼
	 * 
	 * ͨø÷,¼Լ¼ļע,¼õʱķ.:<code>
	 * <component name='windApplication' path='WIND:web.WindWebApplication'
	 * scope='singleton' proxy='true'>...</component>
	 * $object = Wind::getComponents('windApplication');
	 * $object->registerEventListener('runProcess', new Listener());
	 * </code>
	 * @param object $listener ¼
	 * @param stinrg $event ¼ 
	 * @return void
	 */
	public function registerEventListener($listener, $event) {
		$this->_listener[$event][] = $listener;
	}

	/**
	 * עĿ,Ѿע˲ظע
	 * 
	 * WindFactoryдһ:<code>
	 * $instance = new Object();
	 * $this->addClassDefinitions($alias, array('path' => $proxy, 'scope' => 'prototype'));
	 * $proxy = $this->getInstance($alias);
	 * $proxy->registerTargetObject($instance);
	 * $instance->_proxy = $proxy;
	 * </code><note><b>ע:</b>$instance̳WindModule</note>
	 * @param object $targetObject
	 * @return WindClassProxy
	 */
	public function registerTargetObject($targetObject) {
		$this->_className = get_class($targetObject);
		$this->_instance = $targetObject;
		return $this;
	}

	/**
	 * ෽
	 * 
	 * @param string $methodName 
	 * @param array $args 
	 * @return mixed
	 * @throws WindException
	 */
	public function __call($methodName, $args) {
		$listeners = isset($this->_listener[$methodName]) ? $this->_listener[$methodName] : array();
		if (empty($listeners)) return call_user_func_array(array($this->_instance, $methodName), $args);
		$interceptorChain = $this->_getInterceptorChain($methodName);
		$interceptorChain->addInterceptors($listeners);
		$interceptorChain->setCallBack(array($this->_getInstance(), $methodName), $args);
		return call_user_func_array(array($interceptorChain->getHandler(), 'handle'), (array) $args);
	}

	/**
	 * ع,Ѿظ
	 * 
	 * @param string $event ¼ ĬֵΪ
	 * @return WindHandlerInterceptorChain
	 * @throws WindException
	 */
	private function _getInterceptorChain($event = '') {
		if (null === $this->_interceptorChain) {
			$chain = Wind::import($this->_class_interceptorChain);
			$this->_interceptorChain = WindFactory::createInstance($chain);
		}
		$this->_interceptorChain->reset();
		return $this->_interceptorChain;
	}

	/**
	 * صǰʵ
	 * 
	 * @return object
	 */
	public function _getInstance() {
		return $this->_instance;
	}

	/**
	 * صǰʵ
	 * 
	 * @return string
	 */
	public function _getClassName() {
		return $this->_className;
	}

	/**
	 * صǰʵ·Ϣ
	 * 
	 * @return string
	 */
	public function _getClassPath() {
		return $this->_classPath;
	}

	/**
	 * 
	 * 
	 * @param string $className
	 * @return void
	 */
	public function _setClassName($className) {
		$this->_className = $className;
	}

	/**
	 * ·
	 * 
	 * @param string $classPath
	 * @return void
	 */
	public function _setClassPath($classPath) {
		$this->_setClassName(Wind::import($classPath));
		$this->_classPath = $classPath;
	}
}
?>