<?php
Wind::import('WIND:ftp.exception.WindFtpException');
/**
 * FTP
 * 
 * FTPӵеĽӿ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AbstractWindFtp.php 3930 2013-02-05 03:55:24Z yishuo $
 * @package ftp
 */
abstract class AbstractWindFtp {
	
	/**
	 * ftpַ
	 *
	 * @var string
	 */
	protected $server = '';
	
	/**
	 * ftpӶ˿ں
	 *
	 * @var int
	 */
	protected $port = 21;
	
	/**
	 * ftpӵû
	 *
	 * @var string	 
	 */
	protected $user = '';
	
	/**
	 * ftpӵû
	 *
	 * @var string
	 */
	protected $pwd = '';
	
	/**
	 * ftp֮ʹõĵǰ·
	 *
	 * @var string
	 */
	protected $dir = '';
	
	/**
	 * ftpӵĹʱ䵥λ
	 * 
	 * @var int
	 */
	protected $timeout = 10;
	
	/**
	 * ftpĸĿ¼·
	 *
	 * @var string
	 */
	protected $rootPath = '';
	
	/**
	 * ftpӶ
	 *
	 * @var resource
	 */
	protected $conn = null;

	/**
	 * ʼϢ
	 * 
	 * @param array $config ftpϢ
	 * <ul>
	 * <li>server: ftpַ</li>
	 * <li>port: ftpӶ˿ںţĬΪ21</li>
	 * <li>user: ftpû</li>
	 * <li>pwd: ftpû</li>
	 * <li>dir: ftpӺлĿ¼,ĬΪ</li>
	 * <li>timeout: ftpӳʱʱ,ĬΪ10</li>
	 * </ul>
	 * @return boolean óɹtrue,ʧܷfalse
	 */
	public function initConfig($config) {
		if (!$config || !is_array($config)) return false;
		isset($config['server']) && $this->server = $config['server'];
		isset($config['port']) && $this->port = $config['port'];
		isset($config['user']) && $this->user = $config['user'];
		isset($config['pwd']) && $this->pwd = $config['pwd'];
		isset($config['dir']) && $this->dir = $config['dir'];
		isset($config['timeout']) && $this->timeout = $config['timeout'];
		return true;
	}

	/**
	 * ļ
	 * 
	 * @param string $oldName ڵļ
	 * @param string $newName µļ
	 * @return boolean ɹ򷵻true,ʧ򷵻false
	 */
	abstract public function rename($oldName, $newName);

	/**
	 * ɾļ
	 * 
	 * @param string $filename ɾļ
	 * @return boolean ɾɹtrue,ɾʧܷfalse
	 */
	abstract public function delete($filename);

	/**
	 * ϴļ
	 * 
	 * 'I' == BINARY mode
     * 'A' == ASCII mode
	 * 
	 * @param string $sourceFile ϴļ
	 * @param string $desFile ļϴĴλ
	 * @param string $mode ϴģʽƻASCIIϴIΪģʽAΪASCIIģʽĬΪAģʽ
	 * @return int ϴļĴС 
	 */
	abstract public function upload($sourceFile, $desFile, $mode = 'I');

	/**
	 * ļ
	 * 
	 * @param string $localfile  ļλ
	 * @param string $remotefile صļ
	 * @param string $mode صģʽƻASCIIϴIΪģʽAΪASCIIģʽĬΪAģʽ
	 * @return boolean ļǷɹ
	 */
	abstract public function download($localfile, $remotefile = '', $mode = 'I');

	/**
	 * гĿ¼ļб
	 * 
	 * @param string $dir Ŀ¼,ĬΪռΪǰĿ¼
	 * @return array ظĿ¼µļб
	 */
	abstract public function fileList($dir = '');

	/**
	 * رftp
	 * 
	 * @return boolean عرǷɹ
	 */
	abstract public function close();

	/**
	 * ļ
	 * 
	 * @param string $dir ļ
	 * @return boolean ļгɹ򷵻true,ʧ򷵻false
	 */
	abstract public function mkdir($dir);

	/**
	 * ĵǰĿ¼ָĿ¼
	 * 
	 * @param string $dir ҪΪǰĿ¼Ŀ¼
	 * @return boolean óɹ򷵻true,ʧ򷵻false
	 */
	abstract public function changeDir($dir);

	/**
	 * ļС
	 * 
	 * @param string $file ȡļ
	 * @return int ȡɹļС
	 */
	abstract public function size($file);

	/**
	 * õǰ·
	 * 
	 * @return string صǰ·
	 */
	abstract protected function pwd();

	/**
	 * ļ
	 * 
	 * @param string $dir ļ·
	 * @param string $permissions ļеȨ
	 * @return boolean ɹtrueʧܷfalse
	 */
	public function mkdirs($dir, $permissions = 0777) {
		$dir = explode('/', WindSecurity::escapePath($dir));
		$dirs = '';
		$result = false;
		$count = count($dir);
		for ($i = 0; $i < $count; $i++) {
			if ('.' !== $dir[$i] && '..' !== $dir[$i]) {
				$result = $this->mkdir($dir[$i], $permissions);
				$this->changeDir($this->rootPath . $dirs . $dir[$i]);
				$dirs .= "$dir[$i]/";
			}
		}
		$this->changeDir($this->rootPath);
		return $result;
	}

	/**
	 * ļǷ
	 * 
	 * @param string $filename ļ
	 * @return boolean ļ򷵻true,ʧ򷵻false
	 */
	public function file_exists($filename) {
		$directory = substr($filename, 0, strrpos($filename, '/'));
		$filename = str_replace("$directory/", '', $filename);
		if ($directory) {
			$directory = $this->rootPath . $directory . '/';
		} else {
			$directory = $this->rootPath;
		}
		$this->changeDir($directory);
		$list = $this->fileList();
		$this->changeDir($this->rootPath);
		if (!empty($list) && in_array($filename, $list)) return true;
		return false;
	}

	/**
	 * 赱ǰĿ¼ΪʼĿ¼Ϣ
	 */
	protected function initRootPath() {
		$this->rootPath = $this->pwd();
		if ($this->dir) {
			$this->rootPath .= trim(str_replace('\\', '/', $this->dir), '/') . '/';
		}
		$this->changeDir($this->rootPath);
	}
}