<?php
Wind::import('WIND:http.IWindHttpContainer');
Wind::import('WIND:utility.WindCookie');
/**
 * cookieΪ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindNormalCookie.php 3583 2012-05-28 03:35:10Z yishuo $
 * @package http
 * @subpackage cookie
 */
class WindNormalCookie extends WindModule implements IWindHttpContainer {
	protected $prefix = null;
	protected $encode = false;
	protected $path = null;
	protected $domain = null;
	protected $secure = false;
	protected $httponly = false;

	/**
	 * 캯
	 * 
	 * ݴcookieݳʼcookie
	 * 
	 * @param boolean $encode Ƿʹ MIME base64 ݽб,Ĭfalseб
	 * @param string $prefix cookieǰ׺,ĬΪnullûǰ׺
	 * @param string $path cookie·,ĬΪnullĬ
	 * @param string $domain cookie,ĬΪnull
	 * @param boolean $secure Ƿȫ,ĬΪfalseðȫ
	 * @param boolean $httponly Ƿͨͻ˽ű,ĬΪfalseͻ˽űԷcookie
	 * @return void
	 */
	public function __construct($prefix = null, $encode = false, $path = null, $domain = null, $secure = false, $httponly = false) {
		$this->prefix = $prefix;
		$this->encode = $encode;
		$this->domain = $domain;
		$this->path = $path;
		$this->secure = $secure;
		$this->httponly = $httponly;
	}

	/**
	 * 
	 *
	 * @param array|string $config
	 * @see WindModule::setConfig()
	 * @return void
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		$this->prefix = $this->getConfig('prefix');
		$this->encode = $this->getConfig('encode');
		$this->domain = $this->getConfig('domain');
		$this->path = $this->getConfig('path');
		$this->secure = $this->getConfig('secure');
		$this->httponly = $this->getConfig('httponly');
	}

	/**
	 * cookie
	 * 
	 * @param string $name
	 * @param mixed $value
	 * @param int|null $expires ʱ
	 * @return boolean
	 */
	public function set($name, $value, $expires = null) {
		$this->prefix && $name = $this->prefix . $name;
		return WindCookie::set($name, $value, $this->encode, $expires, $this->path, $this->domain, 
			$this->secure, $this->httponly);
	}

	/**
	 * ȡcookieֵ
	 *
	 * @param string $name
	 * @return void
	 */
	public function get($name) {
		$this->prefix && $name = $this->prefix . $name;
		return WindCookie::get($name, $this->encode);
	}

	/**
	 * Ƴcookieֵ
	 * 
	 * @param string $name
	 * @return boolean
	 * @see IWindHttpContainer::delete()
	 */
	public function delete($name) {
		$this->prefix && $name = $this->prefix . $name;
		return WindCookie::delete($name);
	}
	
	/* (non-PHPdoc)
	 * @see IWindHttpContainer::isRegistered()
	 */
	public function isRegistered($name) {
		$this->prefix && $name = $this->prefix . $name;
		return WindCookie::exist($name);
	}

	/**
	 * Ƴȫcookieֵ
	 * 
	 * @return boolean
	 */
	public function deleteAll() {
		return WindCookie::deleteAll();
	}

	/**
	 * жcookieֵǷ
	 *
	 * @param string $name
	 */
	public function exist($name) {
		$this->prefix && $name = $this->prefix . $name;
		return WindCookie::exist($name);
	}

	/**
	 * ȡcookie
	 * 
	 * @return string cookie
	 */
	public function getDomain() {
		return $this->domain;
	}

	/**
	 * ȡcookie·
	 * 
	 * @return string cookie·
	 */
	public function getPath() {
		return $this->path;
	}
}