<?php
Wind::import('WIND:http.IWindHttpContainer');
/**
 * ỰƣCacheʵ֣ӦÿԸԼҪĴ洢ʽʵֻỰ洢
 * á֧øʽ:
 * <pre>
 * 'windSession' => array(
 * 'path' => 'WIND:http.session.WindSession',
 * 'scope' => 'singleton',
 * 'destroy' => 'commit',
 * 'constructor-args' => array(
 * '0' => array(
 * 'ref' => 'windCache',
 * ),
 * ),
 * ),
 * </pre>
 * ʹáʱʹã
 * <pre>
 * $session = Wind::getComponent('WindSession');
 * 
 * $session->set('name', 'test');    //ͬ$_SESSION['name'] = 'test';
 * echo $session->get('name');       //ͬecho $_SESSION['name'];
 * 
 * $session->delete('name');         //ͬ unset($_SESSION['name');
 * echo $session->getCurrentName();     //ͬ echo session_name();
 * echo $session->getCurrentId();       //ͬ echo session_id();
 * $session->destroy();              //ͬ session_unset();session_destroy();
 * </pre>
 * ʹԭ
 * ûҪԼ洢ʽsessionҪ޸κεãֻҪWindSessionнconstructor-argsȥɡ£
 * <pre>
 * 'windSession' => array(
 * 'path' => 'WIND:http.session.WindSession',
 * 'scope' => 'singleton',
 * 'destroy' => 'commit',
 * ),
 * </pre>
 * 
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindSession.php 3791 2012-10-30 04:01:29Z liusanbian $
 * @package http
 * @subpackage session
 */
class WindSession extends WindModule implements IWindHttpContainer {

	/**
	 * 캯
	 * 
	 * @param AbstractWindCache $dataStoreHandler ݻ,ĬΪnull
	 * @param object $sessionHandler  session,ĬΪnull
	 * @return void
	 */
	public function __construct($dataStoreHandler = null, $sessionHandler = null) {
		$this->setDataStoreHandler($dataStoreHandler, $sessionHandler);
	}

	/**
	 * session
	 * 
	 * @return void
	 */
	public function start() {
		'' === $this->getCurrentId() && session_start();
	}

	/**
	 * 
	 * 
	 * @param string $key sessionеļ
	 * @param mixed $value sessionеֵ
	 * @return void
	 */
	public function set($key, $value) {
		$key && $_SESSION[$key] = $value;
	}

	/**
	 * 
	 * 
	 * @param string $key sessionеļ
	 * @return mixed رsessionиüӦļֵ
	 */
	public function get($key) {
		return $this->isRegistered($key) ? $_SESSION[$key] : '';
	}

	/**
	 * ɾ
	 * 
	 * @param string $key
	 */
	public function delete($key) {
		$_SESSION[$key] = null;
		unset($_SESSION[$key]);
		return true;
	}

	/**
	 * ỰϢ
	 * 
	 * @return boolean
	 */
	public function destroy() {
		return session_destroy();
	}

	/**
	 * ǷѾע
	 * 
	 * @param string $key ҪжϵĽ
	 * @return boolean Ѿע򷵻true,򷵻false
	 */
	public function isRegistered($key) {
		return isset($_SESSION[$key]);
	}

	/**
	 * õǰsession
	 * 
	 * @return string
	 */
	public function getCurrentName() {
		return session_name();
	}

	/**
	 * õǰsession
	 * 
	 * @param string $name session
	 * @return boolean óɹtrue
	 */
	public function setCurrentName($name) {
		return session_name($name);
	}

	/**
	 * sessionId
	 * 
	 * @return string
	 */
	public function getCurrentId() {
		return session_id();
	}

	/**
	 * õǰsessionId
	 * 
	 * @param string $id Ҫõid
	 * @return boolean óɹtrue
	 */
	public function setCurrentId($id) {
		return session_id($id);
	}

	/**
	 * дsession֮رsession
	 * 
	 * ͬsession_write_close
	 * 
	 * @return void
	 */
	public function commit() {
		return session_commit();
	}

	/**
	 * Ӷ
	 * 
	 * @param AbstractWindCache $handler  sessionݵĻ
	 * @param object $sessionHandler sessionӿڵĶ
	 */
	public function setDataStoreHandler($dataStoreHandler = null, $sessionHandler = null) {
		if ($dataStoreHandler) {
			if ($sessionHandler === null) {
				Wind::import('WIND:http.session.handler.WindSessionHandler');
				$sessionHandler = new WindSessionHandler();
			}
			$sessionHandler->registerHandler($dataStoreHandler);
		}
		$this->start();
	}
}