<?php
/**
 * עsessionķ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindSessionHandler.php 2973 2011-10-15 19:22:48Z yishuo $
 * @package http
 * @subpackage session.handler
 */
class WindSessionHandler extends AbstractWindSessionHandler {

	/* (non-PHPdoc)
	 * @see AbstractWindSessionHandler::open()
	 */
	public function open($savePath, $sessionName) {
		if ('0' == ($expire = $this->dataStore->getExpire())) {
			$lifeTime = get_cfg_var("session.gc_maxlifetime");
			$this->dataStore->setExpire((int) $lifeTime);
		} else
			session_cache_expire($expire);
		return true;
	}

	/* (non-PHPdoc)
	 * @see AbstractWindSessionHandler::close()
	 */
	public function close() {
		return true;
	}

	/* (non-PHPdoc)
	 * @see AbstractWindSessionHandler::write()
	 */
	public function write($sessID, $sessData) {
		return $this->dataStore->set($sessID, $sessData);
	}

	/* (non-PHPdoc)
	 * @see AbstractWindSessionHandler::read()
	 */
	public function read($sessID) {
		return $this->dataStore->get($sessID);
	}

	/* (non-PHPdoc)
	 * @see AbstractWindSessionHandler::gc()
	 */
	public function gc($maxlifetime) {
		return true;
	}

	/* (non-PHPdoc)
	 * @see AbstractWindSessionHandler::destroy()
	 */
	public function destroy($sessID) {
		return $this->dataStore->delete($sessID);
	}
}

/**
 * עsessionHandlerĽӿڶ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindSessionHandler.php 2973 2011-10-15 19:22:48Z yishuo $
 * @package http
 * @subpackage session.handler
 */
abstract class AbstractWindSessionHandler {
	/**
	 * sessionݵʵ
	 * 
	 * @var AbstractWindCache
	 */
	protected $dataStore = null;

	/**
	 * ڿʼỰʱóʼỰϢ
	 * 
	 * ԴӴӱĽлȡsession
	 * 
	 * @param string $savePath ĵַ
	 * @param string $sessionName  Ự
	 * @return  boolean
	 */
	abstract public function open($savePath, $sessionName);

	/**
	 * رջỰ洢洢
	 * 
	 * ҳִʱִ
	 * 
	 * @return  boolean
	 */
	abstract public function close();

	/**
	 * sessionIDӦд洢
	 * 
	 * sessionClose֮ǰִдsessionݵ
	 * 
	 * @param string $sessID ỰID
	 * @param mixed $sessData ûỰ 
	 * @return void
	 */
	abstract public function write($sessID, $sessData);

	/**
	 * Ӵ洢װsession
	 * 
	 * ִsession_startʱִopen֮
	 * 
	 * @param string $sessid ỰID
	 * @return void
	 */
	abstract public function read($sessID);

	/**
	 * Դ洢ϵͳеݽռ
	 * 
	 * ִsessionڲԵʱִУע⣬sessionĹڲʱʱģҪphp.iniе
	 * session.gc_probability = 1
	 * session.gc_divisor = 1000  
	 * ִеĸgc_probability/gc_divisor .
	 * session.gc_maxlifetime = 1440  õsessionĹʱ
	 * 
	 * @param int $maxlifetime ʱ䵥λ
	 * @return void
	 */
	abstract public function gc($maxlifetime);

	/**
	 * ָĻỰID
	 * 
	 * ִsession_destroyʱִС
	 * 
	 * @param string $sessID ỰID
	 * @return void 
	 */
	abstract public function destroy($sessID);

	/**
	 * sessionĴ洢עsessionиhandler
	 * 
	 * @param AbstractWindCache $dataStore 洢ʽ
	 * @return void
	 */
	public function registerHandler($dataStore) {
		if (!$dataStore instanceof AbstractWindCache) {
			throw new WindException('[http.session.WindSessionHandler.registerHandler] register session save handler fail.', WindException::ERROR_PARAMETER_TYPE_ERROR);
		}
		$this->dataStore = $dataStore;
		session_set_save_handler(array($this, 'open'), array($this, 'close'), array($this, 'read'), array(
			$this, 
			'write'), array($this, 'destroy'), array($this, 'gc'));
	}
}