<?php
/**
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AbstractWindHttp.php 3912 2013-01-22 06:36:30Z yishuo $
 * @package http
 * @subpackage transfer
 */
abstract class AbstractWindHttp {
	/**  
	 * ͵cookie
	 * 
	 * @var string   
	 */
	protected $cookie = array();
	/**  
	 * ͵httpͷ 
	 * 
	 * @var array   
	 */
	protected $header = array();
	/**  
	 * ͵  
	 * 
	 * @var array
	 */
	protected $data = array();
	
	/**
	 * Ϣ
	 * 
	 * @var string
	 */
	protected $err = '';
	/**
	 * 
	 * 
	 * @var string
	 */
	protected $eno = 0;
	/**
	 * Ӧ״̬Ϣ
	 *
	 * @var string
	 */
	protected $status;
	
	/**
	 * ʱʱ
	 * 
	 * @var string
	 */
	protected $timeout = 0;
	/**  
	 * ʵURLַ 
	 * 
	 * @var array
	 */
	protected $url = '';
	/**
	 * ض
	 *
	 * @var int
	 */
	protected $_maxRedirs = 1;
	/**
	 * Ƿ֧ض
	 *
	 * @var boolean
	 */
	protected $_redirects = false;
	/**
	 * ǷȡͷϢ,false ȡtrue ȡ
	 *
	 * @var boolean
	 */
	protected $_header = false;
	/**
	 * ǷȡϢfalse ȡtrue ȡ
	 *
	 * @var boolean
	 */
	protected $_body = true;
	/**
	 * Enter description here ...
	 *
	 * @var unknown_type
	 */
	protected $_waitResponse = true;
	
	/**
	 * httpӾ
	 */
	protected $httpHandler = null;

	/**
	 * ܱĹ캯,ʵ
	 * 
	 * @param string $url
	 * @param int $timeout
	 */
	public function __construct($url = '', $timeout = 30) {
		$this->url = $url;
		$this->timeout = $timeout;
		$this->httpHandler = $this->createHttpHandler();
	}

	/**
	 * ײ
	 * 
	 * @param string $method ʽ
	 * @param array $options 
	 * @return string ҳӦҳ
	 */
	abstract public function send($method = self::GET, $options = array());

	/**
	 * post
	 * 
	 * @param array $data 
	 * @param array $header ͷ
	 * @param array $cookie  ͵cookie
	 * @param array $options ͷ
	 * @return string ҳӦҳ
	 */
	public function post($data = array(), $header = array(), $cookie = array(), $options = array()) {
		$this->setHeader($header);
		$this->setCookie($cookie);
		$this->setData($data);
		return $this->send('POST', $options);
	}

	/**
	 * getʽֵ
	 * 
	 * @param array $data 
	 * @param array $header ͷ
	 * @param array $cookie  ͵cookie
	 * @param array $options ͷ
	 * @return string ҳӦҳ
	 */
	public function get($data = array(), $header = array(), $cookie = array(), $options = array()) {
		$this->setHeader($header);
		$this->setCookie($cookie);
		$this->setData($data);
		return $this->send('GET', $options);
	}

	/**
	 * 
	 * 
	 * @param string $key  
	 * @param string $value ֵ
	 * @return boolean
	 */
	abstract public function request($key, $value = null);

	/**
	 * Ӧû
	 * 
	 * @return string Ӧ
	 */
	abstract public function response();

	/**
	 * httpӾ
	 * 
	 * @return handler Ӿ
	 */
	abstract protected function createHttpHandler();

	/**
	 * ȡhttpͨеĴ
	 */
	abstract public function getError();

	/**
	 * ر
	 * 
	 * @return boolean
	 */
	abstract public function close();

	/**
	 * һhttp, http
	 * 
	 * @return httpResource
	 */
	protected function getHttpHandler() {
		return $this->httpHandler;
	}

	/**
	 * 
	 */
	public function __destruct() {
		$this->close();
	}

	/**
	 * httpͷ,ֵֵ֧ú
	 * 
	 * @param string|array $key
	 * @param string $value
	 * @return void
	 */
	public function setHeader($value, $key = null) {
		if (is_array($value)) return $this->header = array_merge($this->header, $value);
		
		if ($key === null) $key = count($this->header);
		if (!isset($this->header[$key])) $this->header[$key] = $value;
	}

	/**
	 * cookie,ֵֵ֧ú
	 * 
	 * @param string|array $key
	 * @param string $value
	 */
	public function setCookie($key, $value = null) {
		if (!$key) return;
		if (is_array($key))
			$this->cookie = array_merge($this->cookie, $key);
		else
			$this->cookie[$key] = $value;
	}

	/**
	 * data,ֵֵ֧ú
	 * 
	 * @param string|array $key
	 * @param string $value
	 */
	public function setData($key, $value = null) {
		if (!$key) return;
		if (is_array($key))
			$this->data = array_merge($this->data, $key);
		else
			$this->data[$key] = $value;
	}

	/**
	 * @param number $_maxRedirs
	 */
	public function setMaxRedirs($_maxRedirs) {
		$this->_maxRedirs = $_maxRedirs;
	}

	/**
	 * @param boolean $_redirects
	 */
	public function setRedirects($_redirects) {
		$this->_redirects = $_redirects;
	}

	/**
	 * ӦϢǷͷϢ
	 * 
	 * ĬϲͷϢ
	 * @param boolean $_header
	 */
	public function setResponseHasHeader($_header) {
		$this->_header = $_header;
	}

	/**
	 * ӦϢǷϢ
	 * 
	 * ĬֻϢ
	 * @param boolean $_body
	 */
	public function setResponseHasBody($_body) {
		$this->_body = $_body;
	}

	/**
	 * @return string
	 */
	public function getStatus() {
		return $this->status;
	}

	/**
	 * @return multitype:
	 */
	public function getUrl() {
		return $this->url;
	}

	/**
	 * ǷȴӦ
	 * 
	 * @param boolean $_waitResponse
	 */
	public function setWaitResponse($_waitResponse) {
		$this->_waitResponse = $_waitResponse;
	}
}