<?php
Wind::import('WIND:i18n.WindI18nException');
Wind::import('WIND:i18n.IWindLangResource');
/**
 * Դʵ
 * Դʵ,֧iniʽԴ͵Ľ,Դwindģʽп.
 * ʵ԰·,Ĭļ,ݻȹ.
 * 
 * @example <code>
 *          LANG Ϊ,дĬûзְ,ԴཫԶlanguageѰ
 *          ֽ֧ʽ: LANG:login.fail.expty = 'xxx'
 *          </code>
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindLangResource.php 3850 2012-12-04 07:30:02Z yishuo $
 * @package i18n
 */
class WindLangResource extends WindModule implements IWindLangResource {
	/**
	 * keyǰ׺
	 * 
	 * @var string
	 */
	protected $_cachePrefix = 'Wind.i18n.WindLangResource';
	/**
	 * Ϣ洢
	 * 
	 * @var array
	 */
	protected $_messages = array();
	/**
	 * ĬԴļ
	 * 
	 * @var string
	 */
	protected $default;
	/**
	 * Դļ׺
	 * 
	 * @var string
	 */
	protected $suffix;
	/**
	 * ԰Ŀ¼
	 * 
	 * @var string
	 */
	protected $path;
	/**
	 * 
	 * 
	 * @var string
	 */
	protected $language;
	
	/**
	 *
	 * @var WindLocale
	 */
	protected $locale = null;
	
	/*
	 * (non-PHPdoc) @see IWindLangResource::lang()
	 */
	public function getMessage($message, $params = array()) {
		$message = $this->translate($message);
		return empty($params) ? $message : WindUtility::strtr($message, $params);
	}

	/**
	 * ȡһmessageϢ
	 * 
	 * @param array $messages
	 * @return string
	 */
	protected function translate($message) {
		$package = $file = '';
		$_message = $message;
		if (strpos($_message, ':') != false) list($package, $_message) = explode(':', $_message, 2);
		if (strpos($_message, '.') != false) list($file, $key) = explode('.', $_message, 2);
		$path = $this->resolvedPath($package);
		if (is_file($path . '/' . $file . $this->suffix)) {
			$path = $path . '/' . $file . $this->suffix;
		} elseif (is_file($path . '/' . $this->default . $this->suffix)) {
			$path = $path . '/' . $this->default . $this->suffix;
			$key = $_message;
			$file = $this->default;
		} else
			return $message;
		
		if (!isset($this->_messages[$path])) {
			/* @var $cache AbstractWindCache */
			$cache = Wind::getComponent('windCache');
			$cacheKey = $this->_cachePrefix . $package . $file . filemtime($path);
			$messages = null;
			if ($cache) $messages = $cache->get($cacheKey);
			if (!$messages) {
				$messages = parse_ini_file($path);
				if ($cache) $cache->set($cacheKey, $messages);
			}
			$this->_messages[$path] = $messages;
		}
		return isset($this->_messages[$path][$key]) ? $this->_messages[$path][$key] : $message;
	}

	/**
	 * Դļ·Ϣ
	 * 
	 * @param string $package
	 * @return string
	 */
	protected function resolvedPath($package) {
		$this->path || $this->path = Wind::getRootPath(Wind::getAppName());
		$this->language || $this->language = $this->getRequest()->getAcceptLanguage();
		$path = $this->path . '/' . $this->language . '/' . strtolower($package);
		$path = Wind::getRealDir(trim($path, '/'), true);
		return $path;
	}
	
	/*
	 * (non-PHPdoc) @see WindModule::setConfig()
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		$this->suffix = $this->getConfig('suffix', '', '');
		$this->default = $this->getConfig('default', '', 'message');
		$this->path = $this->getConfig('path', '', '');
		$this->language = $this->getConfig('language', '', 'zh_cn');
	}
}

?>