<?php
/**
 * ־¼
 * 
 * ־¼ļ¼֣
 * <ul>
 * <li>WindLogger::LEVEL_INFO = 1: Ϣ¼ֻ¼Ҫ¼Ϣ</li>
 * <li>WindLogger::LEVEL_TRACE = 2: Ϣ¼ͬʱ¼traceϢ</li>
 * <li>WindLogger::LEVEL_DEBUG = 3: Ϣ¼ͬʱ¼traceϢ</li>
 * <li>WindLogger::LEVEL_ERROR = 4: ¼ϢtraceϢ</li>
 * <li>WindLogger::LEVEL_PROFILE = 5: Ϣ¼ϸʱ估ڴʹ</li>
 * </ul>
 * ־ĴʽҲͨwrite_typeã
 * <ul>
 * <li>0: ӡȫ־Ϣ</li>
 * <li>1: levelļ洢־¼</li>
 * <li>2: typeļ洢־¼</li>
 * </ul>
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindLogger.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package log
 */
class WindLogger extends WindModule {
	
	/**
	 * 1 ֻǼ¼Ϣ¼traceϢ
	 *
	 * @var int
	 */
	const LEVEL_INFO = 1;
	
	/**
	 * 2ӡջtraceϢ
	 *
	 * @var int
	 */
	const LEVEL_TRACE = 2;
	
	/**
	 * 3־Ϣһdebug
	 * 
	 * debugϢᵼtraceϢdebugϸϢ
	 *
	 * @var int
	 */
	const LEVEL_DEBUG = 3;
	
	/**
	 * 4¼ϢtraceϢ
	 *
	 * @var int
	 */
	const LEVEL_ERROR = 4;
	
	/**
	 * 5Ϣ¼ϸʱ估ڴʹ
	 *
	 * @var int
	 */
	const LEVEL_PROFILE = 5;
	
	/**
	 * ־ķʽ
	 *
	 * @var int
	 */
	const WRITE_TYPE = 2;
	
	/**
	 * ־¼profileϢʼı־
	 *
	 * @var string
	 */
	const TOKEN_BEGIN = 'begin:';
	
	/**
	 * ־¼profileϢı־
	 *
	 * @var string
	 */
	const TOKEN_END = 'end:';
	
	/**
	 * ÿε־ﵽ1000ʱ򣬾дļһ
	 * 
	 * @var int
	 */
	private $_autoFlush = 1000;
	
	/**
	 * ־
	 *
	 * @var array
	 */
	private $_logs = array();
	
	/**
	 * ־ͳ
	 *
	 * @var int
	 */
	private $_logCount = 0;
	
	/**
	 * ־ϸϢ
	 *
	 * @var array
	 */
	private $_profiles = array();
	
	/**
	 * ־¼ĵַ
	 *
	 * @var string
	 */
	private $_logDir;
	
	/**
	 * ־ļ󳤶
	 *
	 * @var int
	 */
	private $_maxFileSize = 100;
	
	/**
	 * ־ӡʽ
	 * 
	 * 0: ӡȫ־Ϣ
	 * 1: levelļ洢־¼
	 * 2: typeļ洢־¼
	 * 
	 * @var int
	 */
	private $_writeType = 0;
	
	/**
	 * ־ӡʽ
	 *
	 * @var array
	 */
	private $_types = array();

	/**
	 * 캯
	 * 
	 * @param string $logDir ־ļŵĿ¼
	 * @param int $writeType ־ļı淽ʽ
	 * @return void
	 */
	public function __construct($logDir = '', $writeType = 0, $maxFileSize = 100) {
		$this->setLogDir($logDir);
		$this->_writeType = $writeType;
		$this->setMaxFileSize($maxFileSize);
	}

	/**
	 * info־Ϣ
	 * 
	 * @param string $msg ־Ϣ
	 * @param string $type ־,ĬΪwind.system
	 * @param boolean $flush Ƿ־ļ,Ϊtrueʱдļ,ĬΪfalse
	 * @return void
	 */
	public function info($msg, $type = 'wind.system', $flush = false) {
		$this->log($msg, self::LEVEL_INFO, $type, $flush);
	}

	/**
	 * trace־Ϣ
	 * 
	 * @param string $msg ־Ϣ
	 * @param string $type ־,ĬΪwind.system
	 * @param boolean $flush Ƿ־ļ,Ϊtrueʱдļ,ĬΪfalse
	 * @return void
	 */
	public function trace($msg, $type = 'wind.system', $flush = false) {
		$this->log($msg, self::LEVEL_TRACE, $type, $flush);
	}

	/**
	 * debug־Ϣ
	 * 
	 * @param string $msg ־Ϣ
	 * @param string $type ־,ĬΪwind.system
	 * @param boolean $flush Ƿ־ļ,Ϊtrueʱдļ,ĬΪfalse
	 * @return void
	 */
	public function debug($msg, $type = 'wind.system', $flush = false) {
		$this->log($msg, self::LEVEL_DEBUG, $type, $flush);
	}

	/**
	 * error־Ϣ
	 * 
	 * @param string $msg ־Ϣ
	 * @param string $type ־,ĬΪwind.core
	 * @param boolean $flush Ƿ־ļ,Ϊtrueʱдļ,ĬΪfalse
	 * @return void
	 */
	public function error($msg, $type = 'wind.core', $flush = false) {
		$this->log($msg, self::LEVEL_ERROR, $type, $flush);
	}

	/**
	 * profileĿʼλ־Ϣ
	 * 
	 * ͨýӿӵ־ϢǼ¼һʼλõϢ
	 * 
	 * @param string $msg ־Ϣ
	 * @param string $type ־,ĬΪwind.core
	 * @param boolean $flush Ƿ־ļ,Ϊtrueʱдļ,ĬΪfalse
	 * @return void
	 */
	public function profileBegin($msg, $type = 'wind.core', $flush = false) {
		$this->log('begin:' . trim($msg), self::LEVEL_PROFILE, $type, $flush);
	}

	/**
	 * profileĽλ־Ϣ
	 * 
	 * ͨýӿӵ־ϢǼ¼һλõϢ
	 * 
	 * @param string $msg ־Ϣ
	 * @param string $type ־,ĬΪwind.core
	 * @param boolean $flush Ƿ־ļ,Ϊtrueʱдļ,ĬΪfalse
	 * @return void
	 */
	public function profileEnd($msg, $type = 'wind.core', $flush = false) {
		$this->log('end:' . trim($msg), self::LEVEL_PROFILE, $type, $flush);
	}

	/**
	 * info־Ϣ
	 * 
	 * @param string $msg ־Ϣ
	 * @param int $level ־¼ļ,ĬΪINFOΪ1
	 * @param string $type ־,ĬΪwind.system
	 * @param boolean $flush Ƿ־ļ,Ϊtrue򽫻дļ,ĬΪfalse
	 * @return void
	 */
	public function log($msg, $level = self::LEVEL_INFO, $type = 'wind.system', $flush = false) {
		if ($this->_writeType & self::WRITE_TYPE)
			(count($this->_types) >= 5 || $this->_logCount >= $this->_autoFlush) && $this->flush();
		else
			$this->_logCount >= $this->_autoFlush && $this->flush();
		if ($level === self::LEVEL_PROFILE)
			$message = $this->_build($msg, $level, $type, microtime(true), 
				$this->getMemoryUsage(false));
		elseif ($level === self::LEVEL_DEBUG)
			$message = $this->_build($msg, $level, $type, microtime(true));
		else
			$message = $this->_build($msg, $level, $type);
		$this->_logs[] = array($level, $type, $message);
		$this->_logCount++;
		if ($this->_writeType == self::WRITE_TYPE && !in_array($type, $this->_types)) $this->_types[] = $type;
		if ($flush) $this->flush();
	}

	/**
	 * ¼־бϢдļ
	 * 
	 * @return boolean
	 */
	public function flush() {
		if (empty($this->_logs)) return false;
		Wind::import('WIND:utility.WindFile');
		$_l = $_logTypes = $_logLevels = array();
		$_map = array(
			self::LEVEL_INFO => 'info', 
			self::LEVEL_ERROR => 'error', 
			self::LEVEL_DEBUG => 'debug', 
			self::LEVEL_TRACE => 'trace', 
			self::LEVEL_PROFILE => 'profile');
		
		foreach ($this->_logs as $key => $value) {
			$_l[] = $value[2];
			$_logTypes[$value[1]][] = $value[2];
			$_logLevels[$value[0]][] = $value[2];
		}
		if ($this->_writeType & 1) {
			foreach ($_logLevels as $key => $value) {
				if (!$fileName = $this->_getFileName($_map[$key])) continue;
				WindFile::write($fileName, join("", $value), 'a');
			}
		}
		if ($this->_writeType & 2) {
			foreach ($_logTypes as $key => $value) {
				if (!$fileName = $this->_getFileName($key)) continue;
				WindFile::write($fileName, join("", $value), 'a');
			}
		}
		if ($fileName = $this->_getFileName()) {
			WindFile::write($fileName, join("", $_l), 'a');
		}
		$this->_logs = array();
		$this->_logCount = 0;
		return true;
	}

	/**
	 * ڴʹ
	 * 
	 * @param boolean $peak Ƿڴֵ,ĬΪtrue
	 * @return int
	 */
	public function getMemoryUsage($peak = true) {
		if ($peak && function_exists('memory_get_peak_usage'))
			return memory_get_peak_usage();
		elseif (function_exists('memory_get_usage'))
			return memory_get_usage();
		$pid = getmypid();
		if (strncmp(PHP_OS, 'WIN', 3) === 0) {
			exec('tasklist /FI "PID eq ' . $pid . '" /FO LIST', $output);
			return isset($output[5]) ? preg_replace('/[\D]/', '', $output[5]) * 1024 : 0;
		} else {
			exec("ps -eo%mem,rss,pid | grep $pid", $output);
			$output = explode("  ", $output[0]);
			return isset($output[1]) ? $output[1] * 1024 : 0;
		}
	}

	/**
	 * װ־Ϣ
	 * 
	 * @param string $msg ־Ϣ
	 * @param int  $level ־
	 * @param string  $type ־
	 * @param int  $timer ־¼ʱ,ĬΪ0
	 * @param int $mem ־¼ʱʹ,ĬΪ0
	 * @return string õϢַ
	 */
	private function _build($msg, $level, $type, $timer = 0, $mem = 0) {
		$result = '';
		switch ($level) {
			case self::LEVEL_INFO:
				$result = $this->_buildInfo($msg);
				break;
			case self::LEVEL_ERROR:
				$result = $this->_buildError($msg);
				break;
			case self::LEVEL_DEBUG:
				$result = $this->_buildDebug($msg);
				break;
			case self::LEVEL_TRACE:
				$result = $this->_buildTrace($msg);
				break;
			case self::LEVEL_PROFILE:
				$result = $this->_buildProfile($msg, $type, $timer, $mem);
				break;
			default:
				break;
		}
		return $result ? '[' . date('Y-m-d H:i:s') . '] ' . $result . "\r\n" : '';
	}

	/**
	 * profileϢʽ
	 * 
	 * @param string $msg ¼Ϣ
	 * @param string $type ¼Ϣ
	 * @param int $timer ¼Ϣʱ
	 * @param int $mem ¼Ϣʱʹ
	 * @return string عõprofileϢ
	 */
	private function _buildProfile($msg, $type, $timer, $mem) {
		$_msg = '';
		if (strncasecmp($msg, self::TOKEN_BEGIN, strlen(self::TOKEN_BEGIN)) == 0) {
			$_token = substr($msg, strlen(self::TOKEN_BEGIN));
			$_token = substr($_token, 0, strpos($_token, ':'));
			$this->_profiles[] = array(
				$_token, 
				substr($msg, strpos($msg, ':', strlen(self::TOKEN_BEGIN)) + 1), 
				$type, 
				$timer, 
				$mem);
		} elseif (strncasecmp(self::TOKEN_END, $msg, strlen(self::TOKEN_END)) == 0) {
			$_msg = "PROFILE! Message:";
			$_token = substr($msg, strlen(self::TOKEN_END));
			$_token = substr($_token, 0, strpos($_token, ':'));
			foreach ($this->_profiles as $key => $profile) {
				if ($profile[0] !== $_token) continue;
				if ($profile[1])
					$_msg .= "\r\n\t" . $profile[1];
				else
					$_msg .= "\r\n\t" . substr($msg, strpos($msg, ':', strlen(self::TOKEN_END)) + 1);
				$_msg .= "\r\n\tTime:" . ($timer - $profile[3]) . "\r\n\tMem:" . ($mem - $profile[4]) . "\r\n\tType:$profile[2]";
				break;
				unset($this->_profiles[$key]);
			}
		}
		return $_msg;
	}

	/**
	 * װinfoϢʽ
	 * 
	 * <code>
	 * INFO! Message: $msg
	 * </code>
	 * 
	 * @param string $msg Ϣ
	 * @return string
	 */
	private function _buildInfo($msg) {
		return "INFO! Message:  " . $msg;
	}

	/**
	 * װջtraceϢʽ
	 * 
	 * <code>
	 * TRACE! Message: $msg
	 * #1 trace1
	 * #2 trace2
	 * </code>
	 * 
	 * @param string $msg Ϣ
	 * @return string
	 */
	private function _buildTrace($msg) {
		return "TRACE! Message:  " . $msg . implode("\r\n", $this->_getTrace());
	}

	/**
	 * װdebugϢ
	 * 
	 * <code>
	 * DEBUG! Message: $msg
	 * #1 trace1
	 * #2 trace2
	 * </code>
	 * 
	 * @param string $msg Ϣ
	 * @return string
	 */
	private function _buildDebug($msg) {
		return 'DEBUG! Message:  ' . $msg . implode("\r\n", $this->_getTrace());
	}

	/**
	 *װErrorϢ
	 *
	 * <code>
	 * ERROR! Message: $msg
	 * #1 trace1
	 * #2 trace2
	 * </code>
	 * 
	 * @param string $msg ĴϢ
	 * @return string
	 */
	private function _buildError($msg) {
		return 'ERROR! Message:  ' . $msg;
	}

	/**
	 * ջϢĻȡװ
	 * 
	 * <code>
	 * #1 trace
	 * #2 trace
	 * </code>
	 * 
	 * @return string
	 */
	private function _getTrace() {
		$num = 0;
		$info[] = 'Stack trace:';
		$traces = debug_backtrace();
		foreach ($traces as $traceKey => $trace) {
			if ($num >= 7) break;
			if ((isset($trace['class']) && $trace['class'] == __CLASS__) || isset($trace['file']) && strrpos(
				$trace['file'], __CLASS__ . '.php') !== false) continue;
			$file = isset($trace['file']) ? $trace['file'] . '(' . $trace['line'] . '): ' : '[internal function]: ';
			$function = isset($trace['class']) ? $trace['class'] . $trace['type'] . $trace['function'] : $trace['function'];
			if ($function == 'WindBase::log') continue;
			$args = array_map(array($this, '_buildArg'), $trace['args']);
			$info[] = '#' . ($num++) . ' ' . $file . $function . '(' . implode(',', $args) . ')';
		}
		return $info;
	}

	/**
	 * װtraceеĲװ
	 * 
	 * @param mixed $arg ҪװϢ
	 * @return string װõϢ
	 * <ul>
	 * <li>array:  Array</li>
	 * <li>Object:  Object classname</li>
	 * <li>ʽ:  $arg</li>
	 * </ul>
	 */
	private function _buildArg($arg) {
		switch (gettype($arg)) {
			case 'array':
				return 'Array';
				break;
			case 'object':
				return 'Object ' . get_class($arg);
				break;
			default:
				return "'" . $arg . "'";
				break;
		}
	}

	/**
	 * ȡ־ļ
	 * 
	 * @param string $suffix ־ļĺ׺,ĬΪ
	 * @return string ־ļ
	 */
	private function _getFileName($suffix = '') {
		$_maxsize = ($this->_maxFileSize ? $this->_maxFileSize : 100) * 1024;
		$_logfile = $this->_logDir . '/log' . ($suffix ? '_' . $suffix : '') . '.txt';
		if (is_file($_logfile) && $_maxsize <= filesize($_logfile)) {
			do {
				$_newFile = $this->_logDir . '/log' . ($suffix ? '_' . $suffix : '') . '_' . time() . '.txt';
			} while (is_file($_newFile));
			@rename($_logfile, $_newFile);
		}
		return $_logfile;
	}

	/**
	 * ־·
	 * 
	 * @param string $logFile ־·
	 * @return void
	 */
	public function setLogDir($logDir) {
		$this->_logDir = Wind::getRealDir($logDir);
		WindFolder::mkRecur($this->_logDir);
	}

	/**
	 * ־ļĴС
	 * 
	 * @param int $_maxFileSize ļֵ
	 * @return void
	 */
	public function setMaxFileSize($maxFileSize) {
		$this->_maxFileSize = (int) $maxFileSize;
	}
}	