<?php
Wind::import('WIND:mail.exception.WindMailException');
/**
 * ʼ
 * 
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindMail.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package mail
 */
class WindMail {
	/**
	 *
	 * @var array ʼͷ
	 */
	private $mailHeader = array();
	/**
	 *
	 * @var array ʼ
	 */
	private $attachment = array();
	/**
	 *
	 * @var string ʼַ
	 */
	private $charset = 'utf-8';
	/**
	 *
	 * @var string ǷǶԴ
	 */
	private $embed = false;
	/**
	 *
	 * @var array ʼռ
	 */
	private $recipients = null;
	/**
	 *
	 * @var string ʼ
	 */
	private $from = '';
	/**
	 *
	 * @var string ʼϢhtmlչַʽ
	 */
	private $bodyHtml = '';
	/**
	 *
	 * @var string ʼϢıչַʽ
	 */
	private $bodyText = '';
	/**
	 *
	 * @var array ʼ߽
	 */
	private $boundary;
	/**
	 *
	 * @var string ʼ뷽ʽ
	 */
	private $encode = self::ENCODE_BASE64;
	/**
	 *
	 * @var 
	 */
	private $contentType;
	
	// ʼMIME
	const CRLF = "\n";
	const TO = 'To';
	const CC = 'Cc';
	const BCC = 'Bcc';
	const FROM = 'From';
	const SUBJECT = 'Subject';
	const MESSAGEID = 'Message-Id';
	const CONTENTTYPE = 'Content-Type';
	const CONTENTENCODE = 'Content-Transfer-Encoding';
	const CONTENTID = 'Content-ID';
	const CONTENTPOSITION = 'Content-Disposition';
	const CONTENTDESCRIPT = 'Content-Description';
	const CONTENTLOCATION = 'Content-Location';
	const CONTENTLANGUAGE = 'Content-Language';
	const DATE = 'Date';
	
	// ʼMIME
	const MIME_OCTETSTREAM = 'application/octet-stream';
	const MIME_TEXT = 'text/plain';
	const MIME_HTML = 'text/html';
	const MIME_ALTERNATIVE = 'multipart/alternative';
	const MIME_MIXED = 'multipart/mixed';
	const MIME_RELATED = 'multipart/related';
	
	// ʼ
	const ENCODE_7BIT = '7bit';
	const ENCODE_8BIT = '8bit';
	const ENCODE_QP = 'quoted-printable';
	const ENCODE_BASE64 = 'base64';
	const ENCODE_BINARY = 'binary';
	
	// ʼ
	const DIS_ATTACHMENT = 'attachment';
	const DIS_INLINE = 'inline';
	const LINELENGTH = 72;
	
	// ʼͷʽ
	const SEND_SMTP = 'smtp';
	const SEND_PHP = 'php';
	const SEND_SEND = 'send';

	/**
	 * ʼ
	 * 
	 * @param string $type 
	 * @param array $config ʼҪ
	 * @return boolean
	 * @throws Exception
	 */
	public function send($type = self::SEND_SMTP, $config = array()) {
		$class = Wind::import('Wind:mail.sender.Wind' . ucfirst($type) . 'Mail');
		/* @var $sender IWindSendMail */
		$sender = WindFactory::createInstance($class);
		return $sender->send($this, $config);
	}

	/**
	 * ʼͷϢ
	 * 
	 * @return string
	 */
	public function createHeader() {
		if (!isset($this->mailHeader[self::CONTENTTYPE])) {
			$type = self::MIME_TEXT;
			if ($this->attachment)
				$type = $this->embed ? self::MIME_RELATED : self::MIME_MIXED;
			elseif ($this->bodyHtml)
				$type = $this->bodyText ? self::MIME_ALTERNATIVE : self::MIME_HTML;
			$this->setContentType($type);
		}
		if (!isset($this->mailHeader[self::CONTENTENCODE])) $this->setContentEncode();
		$header = '';
		foreach ($this->mailHeader as $key => $value) {
			if (!$value) continue;
			$header .= $key . ': ';
			if (is_array($value)) {
				foreach ($value as $_key => $_value)
					$header .= (is_string($_key) ? $_key . ' ' . $_value : $_value) . ',';
				$header = trim($header, ',');
			} else
				$header .= $value;
			$header .= self::CRLF;
		}
		return $header . self::CRLF;
	}

	/**
	 * ʼϢ
	 * 
	 * @return string
	 */
	public function createBody() {
		$body = '';
		switch ($this->contentType) {
			case self::MIME_TEXT:
				$body = $this->_encode($this->bodyText) . self::CRLF;
				break;
			case self::MIME_HTML:
				$body = $this->_encode($this->bodyHtml) . self::CRLF;
				break;
			case self::MIME_ALTERNATIVE:
				$body = $this->_createBoundary($this->_boundary(), 'text/plain');
				$body .= $this->_encode($this->bodyText) . self::CRLF;
				$body .= $this->_createBoundary($this->_boundary(), 'text/html');
				$body .= $this->_encode($this->bodyHtml) . self::CRLF;
				$body .= $this->_boundaryEnd($this->_boundary());
				break;
			default:
				$body .= $this->_boundaryStart($this->_boundary());
				$body .= sprintf("Content-Type: %s;%s" . "\tboundary=\"%s\"%s", 
					'multipart/alternative', self::CRLF, $this->_boundary(1), 
					self::CRLF . self::CRLF);
				$body .= $this->_createBoundary($this->_boundary(1), 'text/plain') . self::CRLF;
				$body .= $this->_encode($this->bodyText) . self::CRLF . self::CRLF;
				$body .= $this->_createBoundary($this->_boundary(1), 'text/html') . self::CRLF;
				$body .= $this->_encode($this->bodyHtml) . self::CRLF . self::CRLF;
				$body .= $this->_boundaryEnd($this->_boundary(1));
				$body .= $this->_attach();
				break;
		}
		return $body;
	}

	/**
	 * ÷
	 * 
	 * @param string $email 
	 * @param string $name 
	 * @return void
	 */
	public function setFrom($email, $name = null) {
		if (!$email || !is_string($email)) return;
		$this->from = $email;
		$name && $email = $this->_encodeHeader($name) . ' <' . $email . '>';
		$this->setMailHeader(self::FROM, $email, false);
	}

	/**
	 * ȡ÷
	 * 
	 * @return string
	 */
	public function getFrom() {
		return $this->from;
	}

	/**
	 * ռ
	 * 
	 * @param string|array $email ռ
	 * @param string $name ռ
	 */
	public function setTo($email, $name = null) {
		if (!$email) return;
		$email = $this->_setRecipientMail($email, $name);
		$this->setMailHeader(self::TO, $email);
	}

	/**
	 * ȡռ
	 * 
	 * @return array
	 */
	public function getTo() {
		return $this->getMailHeader(self::TO);
	}

	/**
	 * ó
	 * 
	 * @param string $email 
	 * @param string $name 
	 */
	public function setCc($email, $name = null) {
		if (!$email) return;
		$email = $this->_setRecipientMail($email, $name);
		$this->setMailHeader(self::CC, $email);
	}

	/**
	 * ȡó͵Ķ
	 * 
	 * @return array
	 */
	public function getCc() {
		return $this->getMailHeader(self::CC);
	}

	/**
	 * ð
	 * 
	 * @param string $email 
	 * @param string $name 
	 */
	public function setBcc($email, $name = null) {
		if (!$email) return;
		$email = $this->_setRecipientMail($email, $name);
		$this->setMailHeader(self::BCC, $email);
	}

	/**
	 * ȡðͶ
	 * 
	 * @return array
	 */
	public function getBcc() {
		return $this->getMailHeader(self::BCC);
	}

	/**
	 * ʼ
	 * 
	 * @param string $subject 
	 */
	public function setSubject($subject) {
		$this->setMailHeader(self::SUBJECT, $this->_encodeHeader($subject), false);
	}

	/**
	 * ȡʼ
	 * 
	 * @return string
	 */
	public function getSubject() {
		$subject = $this->getMailHeader(self::SUBJECT);
		is_array($subject) && $subject = $subject[0];
		return str_replace(array("\r", "\n"), array('', ' '), $subject);
	}

	/**
	 * ʼ
	 * 
	 * @param string $data
	 */
	public function setDate($date) {
		$this->setMailHeader(self::DATE, $date);
	}

	/**
	 * ʼͷ
	 * 
	 * @param string $name ʼͷ
	 * @param string $value ʼͷӦֵ
	 * @param boolean $append Ƿ׷
	 * @return void
	 */
	public function setMailHeader($name, $value, $append = true) {
		is_array($value) || $value = array($value);
		if (false === $append || !isset($this->mailHeader[$name])) {
			$this->mailHeader[$name] = $value;
		} else {
			foreach ($value as $key => $_value) {
				if (is_string($key))
					$this->mailHeader[$name][$key] = $_value;
				else
					$this->mailHeader[$name][] = $_value;
			}
		}
	}

	/**
	 * ʼͷϢֵ
	 * 
	 * @param string $name
	 */
	public function getMailHeader($name) {
		if (!$name) return $this->mailHeader;
		return isset($this->mailHeader[$name]) ? $this->mailHeader[$name] : array();
	}

	/**
	 * ʼϢID
	 */
	public function setMessageId() {
		$user = array_pop($this->getFrom());
		$user || $user = getmypid();
		if ($recipient = $this->getRecipients()) {
			$recipient = array_rand($recipient);
		} else
			$recipient = 'No recipient';
		$host = isset($_SERVER["SERVER_NAME"]) ? $_SERVER["SERVER_NAME"] : php_uname('n');
		$message = sha1(time() . $user . mt_rand() . $recipient) . '@' . $host;
		$this->setMailHeader(self::MESSAGEID, '<' . $message . '>');
	}

	/**
	 * ʼ
	 * 
	 * @param string $encode
	 */
	public function setContentEncode($encode = self::ENCODE_BASE64) {
		$this->encode = $encode;
		$this->setMailHeader(self::CONTENTENCODE, $encode);
	}

	/**
	 * ʼ
	 * 
	 * @param string $type
	 */
	public function setContentType($type = self::MIME_TEXT) {
		if (self::MIME_TEXT == $type || self::MIME_HTML == $type)
			$contentType = sprintf("%s; charset=\"%s\"", $type, $this->charset);
		elseif (self::MIME_RELATED == $type)
			$contentType = sprintf("%s;%s type=\"text/html\";%s boundary=\"%s\"", 
				self::MIME_RELATED, self::CRLF, self::CRLF, $this->_boundary());
		else
			$contentType = sprintf("%s;%s boundary=\"%s\"", $type, self::CRLF, $this->_boundary());
		$this->contentType = $type;
		$this->setMailHeader(self::CONTENTTYPE, $contentType, false);
	}

	/**
	 * ϴ
	 * 
	 * @return string
	 */
	private function _attach() {
		$attach = '';
		foreach ($this->attachment as $key => $value) {
			list($stream, $mime, $disposition, $encode, $filename, $cid) = $value;
			$filename || $filename = 'attachment_' . $key;
			$attach .= $this->_boundaryStart($this->_boundary());
			$attach .= sprintf(self::CONTENTTYPE . ": %s; name=\"%s\"%s", $mime, $filename, 
				self::CRLF);
			$attach .= sprintf(self::CONTENTENCODE . ": %s%s", $encode, self::CRLF);
			if ($disposition == 'inline') {
				$attach .= sprintf(self::CONTENTID . ": <%s>%s", $cid, self::CRLF);
			}
			$attach .= sprintf(self::CONTENTPOSITION . ": %s; filename=\"%s\"%s%s", $disposition, 
				$filename, self::CRLF, self::CRLF);
			$attach .= $this->_encode($stream, $encode) . self::CRLF;
		}
		$attach .= $this->_boundaryEnd($this->_boundary());
		return $attach;
	}

	/**
	 * ȡһquoted-printable
	 * 
	 * @param string $string
	 * @return string
	 */
	private static function getNextQpToken($string) {
		return '=' == substr($string, 0, 1) ? substr($string, 0, 3) : substr($string, 0, 1);
	}

	/**
	 * ȡ߽
	 * 
	 * @return string
	 */
	private function _createBoundary($boundary, $contentType, $charset = '', $encode = '') {
		$result = '';
		$charset || $charset = $this->charset;
		$encode || $encode = $this->encode;
		$result .= $this->_boundaryStart($boundary);
		$result .= sprintf(self::CONTENTTYPE . ": %s; charset=\"%s\"", $contentType, $charset);
		$result .= self::CRLF;
		$result .= sprintf(self::CONTENTENCODE . ": %s%s", $encode, self::CRLF);
		$result .= self::CRLF;
		return $result;
	}

	/**
	 *
	 * @param boundary
	 * @return string
	 */
	private function _boundaryStart($boundary) {
		return '--' . $boundary . self::CRLF;
	}

	/**
	 * ȡ߽
	 * 
	 * @return string
	 */
	private function _boundaryEnd($boundary) {
		return self::CRLF . '--' . $boundary . '--' . self::CRLF;
	}

	/**
	 * òر߽
	 * 
	 * @param int $i ĬֵΪ0
	 * @return string
	 */
	private function _boundary($i = 0) {
		if (!$this->boundary) {
			$uniq_id = md5(uniqid(time()));
			$this->boundary[0] = 'b1_' . $uniq_id;
			$this->boundary[1] = 'b2_' . $uniq_id;
		}
		return $i == 1 ? $this->boundary[1] : $this->boundary[0];
	}

	/**
	 * ʼ
	 * 
	 * @param string $message
	 * @param string $encode
	 * @return string
	 */
	private function _encode($message, $encode = '') {
		return $this->_getEncoder($encode)->encode(trim($message), self::LINELENGTH, self::CRLF);
	}

	/**
	 * ʼͷ
	 * 
	 * @param string $message
	 * @param string $encode
	 * @return string
	 */
	private function _encodeHeader($message, $encode = '') {
		$message = strtr(trim($message), array("\r" => '', "\n" => '', "\r\n" => ''));
		return $this->_getEncoder($encode)->encodeHeader($message, $this->charset, self::LINELENGTH, 
			self::CRLF);
	}

	/**
	 * ݵǰȡʼʼ
	 * 
	 * @param encode
	 * @return IWindMailEncoder
	 */
	private function _getEncoder($encode) {
		$encode || $encode = $this->encode;
		switch ($encode) {
			case self::ENCODE_QP:
				$mailEncoder = Wind::import("WIND:mail.encode.WindMailQp");
				break;
			case self::ENCODE_BASE64:
				$mailEncoder = Wind::import("WIND:mail.encode.WindMailBase64");
				break;
			case self::ENCODE_7BIT:
			case self::ENCODE_8BIT:
			default:
				$mailEncoder = Wind::import("WIND:mail.encode.WindMailBinary");
				break;
		}
		if (!class_exists($mailEncoder)) throw new WindMailException(
			'[mail.WindMail._encode] encod class for ' . $encode . ' is not exist.');
		return new $mailEncoder();
	}

	/**
	 *
	 * @param string $email
	 * @param string $name
	 */
	private function _setRecipientMail($email, $name) {
		$_email = '';
		if (is_array($email)) {
			foreach ($email as $_e => $_n) {
				$_email .= $_n ? $this->_encodeHeader($_n) . ' <' . $_e . '>' : $_e;
				$this->recipients[] = $_e;
			}
		} else {
			$_email = $name ? $this->_encodeHeader($name) . ' <' . $email . '>' : $email;
			$this->recipients[] = $email;
		}
		return $_email;
	}

	/**
	 * ȡʵռ
	 * 
	 * @return array
	 */
	public function getRecipients() {
		return $this->recipients;
	}

	/**
	 * ø
	 * 
	 * @param string $stream ߸
	 * @param string $mime 
	 * @param string $disposition չַʽ
	 * @param string $encode 
	 * @param string $filename ļ
	 * @param string $cid ID
	 */
	public function setAttachment($stream, $mime = self::MIME_OCTETSTREAM, $disposition = self::DIS_ATTACHMENT, $encode = self::ENCODE_BASE64, $filename = null, $cid = 0) {
		$this->attachment[] = array($stream, $mime, $disposition, $encode, $filename, $cid);
	}

	/**
	 * ʼչʾ
	 * 
	 * @param string $body
	 */
	public function setBody($body) {
		$this->bodyHtml = $body;
	}

	/**
	 * ʼıչʾ
	 * 
	 * @param string $bodyText
	 */
	public function setBodyText($bodyText) {
		$this->bodyText = $bodyText;
	}

	/**
	 * ʼַ
	 * 
	 * @param string $charset
	 */
	public function setCharset($charset) {
		$this->charset = $charset;
	}

	/**
	 * ǷǶԴ
	 * 
	 * @param boolean $embed
	 */
	public function setEmbed($embed = false) {
		$this->embed = $embed;
	}
}