<?php
Wind::import('WIND:mail.protocol.WindSocket');
/**
 * imapЭװ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindImap.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package mail
 * @subpackage protocol
 */
class WindImap {

	const CRLF = "\r\n";

	/**
	 * @var string wǩ
	 */
	const TAG = 'Tag';

	/*--------imapʼ---------*/
	
	/**
	 * @var string ѱĶ
	 */
	const SEEN = '\seen';

	/**
	 * @var string ѱظ
	 */
	const ANSWERED = '\Answered';

	/**
	 * @var string ʶΪ
	 */
	const FLAGGED = '\Flagged';

	/**
	 * @var string ʶΪɾ
	 */
	const DELETED = '\Deleted';

	/**
	 * @var string   ݸ
	 */
	const DRAFT = '\Draft';

	/**
	 * @var string ʼ
	 */
	const RECENT = '\Recent';

	/*--------imapʼ--------*/
	
	/*---------imapʼ(store/stripstoreflags)--------*/
	/**
	 * @var string ʼһ־
	 */
	const FLAGS = 'FLAGS';

	/**
	 * @var string ʾһʼı־
	 */
	const SLIENT = 'FLAGS.SLIENT';

	/*---------imapʼ(store/stripstoreflags)--------*/
	
	/*--------fetchв$datanameֵ---------*/
	/**
	 * @var string һʽʼժҪʼ־RFC822.SIZEʱŷϢ
	 */
	const ALL = 'ALL';

	/**
	 * @var string ʼıʽʹСժҪϢ
	 */
	const BODY = 'BODY';

	/**
	 * @var string ʼһЩժҪʼ־RFC822.SIZEʱ
	 */
	const FAST = 'FAST';

	/**
	 * @var string ҪϢʼ־RFC822.SIZEʱBODYSTRUCTUREϢ
	 */
	const FULL = 'FULL';

	/**
	 * @var string ʼı־
	 */
	const FLAG = 'FLAGS';

	/**
	 * @var string  ʼ[MIME-IMB]ṹ
	 */
	const BODYSTRUCTUR = 'BODYSTRUCTUR';

	/**
	 * @var string ʱ䡣
	 */
	const INTERNALDATE = 'INTERNALDATE';

	/**
	 * @var string ͬBODY[]
	 */
	const RFC822 = 'RFC822';

	/**
	 * @var string ʼ[RFC-2822]С
	 */
	const RFC822SIZE = 'RFC822.SIZE';

	/**
	 * @var string ͬBODY.PEEK[HEADER]
	 */
	const RFC822HEADER = 'RFC822.HEADER';

	/**
	 * @var string ϵͬBODY[TEXT]
	 */
	const RFC822TEXT = 'RFC822.TEXT';

	/**
	 * @var string ʼUIDţUIDΨһʶʼһ롣
	 */
	const UID = 'UID';

	/*--------fetchв$datanameֵ---------*/
	
	/*--------headerеfield--------*/
	/**
	 * @var string 
	 */
	const DATE = 'Date';

	/**
	 * @var string 
	 */
	const FROM = 'From';

	/**
	 * @var string ռ
	 */
	const TO = 'To';

	/**
	 * @var string ͵ַ
	 */
	const CC = 'Cc';

	/**
	 * @var string ͵ַ
	 */
	const BCC = 'Bcc';

	/**
	 * @var string ͵ַ
	 */
	const DELIVERED = 'Delivered-To';

	/**
	 * @var string ظַ
	 */
	const REPLY = 'Reply-To';

	/**
	 * @var string 
	 */
	const SUBEJCT = 'Subject';

	/**
	 * @var string MIMEݵ
	 */
	const CONTENTTYPE = 'Content-Type';

	/**
	 * @var string ݵĴ뷽ʽ 
	 */
	const CONTENTENCODE = 'Content-Transfer-Encoding';

	/**
	 * @var string MIME汾
	 */
	const MIMEVERSION = 'MIME-Version';

	/**
	 * @var string ϢID
	 */
	const MESSAGEID = 'Message-Id';

	/**
	 * @var string ·
	 */
	const RECEIVED = 'Received';

	/**
	 * @var string ظַ
	 */
	const RETURNPATH = 'Return-Path';

	/*--------headerеfield--------*/
	
	/*--------statusò--------*/
	/**
	 * @var string  еʼ
	 */
	const S_MESSAGES = 'MESSAGES';

	/**
	 * @var string  б־Ϊ\RECENTʼ
	 */
	const S_RECENT = 'RECENT';

	/**
	 * @var string  ԷʼһUID
	 */
	const S_UIDNEXT = 'UIDNEXT';

	/**
	 * @var string  UIDЧԱ־
	 */
	const S_UIDVALIDITY = 'UIDVALIDITY';

	/**
	 * @var string  ûб־Ϊ\UNSEENʼ
	 */
	const S_UNSEEN = 'UNSEEN';

	/*--------statusò--------*/
	
	/*--------searchò--------*/
	/**
	 * @var string еƥ
	 */
	CONST SH_ALL = 'ALL';

	/**
	 * @var string µʼ
	 */
	CONST SH_NEW = 'NEW';

	/**
	 * @var string ʼд\Answeredǵʼ
	 */
	CONST SH_ANSWERED = 'ANSWERED';

	/**
	 * @var string ʼְָ͵ʼ
	 */
	CONST SH_BCC = 'BCC';

	/**
	 * @var string ָǰʼ
	 */
	CONST SH_BEFORE = 'BEFORE';

	/**
	 * @var string ʼ
	 */
	CONST SH_BODY = 'BODY';

	/**
	 * @var string ʼд\Deletedǵʼ
	 */
	CONST SH_DELETED = 'DELETED';

	/**
	 * @var string ʼд\Flaggedǵʼ
	 */
	CONST SH_FLAGGED = 'FLAGGED';

	/**
	 * @var string ֶָεʼ
	 */
	CONST SH_FROM = 'FROM';

	/**
	 * @var string ʼϢָkeyworkʼ
	 */
	CONST SH_KEYWORD = 'KEYWORD';

	/**
	 * @var string ʼд\Recentǵʼ
	 */
	CONST SH_RECENT = 'RECENT';

	/**
	 * @var string ʼд\Seenǵʼ
	 */
	CONST SH_SEEN = 'SEEN';

	/**
	 * @var string ָ֮ʼ
	 */
	CONST SH_SINCE = 'SINCE';

	/**
	 * @var string ʼıַָʼ
	 */
	CONST SH_TEXT = 'TEXT';

	/**
	 * @var string ָռֶεʼ
	 */
	CONST SH_TO = 'TO';

	/**
	 * @var string ʼûд\Answeredǵʼ
	 */
	CONST SH_UNANSWERED = 'UNANSWERED';

	/**
	 * @var string  ʼûд\Deletedǵʼ
	 */
	CONST SH_UNDELETED = 'UNDELETED';

	/**
	 * @var string  ʼûָؼֵʼ
	 */
	CONST SH_UNKEYWORD = 'UNKEYWORD';

	/**
	 * @var string  ʼûд\Seenǵʼ
	 */
	CONST SH_UNSEEN = 'UNSEEN';

	/**
	 * @var string  ʼûд\UNFLAGGEDǵʼ
	 */
	CONST SH_UNFLAGGED = 'UNFLAGGED';

	/*--------searchò--------*/
	
	/******bodyеsection********/
	const TEXT = 'TEXT';

	const HEADER = 'HEADER';

	/******bodyеsection********/
	/**
	 * @var WindSocket imapʼ
	 */
	protected $imap = null;

	protected $seperate = ' ';

	protected $request = array();

	protected $resonse = array();

	private $tag = 0;

	public function __construct($host, $port) {
		$this->imap = new WindSocket($host, $port);
	}

	/**
	 * һimap
	 * @return string
	 */
	public function open() {
		$this->imap->open();
		return $this->response('*');
	}

	/**
	 * ½
	 * @param string $username
	 * @param string $password
	 * @return string
	 */
	public function login($username, $password) {
		return $this->communicate("LOGIN {$username} {$password}");
	}

	/**
	 * ֵָ䡣ͨǴ·ļȫ
	 * @param string $folder;
	 * @param string
	 */
	public function create($folder) {
		return $this->communicate("CREATE {$folder}");
	}

	/**
	 * ֵָļСļͨǴ·ļȫ
	 * 䱻ɾеʼҲڡ
	 * @param string $folder
	 * @return string
	 */
	public function delete($folder) {
		return $this->communicate("DELETE {$folder}");
	}

	/**
	 * RENAME޸ļеƣʹǰ
	 * ϱ׼· 
	 * @param string $old ǰ
	 * @param string $new 
	 * @return string
	 */
	public function rename($old, $new) {
		return $this->communicate("RENAME {$old} {$new}");
	}

	/**
	 * LISTгеļУеϵͳĿ¼
	 * @param string $base û½Ŀ¼
	 * @param string $template ʾʹͨ"*"
	 * @return string
	 */
	public function folderOfmail($base = '', $template = '*') {
		return $this->communicate("LIST {$base} {$template}");
	}

	/**
	 * ѡĳ䣨FolderʾԸ䣨Folderڵʼ
	 * ־ĵǰ״̬ҲظûͬʱصĻһЩʼĸϢ
	 * @param string $folder
	 */
	public function select($folder) {
		return $this->communicate("SELECT $folder");
	}

	/**
	 * ȡʼıϢҽʾĿġ
	 * @param int|string $mail ϣȡʼŻðŷָ
	 * @param string $datanames
	 */
	public function fetch($mail, $datanames = self::ALL) {
		return $this->communicate("FETCH {$mail} {$datanames}");
	}

	/**
	 * ȡʼͷϢ
	 * @param int|string $mail ϣȡʼŻðŷָ
	 * @return string
	 */
	public function fetchHeader($mail) {
		return $this->communicate("FETCH {$mail} BODY[HEADER]");
	}

	/**
	 * ȡʼͷֶϢ,ɲȫ
	 * @param int|string $mail ϣȡʼŻðŷָ
	 * @param string $field ͷֶ(DATE\SUBJECT\FROM\TO\MESSAGEID\CONTENTTYPE)
	 * @return string
	 */
	public function fetchHeaderFields($mail, $field = self::DATE) {
		$field = is_array($field) ? implode(' ', $field) : $field;
		return $this->communicate("FETCH {$mail} BODY[HEADER.FIELDS ({$field})]");
	}

	/**
	 * ȡʼͷųֶϢ
	 * @param int|string $mail ϣȡʼŻðŷָ
	 * @param string $field ͷֶ(DATE\SUBJECT\FROM\TO\MESSAGEID\CONTENTTYPE)
	 * @return string
	 */
	public function fetchHeaderNotFields($mail, $field = self::DATE) {
		$field = is_array($field) ? implode(' ', $field) : $field;
		return $this->communicate("FETCH {$mail} BODY[HEADER.FIELDS.NOT ({$field})]");
	}

	/**
	 * ȡʼMIME
	 * @param int|string $mail ϣȡʼŻðŷָ
	 * @return string
	 */
	public function fetchMime($mail) {
		return $this->communicate("FETCH {$mail} BODY[MIME]");
	}

	/**
	 * ȡʼText
	 * @param int|string $mail ϣȡʼŻðŷָ
	 * @return string
	 */
	public function fetchText($mail) {
		return $this->communicate("FETCH {$mail} BODY[TEXT]");
	}

	/**
	 * ʼеĳһָ֣صĲsectionʾ
	 * sectionְϢͨǴĳһֵһֻĳһ֣
	 * HEADER, HEADER.FIELDS, HEADER.FIELDS.NOT, MIME, and TEXT
	 * sectionǿյĻǾʹȫϢͷϢ
	 * @param int|string $mail ϣȡʼŻðŷָ
	 * @param int|string $section صĲ
	 * @return string
	 */
	public function fetchBySection($mail, $section = self::TEXT) {
		return $this->communicate("FETCH {$mail} BODY[$section]");
	}

	/**
	 * ʼеĳһָ֣صĲsectionʾ
	 * sectionְϢͨǴĳһֵһֻĳһ֣
	 * HEADER, HEADER.FIELDS, HEADER.FIELDS.NOT, MIME, and TEXT
	 * sectionǿյĻǾʹȫϢͷϢ
	 * @param int|string $mail ϣȡʼŻðŷָ
	 * @param int $start صĲֵĿʼ
	 * @param int $end   صĲֵĽ
	 * @param int:string $section صĲ
	 * @return string
	 */
	public function fetchPartialOfSection($mail, $start, $end, $section = self::TEXT) {
		return $this->communicate("FETCH {$mail} BODY[$section]<{$start}.{$end}>");
	}

	/**
	 * ޸ָʼԣʼѶǡɾǵ
	 * @param INT|string $mail
	 * @param string $flags imapеʼ,ֵΪSLIENTFLAGS
	 * @param STRING|ARRAY $attribute (DELETED\ANSWERED\RECENT\DRAFT\FLAGGED)
	 * @return string
	 */
	public function store($mail, $flags = self::FLAGS, $attribute = self::ANSWERED) {
		$attribute = is_array($attribute) ? implode(' ', $attribute) : $attribute;
		return $this->communicate("STORE {$mail} +" . self::FLAGS . " ($attribute)");
	}

	/**
	 * ޸ָʼԣʼѶǡɾǵ
	 * @param INT|string $mail
	 * @param string $flags imapеʼ,ֵΪSLIENTFLAGS
	 * @param STRING|ARRAY $attribute (DELETED\ANSWERED\RECENT\DRAFT\FLAGGED)
	 * @return string
	 */
	public function stripStore($mail, $flags = self::FLAGS, $attribute = self::DELETED) {
		$attribute = is_array($attribute) ? implode(' ', $attribute) : $attribute;
		return $this->communicate("STORE {$mail} -" . self::FLAGS . " ($attribute)");
	}

	/**
	 * ԵǰFolderļ/䣩ķʣ
	 * رб־ΪDELETEDʼͱɾ
	 */
	public function close() {
		return $this->communicate("CLOSE");
	}

	/**
	 * رɾеı־ΪDELETEDʼ
	 * EXPUNGEɾʼԻָ 
	 */
	public function expunge() {
		return $this->communicate("EXPUNGE");
	}

	/**
	 * ֻʽ
	 * @param string $mailbox 
	 * @return string
	 */
	public function examine($mailbox) {
		return $this->communicate("EXAMINE $mailbox");
	}

	/**
	 * ڿͻĻбһ
	 * @param string $mailbox ϣӵ
	 */
	public function subscribe($mailbox) {
		return $this->communicate("SUBSCRIBE $mailbox");
	}

	/**
	 * ӻбȥһ
	 * @param string $mailbox ϣȥ
	 */
	public function unsubscribe($mailbox) {
		return $this->communicate("UNSUBSCRIBE $mailbox");
	}

	/**
	 * LISTLISTû$HOMEĿ¼еļ
	 * LSUBֻʾЩʹSUBSCRIBEΪļ
	 * @param string $folder  ·
	 * @param string $mailbox 
	 * @return string
	 */
	public function lsub($folder, $mailbox) {
		return $this->communicate("LSUB {$mailbox} {$mailbox}");
	}

	/**
	 * ѯĵǰ״̬
	 * @param string $mailbox Ҫѯ
	 * @param string $params  ͻҪѯĿб,S_MESSAGES\S_RECENT\S_UIDNEXT\S_UIDVALIDITY\S_UNSEEN
	 * @return string
	 */
	public function status($mailbox, $params = self::S_MESSAGES) {
		
		$params = is_array($params) ? implode(' ', $params) : $params;
		return $this->communicate("STATUS {$mailbox} ({$params})");
	}

	/**
	 * һ,ȷڴеĴ̻ݶд˴ϡ
	 */
	public function check() {
		return $this->communicate("CHECK");
	}

	/**
	 * ڴڻ״̬ʼȻʾƥʼš
	 * @param string $criteria ѯȷѯĹؼ
	 * @param string $value ѯȷѯĹؼֵֵ
	 * @param string $charset ַ־,ȱʡı־US-ASC
	 * @return string
	 */
	public function search($criteria = self::SH_ALL, $value = null) {
		$search = $criteria;
		if ($value) {
			$search .= ' ' . $value;
		}
		return $this->communicate("SEARCH {$search}");
	}

	/**
	 * UIDΨһʶʼϵͳʼ32λ֤顣
	 * ͨЩʹ˳ʶеʼ
	 * ʹUIDʹIMAPͻסͬIMAPỰеʼ
	 */
	public function uid() {
		return $this->communicate("UID");
	}

	/**
	 * ʼһ临Ƶһ
	 * @param int $soruce ϣӻиƵʼı
	 * @param string $dst ʼƵ
	 * @return string
	 */
	public function copy($soruce, $dst) {
		return $this->communicate("COPY {$soruce} {$dst}");
	}

	/**
	 * IMAPֵ֧Ĺб
	 * յͻ͵CAPABILITY󽫷ظ÷ֵ֧Ĺܡ
	 */
	public function capability() {
		return $this->communicate("CAPABILITY");
	}

	/**
	 * IMAPỰ
	 */
	public function logout() {
		$this->communicate("LOGOUT");
	}

	/**
	 * imapỰ
	 * @param string $request
	 */
	public function request($request) {
		$this->request[] = $request;
		$this->setTag();
		return $this->imap->request($this->getTag() . ' ' . $request . self::CRLF);
	}

	/**
	 * imapỰӦ
	 * @param int $timeout
	 */
	public function responseLine($timeout = null) {
		if (null !== $timeout) {
			$this->imap->setSocketTimeOut((int) $timeout);
		}
		return $this->imap->responseLine();
	}

	/**
	 * ֤
	 * @param boolean $multi
	 * @param int $timeout
	 * @return string
	 */
	public function response($endTag = '*', $timeout = null) {
		$response = '';
		while ('' != ($_response = $this->responseLine($timeout))) {
			list($tag, $status, $info) = explode(' ', $_response, 3);
			if (in_array($status, array('NO', "BAD"))) {
				throw new WindException('[mail.protocol.WindImap.response] ' . $_response);
			}
			$response .= $_response;
			$this->resonse[] = $_response;
			if ($endTag == $tag) {
				break;
			}
		}
		if (empty($response)) throw new WindException('[mail.protocol.WindImap.response] No response');
		return $response;
	}

	/**
	 * һimap
	 * @param string $request 
	 * @param string $response Ӧ
	 * @return string
	 */
	public function communicate($request, &$response = null) {
		$this->request($request);
		return $response = $this->response($this->getTag());
	}

	/**
	 * imapỰ±
	 */
	public function setTag() {
		$this->tag++;
	}

	/**
	 * ȡimapеıǩ
	 * @return string
	 */
	public function getTag() {
		return self::TAG . $this->tag;
	}

	public function __destruct() {
		if ($this->imap) {
			$this->logout();
			$this->imap->close();
			$this->imap = null;
		}
	}

}