<?php
Wind::import('WIND:mail.protocol.WindSocket');
/**
 * pop3Э
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindPop3.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package mail
 * @subpackage protocol
 */
class WindPop3 {

	const CRLF = "\r\n";

	/**
	 * @var WindSocket pop3ʼ
	 */
	protected $pop3 = null;

	protected $seperate = ' ';

	protected $request = array();

	protected $resonse = array();

	public function __construct($host, $port) {
		$this->pop3 = new WindSocket($host, $port);
	}

	/**
	 * pop3,
	 * @return string
	 */
	public function open() {
		$this->pop3->open();
		return $this->response();
	}

	/**
	 * ½pop3
	 * @param string $username û
	 * @param string $password 
	 * @return string
	 */
	public function login($username, $password) {
		$this->communicate("USER $username");
		return $this->communicate("PASS $password");
	}

	/**
	 *  server ͳϣʼ ʼֽ
	 * @return string
	 */
	public function stat() {
		return $this->communicate('STAT', false, true);
	}

	/**
	 *  server ڸָʼΨһʶ ûָеġ
	 * @param int $n ָʼ
	 * @return string
	 */
	public function uidl($n = null) {
		$request = $n ? "UIDL $n" : 'UIDL';
		$ifmulti = $n ? false : true;
		return $this->communicate($request, $ifmulti, true);
	}

	/**
	 *  server ָʼĴС 
	 * @param int $n ָʼ
	 * @return string
	 */
	public function getList($n = null) {
		$request = $n ? "LIST $n" : 'LIST';
		$ifmulti = $n ? false : true;
		return $this->communicate($request, $ifmulti, true);
	}

	/**
	 *  server ʼȫı
	 * @param int $n ָʼ
	 * @return string
	 */
	public function retr($n) {
		return $this->communicate("RETR $n", true);
	}

	/**
	 *  server ɾQUIT ִʱɾ 
	 * @param int $n ָʼ
	 * @return string
	 */
	public function dele($n) {
		return $this->communicate("DELE $n");
	}

	/**
	 * е DELE 
	 * @return string
	 */
	public function rset() {
		return $this->communicate("RSET");
	}

	/**
	 *   n ʼǰ m ݣm Ȼ
	 * @param int $n ָʼ
	 * @param int $m ָʼǰ
	 * @return string
	 */
	public function top($n, $m = null) {
		$request = $m ? 'TOP ' . (int) $n . ' ' . (int) $m : 'TOP ' . (int) $n;
		return $this->communicate($request, true);
	}

	/**
	 *  server һ϶Ӧ
	 * @return string
	 */
	public function noop() {
		return $this->communicate("NOOP");
	}

	/**
	 * ϣỰ server "" ״̬
	 * ڽ""״̬ɾЩǳɾʼ
	 *  server "Ͽ"״̬Ựʱ server
	 * ""״̬  
	 * @return string
	 */
	public function quit() {
		return $this->communicate("QUIT");
	}

	/**
	 * Ự,رpop3
	 */
	public function close() {
		$this->quit();
		$this->pop3->close();
		$this->pop3 = null;
	}

	/**
	 * pop3Ӧ
	 * @param int $timeout
	 */
	public function responseLine($timeout = null) {
		if (null !== $timeout) {
			$this->pop3->setSocketTimeOut((int) $timeout);
		}
		return $this->pop3->responseLine();
	}

	/**
	 * Ӧ
	 * @param string $response
	 * @return Array
	 */
	public function buildResponse($response) {
		if (empty($response)) {
			return array();
		}
		$response = explode("\n", $response);
		$_response = array();
		foreach ($response as $line) {
			if (empty($line)) {
				continue;
			}
			list($key, $value) = explode($this->seperate, trim($line), 2);
			$key ? $_response[(int) $key] = $value : $_response[] = $value;
		}
		return $_response;
	}

	/**
	 * һ紫ͨ
	 * @param string $request s
	 * @param boolean $ifmulti Ƿ񷵻ضӦıΪһ
	 * @param baoolean $ifbuild ǷӦд
	 * @return array
	 */
	public function communicate($request, $ifmulti = false, $ifbuild = false) {
		$this->request($request);
		return $ifbuild ? $this->buildResponse($this->response($ifmulti)) : $this->response($ifmulti);
	}

	/**
	 * pop3
	 * @param string $request
	 */
	public function request($request) {
		$this->request[] = $request;
		return $this->pop3->request($request . self::CRLF);
	}

	/**
	 * ֤
	 * @param boolean $multi
	 * @param int $timeout
	 * @return string
	 */
	public function response($multi = false, $timeout = null) {
		$ok = $this->responseLine($timeout);
		if (empty($ok) || !is_string($ok)) {
			throw new WindException('[mail.protocol.WindPop3.response] Read Failed');
		}
		if ('+OK' !== substr($ok, 0, 3)) {
			throw new WindException('[mail.protocol.WindPop3.response] Request Failed!Pleae See Failed Info:' . $ok);
		}
		if (true === $multi) {
			$response = '';
			while ('' != ($_response = $this->responseLine($timeout))) {
				if ('.' === trim($_response)) {
					break;
				}
				$response .= $_response;
				$this->resonse[] = $_response;
			}
		} else {
			$this->resonse[] = $ok;
			if (strpos($ok, $this->seperate)) {
				list(, $response) = explode($this->seperate, $ok, 2);
			} else {
				$response = $ok;
			}
		}
		if (empty($response)) throw new WindException('[mail.protocol.WindPop3.response] No response');
		return $response;
	}

	/**
	 * ȡ
	 * @param $content
	 * @param $sep
	 */
	public function getMailContent($content, $sep = "\n\n") {
		$content = explode($sep, $content);
		$content[0] = explode("\n", $content[0]);
		$headers = array();
		foreach ($content[0] as $value) {
			$_value = explode(':', $value);
			$headers[$_value[0]] = trim($_value[1]);
		}
		$encode = $headers['Content-Transfer-Encoding'];
		if ('base64' == $encode) {
			$content = base64_decode($content[1]);
		} else {
			$content = $content[1];
		}
		return array($headers, $content);
	}

	public function __destruct() {
		if ($this->pop3) {
			$this->close();
		}
	}

}
?>