<?php
Wind::import('WIND:mail.protocol.WindSocket');
/**
 * ʼЭ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindSmtp.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package mail
 * @subpackage protocol
 */
class WindSmtp {

	const CRLF = "\r\n";

	/**
	 * @var WindSocket
	 */
	protected $smtp = null;

	protected $request = array();

	protected $resonse = array();

	public function __construct($host, $port, $timeout = 60) {
		$this->smtp = new WindSocket($host, $port, $timeout);
	}

	/**
	 * smtp,
	 * @return string
	 */
	public function open() {
		$this->smtp->open();
		return $this->checkResponse(220);
	}

	/**
	 * ʶû
	 * @param string $host 
	 * @return string
	 */
	public function ehlo($host) {
		$this->request('EHLO ' . $host);
		return $this->checkResponse(250);
	}

	/**
	 * û֤ 
	 * @param string $username û
	 * @param string $password 
	 * @return string
	 */
	public function authLogin($username, $password) {
		$this->request('AUTH LOGIN');
		$this->checkResponse(array(334));
		$this->request(base64_encode($username));
		$this->checkResponse(array(334));
		$this->request(base64_encode($password));
		return $this->checkResponse(array(235));
	}

	/**
	 * ָĵַǷ˵ַ
	 * @param string $from ʼ
	 * @return string
	 */
	public function mailFrom($from) {
		$this->request('MAIL FROM:' . '<' . $from . '>');
		return $this->checkResponse(250);
	}

	/**
	 * ָĵַռ˵ַ
	 * @param string $to ʼ
	 * @return string
	 */
	public function rcptTo($to) {
		$this->request('RCPT TO:' . '<' . $to . '>');
		return $this->checkResponse(array(250, 251));
	}

	/**
	 * ָ֤û/Ƿڣڰȫԭ򣬷ֹ
	 * @param string $user
	 * @return string
	 */
	public function very($user) {
		$this->request('VRFY ' . $user);
		return $this->checkResponse(array(250, 251, 252));
	}

	/**
	 * ֤бǷڣбҲ
	 * @param string $name
	 * @return string
	 */
	public function expn($name) {
		$this->request('EXPN ' . $name);
		$response = $this->checkResponse(250);
		$entries = explode(self::CRLF, $response);
		while (list(, $l) = each($entries)) {
			$list[] = substr($l, 4);
		}
		return $list;
	}

	/**
	 * ޲ӦӦ OK 
	 * @return string
	 */
	public function noop() {
		$this->request('NOOP');
		return $this->checkResponse(250);
	}

	/**
	 * ڵ RCPT 󣬱ʾеʼѱʶʼݴ䣬 CRLF.CRLF  
	 * @param string $data ͵
	 * @return string
	 */
	public function data($data) {
		$this->request('DATA');
		$this->checkResponse(354);
		$data = str_replace("\r\n", "\n", $data);
		$data = str_replace("\r", "\n", $data);
		$lines = explode("\n", $data);
		foreach ($lines as $line) {
			if (0 === strpos($line, '.')) {
				$line = '.' . $line;
			}
			$this->request($line);
		}
		$this->request('.');
		return $this->checkResponse(250);
	}

	/**
	 * ûỰǰ䱻ȡ
	 * @return string
	 */
	public function rset() {
		$this->request('RSET');
		return $this->checkResponse(array(250, 220));
	}

	/**
	 * Ự 
	 * @return string
	 */
	public function quit() {
		$this->request('QUIT');
		return $this->checkResponse(221);
	}

	/**
	 * رsmtp
	 */
	public function close() {
		$this->smtp->close();
		$this->smtp = null;
	}

	/**
	 * smtpӦ
	 * @param int $timeout
	 */
	public function responseLine($timeout = null) {
		if (null !== $timeout) {
			$this->smtp->setSocketTimeOut((int) $timeout);
		}
		return $this->smtp->responseLine();
	}

	/**
	 * smtp
	 * @param string $request
	 */
	public function request($request) {
		$this->request[] = $request . self::CRLF;
		return $this->smtp->request($request . self::CRLF);
	}

	/**
	 * ֤
	 * @param string $expect
	 * @param int $timeout
	 * @return string
	 */
	public function checkResponse($expect, $timeout = null) {
		$response = '';
		$expect = is_array($expect) ? $expect : array($expect);
		while ('' != ($_response = $this->responseLine($timeout))) {
			$response .= $_response;
			$this->resonse[] = $_response;
			list($code, $info) = preg_split('/([\s-]+)/', $_response, 2);
			if (null === $code || !in_array($code, $expect)) throw new WindException('[mail.protocol.WindSmtp.checkResponse] ' . $info);
			if (" " == substr($_response, 3, 1)) {
				break;
			}
		}
		if (empty($response)) throw new WindException('[mail.protocol.WindSmtp.checkResponse] No response');
		return $response;
	}

	public function __destruct() {
		if ($this->smtp) {
			$this->close();
		}
	}

}