<?php
/**
 * socket׽ֲ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindSocket.php 3904 2013-01-08 07:01:26Z yishuo $ 
 * @package mail
 * @subpackage protocol
 */
class WindSocket {
	protected $host = '127.0.0.1';
	protected $port = 80;
	protected $timeout = 5;
	protected $errno = 0;
	protected $errstr = '';
	protected $socket = null;

	public function __construct($host = '127.0.0.1', $port = 80, $timeout = 5) {
		$this->setHost($host);
		$this->setPort($port);
		$this->setTimeout($timeout);
	}

	/**
	 * һ
	 */
	public function open() {
		if (null == $this->socket) {
			$this->socket = fsockopen($this->host, $this->port, $this->errno, $this->errstr, 
				$this->timeout);
			if ($this->socket == false) throw new WindMailException(
				'[mail.protocol.WindSocket.open] Initiates a socket connection fail, ' . $this->host . ' is not a valid domain.');
		}
	}

	/**
	 * 
	 * @param string $request
	 */
	public function request($request) {
		return fputs($this->socket, $request);
	}

	/**
	 * Ӧ
	 * @return string
	 */
	public function response() {
		$response = '';
		while (!feof($this->socket)) {
			$response .= fgets($this->socket);
		}
		return $response;
	}

	/**
	 * Ӧ,ֻһ
	 * @return string
	 */
	public function responseLine() {
		return feof($this->socket) ? '' : fgets($this->socket);
	}

	/**
	 *ر 
	 */
	public function close() {
		if ($this->socket) {
			fclose($this->socket);
			$this->socket = null;
		}
		return true;
	}

	/**
	 * ȡеĴ
	 * @return string
	 */
	public function getError() {
		return $this->errstr ? $this->errno . ':' . $this->errstr : '';
	}

	/**
	 * ȡsocket
	 * @return resource
	 */
	public function getSocket() {
		return $this->socket;
	}

	/**
	 * 
	 * @param string $host
	 */
	public function setHost($host) {
		$this->host = $host;
	}

	/**
	 * ö˿
	 * @param string $port
	 */
	public function setPort($port) {
		$this->port = $port;
	}

	/**
	 * óʱ
	 * @param int $timeout
	 */
	public function setTimeout($timeout) {
		$this->timeout = $timeout;
	}

	public function setSocketTimeOut($timeout) {
		return stream_set_timeout($this->socket, $timeout);
	}
}