<?php
Wind::import('WIND:mail.sender.IWindSendMail');
Wind::import('WIND:mail.protocol.WindSmtp');
/**
 * ʼ
 * 
 * Ϣ:<pre>
 * $config = array(
 * 'host' => '',	
 * 'port' => '',	˿ں
 * 'name' => '',	
 * 'auth' => '',	
 * 'user' => '',
 * 'password' => '',
 * 'timeout' => '', ʱʱ,Ĭ60
 * )
 * </pre>
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindSmtpMail.php 3298 2012-01-06 12:48:26Z yishuo $ 
 * @package mail
 * @subpackage sender
 */
class WindSmtpMail extends WindModule implements IWindSendMail {
	/**
	 * @var WindSmtp ʼͷ
	 */
	protected $smtp = null;
	/**
	 * ʼͷ
	 *
	 * @var string
	 */
	protected $host;
	/**
	 * ʼͶ˿
	 *
	 * @var int
	 */
	protected $port;
	/**
	 * @var string ʼ
	 */
	protected $name;
	/**
	 * Ƿ֤
	 * 
	 * @var boolean
	 */
	protected $auth;
	/**
	 * @var string ʼû
	 */
	protected $username;
	/**
	 * @var string ʼ
	 */
	protected $password;
	/**
	 * ʱʱ
	 *
	 * @var string
	 */
	protected $timeout = 60;

	/**
	 * @param WindMail $mail 
	 * @see IWindSendMail::send()
	 */
	public function send($mail, $config = array()) {
		if ($this->smtp === null) {
			$this->_init($config);
			$this->smtp = new WindSmtp($this->host, $this->port, $this->timeout);
		}
		$this->smtp->open();
		$this->smtp->ehlo($this->name);
		if ($this->auth) $this->smtp->authLogin($this->username, $this->password);
		$this->smtp->mailFrom($mail->getFrom());
		foreach ($mail->getRecipients() as $rcpt)
			$this->smtp->rcptTo($rcpt);
		$this->smtp->data($mail->createHeader() . $mail->createBody());
		$this->smtp->quit();
		return true;
	}

	/**
	 * @param array() $config
	 */
	private function _init($config) {
		parent::setConfig($config);
		$this->host = $this->getConfig('host', '', '127.0.0.1');
		$this->port = $this->getConfig('port', '', '25');
		$this->name = $this->getConfig('name', '', 'localhost');
		$this->auth = $this->getConfig('auth', '', true);
		$this->username = $this->getConfig('user');
		$this->password = $this->getConfig('password');
		$this->timeout = $this->getConfig('timeout', '', 60);
	}
}