<?php
Wind::import('WIND:parser.IWindConfigParser');
/**
 * ļ
 * 
 * ļʽ4иʽxml, php, properties, ini
 * 
 * ûļλýļ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindConfigParser.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package parser
 */
class WindConfigParser implements IWindConfigParser {
	const CONFIG_XML = '.XML';
	const CONFIG_PHP = '.PHP';
	const CONFIG_INI = '.INI';
	const CONFIG_PROPERTIES = '.PROPERTIES';
	private $configs = array();
	
	/* (non-PHPdoc)
     * @see IWindConfigParser::parse()
     */
	public function parse($configPath, $alias = '', $append = '', AbstractWindCache $cache = null) {
		if ($alias && $cache && ($config = $this->getCache($alias, $append, $cache))) return $config;
		if (!is_file($configPath)) throw new WindException(
			'[parser.WindConfigParser.parse] The file \'' . $configPath . '\' is not exists');
		$ext = strtoupper(strrchr($configPath, '.'));
		$config = ($ext == self::CONFIG_PHP) ? @include ($configPath) : $this->createParser($ext)->parse($configPath);
		if ($alias && $cache) $this->setCache($alias, $append, $cache, $config);
		return $config;
	}

	/**
	 * û
	 * 
	 * $alias$appendĹϵ:
	 * <ul>
	 * <li>û$aliasû$cache򽫲</li>
	 * <li>û$append: 򽫻$aliasΪ$dataڻ$cache</li>
	 * <li>$append$alias: ȥ$cacheлΪ$appendĻݣҽ$data$aliasΪ浽û,
	 * ȻȻ$append֮дص$cache</li>
	 * </ul>
	 * 
	 * @param string $alias ļĻ
	 * @param string $append ļ׷ӵ
	 * @param AbstractWindCache $cache ļʹõĻ
	 * @return void
	 */
	private function setCache($alias, $append, $cache, $data) {
		if ($append) {
			$this->configs[$alias] = $data;
			$cache->set($append, $this->configs);
		} else {
			$cache->set($alias, $data);
		}
	}

	/**
	 * û
	 * 
	 * @param string $alias ñõ
	 * @param string $append ׷ӵ
	 * @param AbstractWindCache $cache ñĻ
	 * @return array
	 */
	private function getCache($alias, $append, $cache) {
		if (!$append) return $cache->get($alias);
		if (isset($this->configs[$alias])) return $this->configs[$alias];
		$this->configs = $cache->get($append);
		return isset($this->configs[$alias]) ? $this->configs[$alias] : array();
	}

	/**
	 * ļ
	 * 
	 * @param string $type ļ
	 * @return object 
	 */
	private function createParser($type) {
		switch ($type) {
			case self::CONFIG_XML:
				Wind::import("WIND:parser.WindXmlParser");
				return new WindXmlParser();
			case self::CONFIG_INI:
				Wind::import("WIND:parser.WindIniParser");
				return new WindIniParser();
			case self::CONFIG_PROPERTIES:
				Wind::import("WIND:parser.WindPropertiesParser");
				return new WindPropertiesParser();
			default:
				throw new WindException('[parser.WindConfigParser.createParser] \'ConfigParser\' failed to initialize.');
		}
	}
}