<?php
/**
 * propertiesʽļ
 * 
 * propertiesļеעΪע#
 * ͬʱļҲýƣ磺
 * <code>
 * [test]
 * path=index.php
 * address.zipcode=10000
 * address.show=true //trueᱻΪboolean͵truefalseҲboolean͵false
 * </code>
 * ĸʽ:
 * <code>
 * array(
 * 'test' => array(
 * 		'path' => 'index.php',
 * 		'address' => array(
 * 			'zipcode' => '10000',
 * 			'show' => true
 *  	)
 *  )
 *)
 * </code>
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindPropertiesParser.php 2973 2011-10-15 19:22:48Z yishuo $
 * @package parser
 */
class WindPropertiesParser {

	const COMMENT = '#';

	const LPROCESS = '[';

	const RPROCESS = ']';

	const ARRAY_SEP = '.';

	public function __construct() {}

	/**
	 * propertiesļ
	 * 
	 * @param string $filename ļ
	 * @param boolean $build   Ƿ񰴸ʽĬΪtrue
	 * @return array
	 */
	public function parse($filename, $build = true) {
		$data = $this->parse_properties_file($filename);
		return $build ? $this->buildData($data) : $data;
	}

	/**
	 * propertiesļһά
	 * 
	 * һ filename ָ properties ļ
	 * еΪһ鷵ء
	 * 
	 * @param string $filename ļ
	 * @return array
	 */
	private function parse_properties_file($filename) {
		if (!is_file($filename) || !in_array(substr($filename, strrpos($filename, '.') + 1), array('properties'))) {
			return array();
		}
		$content = explode("\n", WindFile::read($filename));
		$data = array();
		$last_process = $current_process = '';
		foreach ($content as $key => $value) {
			$value = str_replace(array("\n", "\r"), '', trim($value));
			if (0 === strpos(trim($value), self::COMMENT) || in_array(trim($value), array('', "\t", "\n"))) {
				continue;
			}
			$tmp = explode('=', $value, 2);
			if (0 === strpos(trim($value), self::LPROCESS) && (strlen($value) - 1) === strrpos($value, self::RPROCESS)) {
				$current_process = $this->trimChar(trim($value), array(self::LPROCESS, self::RPROCESS));
				$data[$current_process] = array();
				$last_process = $current_process;
				continue;
			}
			$tmp[0] = trim($tmp[0]);
			if (count($tmp) == 1 ) {
				$last_process ? $data[$last_process][$tmp[0]] = '' : $data[$tmp[0]] = '';
				continue;
			}
			$tmp[1] = trim($tmp[1], '\'"');
			$__tmpValue = strtolower($tmp[1]);
			$tmp[1] = 'false' === $__tmpValue ? false : ('true' === $__tmpValue ? true : $tmp[1]);
			
			$last_process ? $data[$last_process][$tmp[0]] = $tmp[1] : $data[$tmp[0]] = $tmp[1];
		}
		return $data;
	}

	/**
	 * 
	 * 
	 * @param array $data Դ
	 * @return array
	 */
	private function buildData(&$data) {
		foreach ((array) $data as $key => $value) {
			if (is_array($value)) {
				$data[$key] = $this->formatDataArray($value);
			} else {
				$this->formatDataFromString($key, $value, $data);
			}
		}
		return $data;
	}

	/**
	 * ÿpropertiesļת
	 * 
	 * @param string $key propertiesļеļ
	 * @param string $value propertiesļеֵ
	 * @param array $data ,ĬΪarray()
	 * @return array
	 */
	private function toArray($key, $value, &$data = array()) {
		if (empty($key) && empty($value)) return array();
		if (strpos($key, self::ARRAY_SEP)) {
			$start = substr($key, 0, strpos($key, self::ARRAY_SEP));
			$end = substr($key, strpos($key, self::ARRAY_SEP) + 1);
			$data[$start] = array();
			$this->toArray($end, $value, $data[$start]);
		} else {
			$data[$key] = $value;
		}
		return $data;
	}

	/**
	 * ԭʼϲµ
	 * 
	 * @param array $original ԭʼ
	 * @param array $data ϲ
	 * @return array
	 */
	private function formatDataArray(&$original, &$data = array()) {
		foreach ((array) $original as $key => $value) {
			$tmp = $this->toArray($key, $value);
			foreach ($tmp as $tkey => $tValue) {
				if (is_array($tValue)) {
					if (!isset($data[$tkey])) {
						$data[$tkey] = array();
					}
					$this->formatDataArray($tValue, $data[$tkey]);
				} else {
					$data[$tkey] = $tValue;
				}
			}
		}
		return $data;
	}

	/**
	 * ַкϲ
	 * 
	 * @param string $key ϲļֵ
	 * @param  string $value ϲ
	 * @param array $data 
	 * @return array
	 */
	private function formatDataFromString($key, $value, &$data) {
		$tmp = $this->toArray($key, $value);
		if (false == strpos($key, self::ARRAY_SEP))  return $tmp;
		$start = substr($key, 0, strpos($key, self::ARRAY_SEP));
		if ((!isset($data[$start]) || !is_array($data[$start])) && isset($tmp[$start])) {
			$data[$start] = $tmp[$start];
			unset($data[$key]);
			return $data;
		}
		foreach ($data as $d_key => $d_value) {
			if (!isset($tmp[$d_key]) || !is_array($tmp[$d_key])) {
				continue;
			}
			foreach ($tmp[$d_key] as $a => $b) {
				$this->merge($a, $b, $data[$start]);
			}
		}
		unset($data[$key]);
		return $data;
	}

	/**
	 * ϲʽ
	 * 
	 * @param string $key ϲļֵ
	 * @param mixed $value ϲ
	 * @param array $data ϲ
	 * @return array
	 */
	private function merge($key, $value, &$data = array()) {
		if (!is_array($value)) {
			$data[$key] = $value;
			return $data;
		}
		
		$v_key = array_keys($value);
		$c_key = $v_key[0];
		if (is_array($value[$c_key])) {
			$this->merge($c_key, $value[$c_key], $data[$key]);
		} else {
			$data[$key][$c_key] = $value[$c_key];
		}
		return $data;
	}

	/**
	 * ȥַͷβַָ
	 * 
	 * @param string $str 
	 * @param mixed $char Ҫȡַ
	 * @return string 
	 */
	private function trimChar($str, $char = ' ') {
		$char = is_array($char) ? $char : array($char);
		foreach ($char as $value) {
			$str = trim($str, $value);
		}
		return $str;
	}
}