<?php
Wind::import("WIND:utility.WindConvert");
/**
 * xmlļ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindXmlParser.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package parser
 */
class WindXmlParser {
	
	/**
	 * @var string ڵ
	 */
	const NAME = 'name';
	
	/**
	 * @var Domdocument DOM
	 */
	private $dom = null;

	/**
	 * ʼxml
	 * 
	 * @param string $version xml汾
	 * @param string $encode  xml
	 * @return void
	 */
	public function __construct($version = '1.0', $encode = 'utf-8') {
		if (!class_exists('DOMDocument')) throw new WindException('[parser.WindXmlParser] DOMDocument is not exist.');
		$this->dom = new DOMDocument($version, $encode);
	}

	/**
	 * xmlļ
	 * 
	 * @param string $filename ļ
	 * @param int $option ѡ,ĬΪ0
	 * @return array
	 */
	public function parse($filename, $option = 0) {
		if (!is_file($filename)) return array();
		$this->dom->load($filename, $option);
		return $this->getChilds($this->dom->documentElement);
	}

    /**
     * ݽʽ
     *
     * @param string $stream 
	 * @param int $option ѡ,ĬΪ0
	 * @return array
     */
    public function parseXmlStream($stream, $option = 0) {
    	if (!$stream) return array();
		$this->dom->loadXML($stream, $option);
		return $this->getChilds($this->dom->documentElement);
    }
	
	/**
	 * תxmlʽ
	 * 
	 * <code>
	 * keyΪֵʱתΪ<item id=key>value</item>
	 * ͨstringͣתΪ<item>string</item>
	 * </code>
	 *
	 * @param mixed $source ת
	 * @param string $charset תݵı
	 * @return string
	 */
	public function parseToXml($source, $charset = 'utf8') {
		switch (gettype($source)) {
			case 'object':
				$source = get_object_vars($source);
			case 'array':
				$this->arrayToXml($source, $charset, $this->dom);
				break;
			case 'string':
				$source = WindConvert::convert($source, 'utf8', $charset);
			default:
				$item = $this->dom->createElement("item");
				$text = $this->dom->createTextNode($source);
				$item->appendChild($text);
				$this->dom->appendChild($item);
				break;
		}
		return $this->dom->saveXML();
	}

	/**
	 * ýڵӽڵ
	 * 
	 * ӽڵԺӽڵ㣨ıڵ),
	 * ӽڵԽΪýڵһԪشţӽڵкбǩбһκϲ
	 * ÿϲбΪһԪشڡ
	 * 
	 * @param DOMElement $node ҪXMLDOMڵ
	 * @return array ؽýڵ
	 */
	public function getChilds($node) {
		if (!$node instanceof DOMElement) return array();
		$childs = array();
		foreach ($node->childNodes as $_node) {
			$tempChilds = $attributes = array();
			$_node->hasAttributes() && $attributes = $this->getAttributes($_node);
			if (3 == $_node->nodeType) {
				$value = trim($_node->nodeValue);
				(is_numeric($value) || $value) && $childs['__value'] = $value; //ֵΪ0
				$__tmp = strtolower($value);
				('false' === $__tmp) && $childs['__value'] = false; //Ϊfalseֵ
				('true' === $__tmp) && $childs['__value'] = true; //Ϊfalseֵ
			}
			if (1 !== $_node->nodeType) continue;
			
			$tempChilds = $this->getChilds($_node);
			$tempChilds = array_merge($attributes, $tempChilds);
			
			if (empty($tempChilds))
				$tempChilds = '';
			else
				$tempChilds = (isset($tempChilds['__value']) && count($tempChilds) == 1) ? $tempChilds['__value'] : $tempChilds;
			
			$nodeName = "" !== ($name = $_node->getAttribute(self::NAME)) ? $name : $_node->nodeName;
			if (!isset($childs[$nodeName]))
				$childs[$nodeName] = $tempChilds;
			else {
				$element = $childs[$nodeName];
				$childs[$nodeName] = (is_array($element) && !is_numeric(implode('', array_keys($element)))) ? array_merge(
					array($element), array($tempChilds)) : array_merge((array) $element, array($tempChilds));
			}
		}
		return $childs;
	}

	/**
	 * ýڵ
	 * 
	 * ԽΪnameֵ--nameֵΪkeyֵڣ
	 * 
	 * @param DOMElement $node ڵ
	 * @return array 
	 */
	public function getAttributes($node) {
		if (!$node instanceof DOMElement || !$node->hasAttributes()) return array();
		$attributes = array();
		foreach ($node->attributes as $attribute) {
			if (self::NAME != $attribute->nodeName) {
				$value = (string) $attribute->nodeValue;
				$__tmp = strtolower($value);
				$attributes[$attribute->nodeName] = 'false' === $__tmp ? false : ('true' === $__tmp ? true : $value);
			}
		}
		return $attributes;
	}

	/**
	 * һתΪxml
	 *
	 * @param array $arr ת
	 * @param string $charset 
	 * @param DOMDocument $dom ڵ
	 * @return DOMDocument
	 */
	protected function arrayToXml($arr, $charset, $dom = null) {
		foreach ($arr as $key => $val) {
			if (is_numeric($key)) {
				$itemx = $this->dom->createElement("item");
				$id = $this->dom->createAttribute("id");
				$id->appendChild($this->dom->createTextNode($key));
				$itemx->appendChild($id);
			} else {
				$itemx = $this->dom->createElement($key);
			}
			$dom->appendChild($itemx);
			if (is_string($val)) {
				$val = WindConvert::convert($val, 'utf8', $charset);
				$itemx->appendChild($this->dom->createTextNode($val));
			} elseif (is_object($val)) {
				$this->arrayToXml(get_object_vars($val), $charset, $itemx);
			} else {
				$this->arrayToXml($val, $charset, $itemx);
			}
		}
	}

}