<?php
/**
 * ·ɽӿ
 * 
 * ְ: ·ɽ,Url.ʵ·ɽʵָýӿڵ{@see AbstractWindRouter::route()}.óֶ֧·Э鴦.
 * @author Qiong Wu <papa0924@gmail.com> 2011-9-23
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AbstractWindRouter.php 3928 2013-01-29 10:21:53Z yishuo $
 * @package router
 */
abstract class AbstractWindRouter extends WindHandlerInterceptorChain {
	protected $moduleKey = 'm';
	protected $controllerKey = 'c';
	protected $actionKey = 'a';
	protected $module;
	protected $controller;
	protected $action;
	protected $_action = 'run';
	protected $_controller = 'index';
	protected $_module = 'default';
	protected $defaultRoute = '';

	/**
	 * ·ɽ
	 * 
	 * @param WindHttpRequest $request
	 * @return string
	 */
	abstract public function route($request);

	/**
	 * Url,عõUrlֵ
	 * 
	 * @param string $action Ϣ
	 * @param array $args Ϣ
	 * @param string $route ·Э
	 * @return string
	 */
	abstract public function assemble($action, $args = array(), $route = '');
	
	/* (non-PHPdoc)
	 * @see WindModule::setConfig()
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		if ($this->_config) {
			$this->_module = $this->getConfig('module', 'default-value', $this->_module);
			$this->_controller = $this->getConfig('controller', 'default-value', $this->_controller);
			$this->_action = $this->getConfig('action', 'default-value', $this->_action);
			$this->moduleKey = $this->getConfig('module', 'url-param', $this->moduleKey);
			$this->controllerKey = $this->getConfig('controller', 'url-param', $this->controllerKey);
			$this->actionKey = $this->getConfig('action', 'url-param', $this->actionKey);
			foreach ($this->getConfig('routes', '', array()) as $routeName => $route) {
				if (!isset($route['class'])) continue;
				$instance = WindFactory::createInstance(Wind::import($route['class']));
				$instance->setConfig($route);
				$this->addRoute($routeName, $instance, (isset($route['default']) && $route['default'] === true));
			}
		}
	}

	/**
	 * ·ɽurlϢϵͳ
	 * 
	 * @param string $params
	 * @param WindHttpRequest $requeset
	 * @return void
	 */
	protected function setParams($params, $request) {
		foreach ($params as $key => $value) {
			if ($key === $this->actionKey) {
				$this->setAction($value);
			} elseif ($key === $this->controllerKey) {
				$this->setController($value);
			} elseif ($key === $this->moduleKey) {
				$this->setModule($value);
			} else {
				$_GET[$key] = $value;
			}
		}
	}

	/**
	 * ·Э,ӵ·ЭѾ׳쳣
	 * 
	 * @param string 
	 * @param AbstractWindRoute $route
	 * @param boolean $default ǷΪĬ
	 * @return void
	 */
	public function addRoute($alias, $route, $default = false) {
		$this->addInterceptors(array($alias => $route));
		if ($default) $this->defaultRoute = $alias;
	}

	/**
	 * ruleĹƣ·лø·ɵĶ
	 * 
	 * @param string $ruleName ·Э
	 * @return AbstractWindRoute
	 */
	public function getRoute($ruleName) {
		return isset($this->_interceptors[$ruleName]) ? $this->_interceptors[$ruleName] : null;
	}

	/**
	 * action
	 * 
	 * @return string
	 */
	public function getAction() {
		return $this->action;
	}

	/**
	 * controller
	 * 
	 * @return string
	 */
	public function getController() {
		return $this->controller;
	}

	/**
	 * action
	 * 
	 * @param string $action
	 * @return void
	 */
	public function setAction($action) {
		$this->action = $action;
	}

	/**
	 * controller
	 * 
	 * @param string $controller
	 * @return void
	 */
	public function setController($controller) {
		$this->controller = $controller;
	}

	/**
	 * @return string
	 */
	public function getModule() {
		return $this->module;
	}

	/**
	 * @param string
	 */
	public function setModule($module) {
		$this->module = $module;
	}

	/**
	 * @return string
	 */
	public function getModuleKey() {
		return $this->moduleKey;
	}

	/**
	 * @return string
	 */
	public function getControllerKey() {
		return $this->controllerKey;
	}

	/**
	 * @return string
	 */
	public function getActionKey() {
		return $this->actionKey;
	}

	/**
	 * @param string $moduleKey
	 */
	public function setModuleKey($moduleKey) {
		$this->moduleKey = $moduleKey;
	}

	/**
	 * @param string $controllerKey
	 */
	public function setControllerKey($controllerKey) {
		$this->controllerKey = $controllerKey;
	}

	/**
	 * @param string $actionKey
	 */
	public function setActionKey($actionKey) {
		$this->actionKey = $actionKey;
	}

	/**
	 * Ĭϵmoduleֵ
	 * 
	 * @return string
	 */
	public function getDefaultModule() {
		return $this->_module;
	}

	/**
	 * Ĭmodule
	 *
	 * @param string $module
	 */
	public function setDefaultModule($module) {
		$this->_module = $module;
	}

	/**
	 * Ĭϵcontrollerֵ
	 * 
	 * @return string
	 */
	public function getDefaultController() {
		return $this->_controller;
	}

	/**
	 * Ĭϵcontroller
	 *
	 * @param string $controller
	 */
	public function setDefaultController($controller) {
		$this->_controller = $controller;
	}

	/**
	 * Ĭϵactionֵ
	 * 
	 * @return string
	 */
	public function getDefaultAction() {
		return $this->_action;
	}

	/**
	 * Ĭϵactionֵ
	 *
	 * @param string $action
	 */
	public function setDefaultAction($action) {
		$this->_action = $action;
	}
}