<?php
Wind::import('WIND:router.route.AbstractWindRoute');
/**
 * rewriteͶ·Э
 *
 * ̳˳{@see AbstractWindRoute},ʵ{@see AbstractWindRoute::match()},
 * {@see AbstractWindRoute::build()}.
 * Ҫô·Э飬Ҫrewrite
 * Ĭ·ɹ<code>/^(\w+)(\/\w+)(\/\w+)(.*)$/i
 * 磺http://blog.p9.com/myModule/myController/myAction/id/1/name/2
 * Ϊmodule => myModule, controller => myController, action => myAction,
 * GETid => 1, name => 2
 * </code>
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindRewriteRoute.php 3677 2012-06-13 06:30:01Z yishuo $
 * @package router
 * @subpackage route
 */
class WindRewriteRoute extends AbstractWindRoute {
	protected $pattern = '/^(\w+)(\/\w+)(\/\w+)(.*)$/i';
	protected $reverse = '/%s/%s/%s';
	protected $separator = '//';
	protected $params = array('a' => 3, 'c' => 2, 'm' => 1);

	/**
	 * ·ɽ
	 *
	 * ƥpattenʱͼȥmodulecontrolleractionֵ
	 *
	 * @see AbstractWindRoute::match()
	 */
	public function match($request) {
		$_pathInfo = trim($request->getPathInfo(), '/');
		if (!$_pathInfo || !preg_match($this->pattern, $_pathInfo, $matches) || strpos($_pathInfo, 
			'.php') !== false) return null;
		$params = array();
		$_args = WindUrlHelper::urlToArgs($matches[4], true, $this->separator);
		
		// m,c,a
		foreach ($this->params as $k => $v) {
			if (isset($matches[$v])) $params[$k] = trim($matches[$v], '-/');
			unset($_args[$k]); // ȥеm,c,a
		}
		
		return $_args + $params;
	}

	/**
	 * ڴ·ЭĻװurl
	 *
	 * @param AbstractWindRouter $router        	
	 * @param string $action
	 *        	ʽΪapp/module/controller/action
	 * @param array $args
	 *        	Ĳ
	 * @return string
	 * @see AbstractWindRoute::build()
	 */
	public function build($router, $action, $args = array()) {
		list($_a, $_c, $_m, $_p, $args) = WindUrlHelper::resolveAction($action, $args);
		foreach ($this->params as $key => $val) {
			if ($key === $router->getModuleKey()) {
				$_m || $_m = $router->getModule();
				$_args[$val] = $_m;
			} elseif ($key === $router->getControllerKey()) {
				$_c || $_c = $router->getController();
				$_args[$val] = $_c;
			} elseif ($key === $router->getActionKey()) {
				$_a || $_a = $router->getAction();
				$_args[$val] = $_a;
			}
			unset($args[$key]);
		}
		$_args[0] = $this->reverse;
		ksort($_args);
		$url = call_user_func_array("sprintf", $_args);
		$args && $url .= '/' . WindUrlHelper::argsToUrl($args, true, $this->separator);
		
		return trim($url, '/');
	}
	
	/*
	 * (non-PHPdoc) @see AbstractWindRoute::setConfig()
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		$this->separator = $this->getConfig('separator', '', $this->separator);
	}
}

?>