<?php
Wind::import('WIND:utility.Security');
Wind::import('WIND:utility.WindFile');
/**
 * ļϴ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AbstractWindUpload.php 3172 2011-11-24 07:57:52Z yishuo $
 * @package upload
 */
abstract class AbstractWindUpload {
	
	/**
	 * Ƿд
	 * 
	 * @var boolean
	 */
	protected $hasError = false;
	
	/**
	 * Ϣ
	 * 
	 * @var array
	 */
	protected $errorInfo = array('type' => array(), 'size' => array(), 'upload' => array());
	
	/** 
	 * 
	 * 
	 * @var array
	 */
	protected $allowType = array();//ϴͼӦĴСarray(ext=>size);

	/**
	 * ϴļ
	 * 
	 * @param string $saveDir ļĿ¼
	 * @param string $preFileName ļǰ׺
	 * @param array  $allowType  ĸʽarray(ext=>size) sizeλΪb
	 * <code>
	 * array(
	 *  'jpg' => 1024,
	 *  'gif => 1000,
	 * </code> 
	 * @return array ϴɹļ
	 */
	public function upload($saveDir, $preFileName = '', $allowType = array()) {
		$this->setAllowType($allowType);
		$uploaddb = array();
		foreach ($_FILES as $key => $value) {
			if (is_array($value['name'])) {
				$temp = $this->multiUpload($key, $saveDir, $preFileName);
				$uploaddb[$key] = isset($uploaddb[$key]) ? array_merge((array)$uploaddb[$key], $temp) : $temp;
			} else {
				$uploaddb[$key][] = $this->simpleUpload($key, $saveDir, $preFileName);
			}
		}
		return 1 == count($uploaddb) ? array_shift($uploaddb) : $uploaddb;
	}
	
	/**
	 * ļϴ
	 * 
	 * ؼ
	 * һӵжϴļĿؼ
	 * 
	 * @param string $key ļkey
	 * @param string $saveDir ļĿ¼
	 * @param string $preFileName ļǰ׺ĬΪִ
	 * @return array ϴɹ֮ļϢ
	 */
	private function simpleUpload($key, $saveDir, $preFileName = '') {
		return $this->doUp($key, $_FILES[$key], $saveDir, $preFileName);
	}
	
	/**
	 * ļϴ
	 * 
	 * ؼ
	 * һӵжϴļĿؼ
	 * 
	 * @param string $key ļkey
	 * @param string $saveDir ļĿ¼
	 * @param string $preFileName ļǰ׺ĬΪִ
	 * @return array ϴɹ֮ļϢ
	 */
	private function multiUpload($key, $saveDir, $preFileName = '') {
		$uploaddb = array();
		$files = $_FILES[$key];
		$num = count($files['name']);
		for($i = 0; $i < $num; $i ++) {
			$one = array();
			$one['name'] = $files['name'][$i];
			$one['tmp_name'] = $files['tmp_name'][$i];
			$one['error'] = $files['error'][$i];
			$one['size'] = $files['size'][$i];
			$one['type'] = $files['type'][$i];
			if (!($upload = $this->doUp($key, $one, $saveDir, $preFileName))) continue;
			$uploaddb[] = $upload;
		}
		return $uploaddb;
	}
	
	/**
	 * ִϴ
	 * 
	 * @param string $tmp_name ʱļ
	 * @param string $filename Ŀļ
	 * @return bool 
	 */
	abstract protected function postUpload($tmp_name, $filename);
	
	/**
	 * Ƿд
	 * 
	 * @return boolean
	 */
	public function hasError() {
		return $this->hasError;
	}
	
	/**
	 * شϢ
	 * 
	 * @param string $errorType ,ѡΪ:
	 * <ul>
	 * <li>'type': ͳϴļϢ,</li>
	 * <li>'size': ָСϴʧܵļϢ<li>
	 * <li>'upload': ļϴִ̳ļϢ</li>
	 * </ul>ĬΪգ򷵻͵ĴϢ
	 * @return array
	 */
	public function getErrorInfo($errorType = '') {
		return isset($this->errorInfo[$errorType]) ? $this->errorInfo[$errorType] : $this->errorInfo;
	}
	
	/**
	 * ϴ
	 * 
	 * @param array $allowType ϴĸʽ
	 * @return void
	 */
	public function setAllowType($allowType) {
		$allowType && $this->allowType = $allowType;	
	}
	
	/**
	 * ļǷϴ
	 * 
	 * @param string $ext ļĺ׺
	 * @return bool ķΧ򷵻true򷵻false
	 */
	protected function checkAllowType($ext) {
		$allowType = array_keys((array)$this->allowType);
		return $allowType ? in_array($ext, $allowType) : true;
	}
	
	/**
	 * ϴļĴС
	 * 
	 * @param string $type ļ
	 * @param string $uploadSize ϴļĴС
	 * @return bool ϴļָϴĴС򷵻false,򷵻true
	 */
	protected function checkAllowSize($type, $uploadSize) {
		if ($uploadSize < 0) return false;
		if (!$this->allowType || !$this->allowType[$type]) return true;
		return $uploadSize < $this->allowType[$type];
	}
	

	/**
	 * ļ
	 * 
	 * @param array $attInfo ϴļϢ
	 * @param string $preFileName ļǰ׺
	 * @return string ϴļ
	 */
	protected function getFileName($attInfo, $preFileName = '') {
		$fileName = mt_rand(1, 10) . time() . substr(md5(time() . $attInfo['attname'] . mt_rand(1, 10)), 10, 15) . '.' . $attInfo['ext'];
		return $preFileName ? $preFileName . $fileName : $fileName;
	}

	/**
	 * ñ·
	 * 
	 * @param string $fileName ļ
	 * @param string $saveDir ļ·
	 * @return string ϴıļ·
	 */
	protected function getSavePath($fileName, $saveDir) {
		return $saveDir ? rtrim($saveDir, '\\/') . '/' . $fileName : $fileName;
	}
	
	/**
	 * жǷϴļ
	 * 
	 * @param string $tmp_name ʱϴļ
	 * @return boolean ļԱϴ򷵻true򷵻false
	 */
	protected function isUploadFile($tmp_name) {
		if (!$tmp_name || $tmp_name == 'none') {
			return false;
		} elseif (function_exists('is_uploaded_file') && !is_uploaded_file($tmp_name) && !is_uploaded_file(str_replace('\\\\', '\\', $tmp_name))) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	 * ʼϴļϢ
	 * 
	 * @param string $key ϴļkey
	 * @param string $value ϴļϢ
	 * @param string $preFileName ϴļǰ׺
	 * @param string $saveDir ϴļ·
	 * @return array ļϴϢ
	 */
	protected function initUploadInfo($key, $value, $preFileName, $saveDir) {
		$arr = array('attname' => $key, 'name' => $value['name'], 'size' => $value['size'], 'type' => $value['type'], 'ifthumb' => 0, 'fileuploadurl' => '');
		$arr['ext'] = strtolower(substr(strrchr($arr['name'], '.'), 1));
		$arr['filename'] = $this->getFileName($arr, $preFileName);
		$arr['fileuploadurl'] = $this->getSavePath($arr['filename'], $saveDir);
		return $arr;
	}
	
	
	/**
	 * жǷʹͼƬʹͼƬ򷵻
	 * 
	 * @param string $ext ļ׺
	 * @return boolean ļϴ򷵻true򷵻false
	 */
	protected function isImage($ext) {
		return in_array($ext, array('gif', 'jpg', 'jpeg', 'png', 'bmp', 'swf'));
	}
	
	/**
	 * ִϴ
	 * 
	 * @param string $key ϴļKeyֵ
	 * @param array $value ļϴϢ
	 * @param string $saveDir ϴļı·
	 * @param string $preFileName ϴļǰ׺
	 * @return array ϴɹļϢ
	 */
	protected function doUp($key, $value, $saveDir, $preFileName) {
		if (!$this->isUploadFile($value['tmp_name'])) return array();
		$upload = $this->initUploadInfo($key, $value, $preFileName, $saveDir);
		
		if (empty($upload['ext']) || !$this->checkAllowType($upload['ext'])) {
			$this->errorInfo['type'][$key][] = $upload;
			$this->hasError = true;
			return array();
		}
		if (!$this->checkAllowSize($upload['ext'], $upload['size'])) {
			$upload['maxSize'] = $this->allowType[$upload['ext']];
			$this->errorInfo['size'][$key][] = $upload;
			$this->hasError = true;
			return array();
		}
		if (!($uploadSize = $this->postUpload($value['tmp_name'], $upload['fileuploadurl']))) {
			$this->errorInfo['upload'][$key][] = $upload;
			$this->hasError = true;
			return array();
		}
		$upload['size'] = intval($uploadSize);
		return $upload;
	}
}