<?php
/**
 * cookie
 * 
 * ʹõʱȫþ̬ķʽʹøез:
 * <code>
 * Wind::import('WIND:http.cookie.WindCookie');
 * WindCookie::set('name', 'test');
 * </code>
 * 
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindCookie.php 3760 2012-10-11 08:02:25Z yishuo $
 * @package http
 * @subpackage cookie
 */
class WindCookie {

	/**
	 * cookie
	 * 
	 * @param string $name cookie
	 * @param string $value cookieֵ,ĬΪnull
	 * @param boolean $encode Ƿʹ MIME base64 ݽб,Ĭfalseб
	 * @param string|int $expires ʱ,ĬΪnullỰcookie,ŻỰ
	 * @param string $path cookie·,ĬΪnullĬ
	 * @param string $domain cookie,ĬΪnull
	 * @param boolean $secure Ƿȫ,ĬΪfalseðȫ
	 * @param boolean $httponly Ƿͨͻ˽ű,ĬΪfalseͻ˽űԷcookie
	 * @return boolean óɹtrue,ʧܷfalse
	 */
	public static function set($name, $value = null, $encode = false, $expires = null, $path = null, $domain = null, $secure = false, $httponly = false) {
		if (empty($name)) return false;
		$encode && $value && $value = base64_encode($value);
		$path = $path ? $path : '/';
		setcookie($name, $value, $expires, $path, $domain, $secure, $httponly);
		return true;
	}

	/**
	 * cookieɾcookie
	 * 
	 * @param string $name cookie
	 * @return boolean ɾɹtrue
	 */
	public static function delete($name) {
		if (self::exist($name)) {
			self::set($name, '');
			unset($_COOKIE[$name]);
		}
		return true;
	}

	/**
	 * ȡָƵcookieֵ
	 * 
	 * @param string $name cookie
	 * @param boolean $dencode Ƿcookieֵй,ĬΪfalseý
	 * @return mixed ȡɹرcookieֵ,ȡʧܽfalse
	 */
	public static function get($name, $dencode = false) {
		if (self::exist($name)) {
			$value = $_COOKIE[$name];
			$value && $dencode && $value = base64_decode($value);
			return $value ? $value : $value;
		}
		return false;
	}

	/**
	 * Ƴȫcookie
	 * 
	 * @return boolean Ƴɹtrue
	 */
	public static function deleteAll() {
		$_COOKIE = array();
		return true;
	}

	/**
	 * жcookieǷ
	 * 
	 * @param string $name cookie
	 * @return boolean 򷵻false,򷵻true
	 */
	public static function exist($name) {
		return isset($_COOKIE[$name]);
	}
}