<?php
/**
 * ڵĻ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindDate.php 2973 2011-10-15 19:22:48Z yishuo $
 * @package utility
 */
class WindDate {

	/**
	 * ȡʱ
	 * 
	 * @return string
	 */
	public static function getTimeZone() {
		return function_exists('date_default_timezone_get') ? date_default_timezone_get() : date('e');
	}

	/**
	 * ʱ
	 * 
	 * @param string $timezone ʱ
	 */
	public static function setTimezone($timezone) {
		function_exists('date_default_timezone_set') ? date_default_timezone_set($timezone) : putenv("TZ={$timezone}");
	}

	/**
	 * ʽ
	 * 
	 * @param string $format Ŀʽ,ĬΪnullY-m-d H:i:sʽ
	 * @param int $dateTime unixʱĬΪnullõǰʱ
	 * @return string
	 */
	public static function format($format = null, $dateTime = null) {
		return date($format ? $format : 'Y-m-d H:i:s', self::getTimeStamp($dateTime));
	}

	/**
	 * ȡڵĳ
	 * 
	 * @param string $interval ַʽ ,ʱ
	 * @param mixed $dateTime ʾڵ֣ĬΪnullõǰʱ
	 * @return string ڵĳ
	 */
	public static function datePart($interval, $dateTime = null) {
		return date($interval, self::getTimeStamp($dateTime));
	}

	/**
	 * ȡڵĲ
	 * 
	 * @param string $interval ڲļ
	 * @param mixed $startDateTime ʼ
	 * @param mixed $endDateTime   
	 * @return string 
	 */
	public static function dateDiff($interval, $startDateTime, $endDateTime) {
		$diff = self::getTimeStamp($endDateTime) - self::getTimeStamp($startDateTime);
		$retval = 0;
		switch ($interval) {
			case "y":
				$retval = bcdiv($diff, (60 * 60 * 24 * 365));
				break;
			case "m":
				$retval = bcdiv($diff, (60 * 60 * 24 * 30));
				break;
			case "w":
				$retval = bcdiv($diff, (60 * 60 * 24 * 7));
				break;
			case "d":
				$retval = bcdiv($diff, (60 * 60 * 24));
				break;
			case "h":
				$retval = bcdiv($diff, (60 * 60));
				break;
			case "n":
				$retval = bcdiv($diff, 60);
				break;
			case "s":
			default:
				$retval = $diff;
				break;
		}
		return $retval;
	}

	/**
	 * ָ׷ָ͵һʱ  
	 * 
	 * @param string $interval ַʽҪȥʱ͡
	 * @param int $value ֵʽҪϵʱĿֵΪõδڣҲΪõȥڣ 
	 * @param string $dateTime ʾڵ֣һڻʱ 
	 * @param mixed $format ʽ
	 * @return string ׷Ӻʱ
	 */
	public static function dateAdd($interval, $value, $dateTime, $format = null) {
		$date = getdate(self::getTimeStamp($dateTime));
		switch ($interval) {
			case "y":
				$date["year"] += $value;
				break;
			case "q":
				$date["mon"] += ($value * 3);
				break;
			case "m":
				$date["mon"] += $value;
				break;
			case "w":
				$date["mday"] += ($value * 7);
				break;
			case "d":
				$date["mday"] += $value;
				break;
			case "h":
				$date["hours"] += $value;
				break;
			case "n":
				$date["minutes"] += $value;
				break;
			case "s":
			default:
				$date["seconds"] += $value;
				break;
		}
		return self::format($format, mktime($date["hours"], $date["minutes"], $date["seconds"], $date["mon"], $date["mday"], $date["year"]));
	}

	/**
	 * õһÿʵ
	 * 
	 * @param string $year Ҫõ·
	 * @return array ÿµɵ
	 */
	public static function getRealDaysInMonthsOfYear($year) {
		$months = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
		if (self::isLeapYear($year)) {
			$months[1] = 29;
		}
		return $months;
	}

	/**
	 * ȡµ
	 * 
	 * @param int $month ·
	 * @param int $year 
	 * @return int
	 */
	public static function getDaysInMonth($month, $year) {
		if (1 > $month || 12 < $month) {
			return 0;
		}
		if (!($daysInmonths = self::getRealDaysInMonthsOfYear($year))) {
			return 0;
		}
		return $daysInmonths[$month - 1];
	}

	/**
	 * ȡ 
	 * 
	 * @return int 
	 */
	public static function getDaysInYear($year) {
		return self::isLeapYear($year) ? 366 : 365;
	}

	/**
	 * ȡRFCʽʱ
	 * 
	 * @param string $data Ҫȡʱ,ĬΪnullȡǰʱ
	 * @return string
	 */
	public static function getRFCDate($date = null) {
		$time = $date ? is_int($date) ? $date : strtotime($date) : time();
		$tz = date('Z', $time);
		$tzs = ($tz < 0) ? '-' : '+';
		$tz = abs($tz);
		$tz = (int) ($tz / 3600) * 100 + ($tz % 3600) / 60;
		return sprintf("%s %s%04d", date('D, j M Y H:i:s', $time), $tzs, $tz);
	}

	/**
	 * ȡйʱ
	 * 
	 * @param int $time Ҫʹõʱ,ĬΪnullȡǰʱ 
	 * @return string
	 */
	public static function getChinaDate($time = null) {
		list($y, $m, $d, $w, $h, $_h, $i) = explode(' ', date('Y n j w G g i', $time ? $time : time()));
		return sprintf('%s%s%s(%s) %s%s:%s', $y, $m, $d, self::getChinaWeek($w), self::getPeriodOfTime($h), $_h, $i);
	}

	/**
	 * ȡй
	 * 
	 * @param int $week ˵ڣһֵĬΪnullʹõǰʱ
	 * @return string
	 */
	public static function getChinaWeek($week = null) {
		$week = $week ? $week : (int) date('w', time());
		$weekMap = array("", "һ", "ڶ", "", "", "", "");
		return $weekMap[$week];
	}

	/**
	 * ȡһеʱ
	 * 
	 * @param int $hour СʱĬΪnullȡǰʱ
	 * @return string
	 */
	public static function getPeriodOfTime($hour = null) {
		$hour = $hour ? $hour : (int) date('G', time());
		$period = '';
		if (0 <= $hour && 6 > $hour) {
			$period = '賿';
		} elseif (6 <= $hour && 8 > $hour) {
			$period = '';
		} elseif (8 <= $hour && 11 > $hour) {
			$period = '';
		} elseif (11 <= $hour && 13 > $hour) {
			$period = '';
		} elseif (13 <= $hour && 15 > $hour) {
			$period = '';
		} elseif (15 <= $hour && 18 > $hour) {
			$period = '';
		} elseif (18 <= $hour && 20 > $hour) {
			$period = '';
		} elseif (20 <= $hour && 22 > $hour) {
			$period = '';
		} elseif (22 <= $hour && 23 >= $hour) {
			$period = 'ҹ';
		}
		return $period;
	}

	/**
	 * ȡUTCڸʽ
	 * 
	 * @param mixed $dateTime ʱ䣬ĬΪnullȡǰʱ
	 * @return string
	 */
	public static function getUTCDate($dateTime = null) {
		$oldTimezone = self::getTimezone();
		if ('UTC' !== strtoupper($oldTimezone)) {
			self::setTimezone('UTC');
		}
		$date = date('D, d M y H:i:s e', self::getTimeStamp($dateTime));
		if ('UTC' !== strtoupper($oldTimezone)) {
			self::setTimezone($oldTimezone);
		}
		return $date;
	}

	/**
	 * ȡ΢
	 * 
	 * @param string $mircrotime  ΢ʱ䣬ĬΪnullȡǰʱ
	 * @param string $get_as_float ȡ΢ʱǷԸ,ĬΪfalseԸʽ
	 * @return int
	 */
	public static function getMicroTime($mircrotime = null, $get_as_float = false) {
		return array_sum(explode(' ', $mircrotime ? $mircrotime : microtime($get_as_float)));
	}

	/**
	 * жǷ
	 * 
	 * @param int $year Ҫжϵ
	 * @return boolean 򷵻true
	 */
	public static function isLeapYear($year) {
		return (0 == $year % 4 && 0 != $year % 100 || 0 == $year % 400);
	}

	/**
	 * ʱ
	 *
	 * @param int $dateTime ʱ,ĬΪnullԵǰʱ
	 * @return int
	 */
	public static function getTimeStamp($dateTime = null) {
		return $dateTime ? is_int($dateTime) ? $dateTime : strtotime($dateTime) : time();
	}

	/**
	 * Ƚʱ䷵һʱ
	 * 
	 * @param int $time ǰʱ
	 * @param int $timestamp Ƚϵʱ,ĬΪnullȡǰʱ
	 * @param string $format ʽǰʱ,ĬΪnullתΪʽY-m-d H:i:s
	 * @param array $type ҪصʱͣĬΪ 1ֻY-m-d򷵻Y-m-d m-d H:i
	 * @return array
	 */
	public static function getLastDate($time, $timestamp = null, $format = null, $type = 1) {
		$timelang = array('second' => 'ǰ', 'yesterday' => '', 'hour' => 'Сʱǰ', 'minute' => 'ǰ', 'qiantian' => 'ǰ');
		$timestamp = $timestamp ? $timestamp : time();
		$compareTime = strtotime(self::format('Y-m-d', $timestamp));
		$currentTime = strtotime(self::format('Y-m-d', $time));
		$decrease = $timestamp - $time;
		$result = self::format($format, $time);
		if (0 >= $decrease) {
			return 1 == $type ? array(self::format('Y-m-d', $time), $result) : array(
				self::format('Y-m-d m-d H:i', $time), $result);
		}
		if ($currentTime == $compareTime) {
			if (1 == $type) {
				if (60 >= $decrease) {
					return array($decrease . $timelang['second'], $result);
				}
				return 3600 >= $decrease ? array(ceil($decrease / 60) . $timelang['minute'], $result) : array(
					ceil($decrease / 3600) . $timelang['hour'], $result);
			}
			return array(self::format('H:i', $time), $result);
		} elseif ($currentTime == $compareTime - 86400) {
			return 1 == $type ? array($timelang['yesterday'] . " " . self::format('H:i', $time), $result) : array(
				self::format('m-d H:i', $time), $result);
		} elseif ($currentTime == $compareTime - 172800) {
			return 1 == $type ? array($timelang['qiantian'] . " " . self::format('H:i', $time), $result) : array(
				self::format('m-d H:i', $time), $result);
		} elseif (strtotime(self::format('Y', $time)) == strtotime(self::format('Y', $timestamp))) {
			return 1 == $type ? array(self::format('m-d', $time), $result) : array(self::format('m-d H:i', $time), 
				$result);
		}
		return 1 == $type ? array(self::format('Y-m-d', $time), $result) : array(self::format('Y-m-d m-d H:i', $time), 
			$result);
	}
}