<?php
Wind::import("WIND:utility.WindString");
/**
 * ļ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindFile.php 3298 2012-01-06 12:48:26Z yishuo $
 * @package utility
 */
class WindFile {
	/**
	 * Զķʽļнǿƽֲ̨
	 * 
	 * @var string 
	 */
	const READ = 'rb';
	/**
	 * Զдķʽļнǿƽֲ̨
	 * 
	 * @var string 
	 */
	const READWRITE = 'rb+';
	/**
	 * дķʽļнǿƽֲ̨
	 * 
	 * @var string 
	 */
	const WRITE = 'wb';
	/**
	 * Զдķʽļнǿƽֲ̨
	 * 
	 * @var string 
	 */
	const WRITEREAD = 'wb+';
	/**
	 * ׷д뷽ʽļнǿƽֲ̨
	 * 
	 * @var string 
	 */
	const APPEND_WRITE = 'ab';
	/**
	 * ׷Ӷд뷽ʽļнǿƽֲ̨
	 * 
	 * @var string 
	 */
	const APPEND_WRITEREAD = 'ab+';
	
	/**
	 * ɾļ
	 * 
	 * @param string $filename ļ
	 * @return boolean
	 */
	public static function del($filename) {
		return @unlink($filename);
	}

	/**
	 * ļ
	 * 
	 * @param string $fileName          ļ
	 * @param mixed $data               
	 * @param boolean $isBuildReturn    Ƿװreturn $paramsĸʽûԱķʽ,ĬΪtruereturnķʽ
	 * @param string $method            ļʽĬΪrb+ʽ
	 * @param boolean $ifLock           ǷļĬΪtrue
	 */
	public static function savePhpData($fileName, $data, $isBuildReturn = true, $method = self::READWRITE, $ifLock = true) {
		$temp = "<?php\r\n ";
		if (!$isBuildReturn && is_array($data)) {
			foreach ($data as $key => $value) {
				if (!preg_match('/^\w+$/', $key)) continue;
				$temp .= "\$" . $key . " = " . WindString::varToString($value) . ";\r\n";
			}
			$temp .= "\r\n?>";
		} else {
			($isBuildReturn) && $temp .= " return ";
			$temp .= WindString::varToString($data) . ";\r\n?>";
		}
		return self::write($fileName, $temp, $method, $ifLock);
	}

	/**
	 * дļ
	 *
	 * @param string $fileName ļ·
	 * @param string $data 
	 * @param string $method дģʽ,ĬģʽΪrb+
	 * @param bool $ifLock ǷļĬΪtrue
	 * @param bool $ifCheckPath Ƿļеġ..ĬΪtrue
	 * @param bool $ifChmod ǷļԸΪɶд,ĬΪtrue
	 * @return int дֽ
	 */
	public static function write($fileName, $data, $method = self::READWRITE, $ifLock = true, $ifCheckPath = true, $ifChmod = true) {
		touch($fileName);
		if (!$handle = fopen($fileName, $method)) return false;
		$ifLock && flock($handle, LOCK_EX);
		$writeCheck = fwrite($handle, $data);
		$method == self::READWRITE && ftruncate($handle, strlen($data));
		fclose($handle);
		$ifChmod && chmod($fileName, 0777);
		return $writeCheck;
	}

	/**
	 * ȡļ
	 *
	 * @param string $fileName ļ·
	 * @param string $method ȡģʽĬģʽΪrb
	 * @return string ļжȡ
	 */
	public static function read($fileName, $method = self::READ) {
		$data = '';
		if (!$handle = fopen($fileName, $method)) return false;
		while (!feof($handle))
			$data .= fgets($handle, 4096);
		fclose($handle);
		return $data;
	}

	/**
	 * @param string $fileName
	 * @return boolean
	 */
	public static function isFile($fileName) {
		return $fileName ? is_file($fileName) : false;
	}

	/**
	 * ȡļϢ
	 * 
	 * @param string $fileName ļ
	 * @return array ļϢ
	 */
	public static function getInfo($fileName) {
		return self::isFile($fileName) ? stat($fileName) : array();
	}

	/**
	 * ȡļ׺
	 * 
	 * @param string $filename ļ
	 * @return string
	 */
	public static function getSuffix($filename) {
		if (false === ($rpos = strrpos($filename, '.'))) return '';
		return substr($filename, $rpos + 1);
	}
}