<?php
/**
 * ǽתΪһȥ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindGeneralDate.php 2973 2011-10-15 19:22:48Z yishuo $
 * @package utility
 */
class WindGeneralDate {

	/**
	 * չʾ
	 * 
	 * @var int 
	 */
	const FILL = 0;

	/**
	 * չʾ
	 * 
	 * @var int 
	 */
	const DIGIT = 1;

	/**
	 * ıչʾ
	 * 
	 * @var int 
	 */
	const TEXT = 2;

	/**
	 * Ĭϸʽ
	 * 
	 * @var string 
	 */
	const DEFAULT_FORMAT = 'Y-m-d H:i:s';

	/**
	 * unixʱ
	 * 
	 * @var int 
	 */
	private $time = 0;

	/**
	 * ڸʽתΪʱtimeʼ
	 * 
	 * mktimeֻһݵʱ򣬾ͻĬתΪһһ죬һ·ݲȱʡdayʱ
	 * תΪϸµһ졣Ҫע⡣
	 * ù캯ûвʱ򣬵õڲĵǰڣ11µ30
	 * 
	 * ·ΪգΪգȡǰ·ݣȡ1
	 * ΪգΪգȡǰڣȡ1
	 * СʱΪգΪգȡǰСʱ
	 * ΪգΪգȡǰ
	 * ΪգΪգȡǰ
	 * Ϊգȡǰ
	 * 
	 * @param int $year     ,ĬΪnullȡǰ
	 * @param int $month    ,ĬΪnullȡǰ
	 * @param int $day      ,ĬΪnullȡǰ
	 * @param int $hours    Сʱ,ĬΪnullȡǰСʱ
	 * @param int $minutes  ,ĬΪnullȡǰ
	 * @param int $second   ,ĬΪnullȡǰ
	 * @return void
	 */
	public function __construct($year = null, $month = null, $day = null, $hours = null, $minutes = null, $second = null) {
		$time = time();
		!$month && ((!$year) ? $month = date('m', $time) : $month = 1);
		!$day && ((!$year) ? $day = date('d', $time) : $day = 1);
		!$hours && !$year && $hours = date('H', $time);
		!$minutes && !$year && $minutes = date('i', $time);
		!$second && !$year && $second = date('s', $time);
		!$year && $year = date('Y', $time);
		$this->time = mktime($hours, $minutes, $second, $month, $day, $year);
	}

	/**
	 * ȡǰʱµ
	 * 
	 * @return string 
	 */
	public function getDaysInMonth() {
		return date('t', $this->time);
	}

	/**
	 * ȡǰʱ 
	 * 
	 * @return int 귵366򷵻365
	 */
	public function getDaysInYear() {
		return $this->isLeapYear() ? 366 : 365;
	}

	/**
	 * ʾǰǸеĵڼ졣
	 * 
	 * @return int ʱеĵڼ
	 */
	public function getDayOfYear() {
		return date('z', $this->time) + 1;
	}

	/**
	 * ʾǰΪеĵڼ졣 
	 * 
	 * @return int 
	 */
	public function getDayOfMonth() {
		return date('j', $this->time);
	}

	/**
	 * ʾǰǸеĵڼ졣
	 * 
	 * @return int 
	 */
	public function getDayOfWeek() {
		return date('w', $this->time) + 1;
	}

	/**
	 * жϵǰĵڼ 
	 * 
	 * @return int
	 */
	public function getWeekOfYear() {
		return date('W', $this->time);
	}

	/**
	 * ȡǰڵ
	 * 
	 * @param boolean $format Ƿ񷵻λʽݻλʽݣĬΪtrueYλ
	 * @return string
	 */
	public function getYear($format = true) {
		return date($format ? 'Y' : 'y', $this->time);
	}

	/**
	 * ǰڵȡ·
	 * 
	 * @param int $display ʾͣĬΪ0ʾλ·
	 * @return string
	 */
	public function getMonth($display = self::FILL) {
		if (self::FILL == $display) {
			return date('m', $this->time);
		} elseif (self::DIGIT == $display) {
			return date('n', $this->time);
		} elseif (self::TEXT == $display) {
			return date('M', $this->time);
		}
		return date('n', $this->time);
	}

	/**
	 * ȡǰڵ
	 * 
	 * @param string $display ʾͣĬΪ0ʾλ
	 * @return string 
	 */
	public function getDay($display = self::FILL) {
		if (self::FILL == $display) {
			return date('d', $this->time);
		} elseif (self::DIGIT == $display) {
			return date('j', $this->time);
		} elseif (self::TEXT == $display) {
			return date('jS', $this->time);
		}
		return date('j', $this->time);
	}

	/**
	 * ȡǰڵ
	 * 
	 * @param string $display ʾͣĬΪ0ֱʾеĵڼ
	 * @return string
	 */
	public function getWeek($display = self::FILL) {
		if (self::FILL == $display || self::DIGIT == $display) {
			return date('w', $this->time);
		} elseif (self::TEXT == $display) {
			return date('D', $this->time);
		}
		return date('N', $this->time);
	}

	/**
	 * ȡǰڵ12Сʱʱ
	 * 
	 * @param string $display ʾͣĬΪ0ʾλСʱ
	 * @return string
	 */
	public function get12Hours($display = self::FILL) {
		if (self::FILL == $display) {
			return date('h', $this->time);
		} elseif (self::DIGIT == $display) {
			return date('g', $this->time);
			;
		}
		return date('h', $this->time);
	}

	/**
	 * ȡǰڵ24Сʱʱ
	 * 
	 * @param string $display ʾͣĬΪ0ʾλСʱ
	 * @return string
	 */
	public function get24Hours($display = self::FILL) {
		if (self::FILL == $display) {
			return date('H', $this->time);
		} elseif (self::DIGIT == $display) {
			return date('G', $this->time);
			;
		}
		return date('H', $this->time);
	}

	/**
	 * ȡǰڵķ
	 * 
	 * @return string
	 */
	public function getMinutes() {
		return date('i', $this->time);
	}

	/**
	 * ȡǰڵ
	 * 
	 * @return string
	 */
	public function getSeconds() {
		return date('s', $this->time);
	}

	/**
	 * ȡǰڵıʱ
	 * 
	 * @return string
	 */
	public function getLocalTimeZone() {
		return date('T', $this->time);
	}

	/**
	 * õǰʱ
	 * 
	 * @param string  $time ʱ
	 * @return void  
	 */
	public function setTime($time) {
		if (is_int($time) || (is_string($time) && ($time = strtotime($time)))) {
			$this->time = $time;
		}
	}

	/**
	 * ȡõǰʱ
	 * 
	 * @return WindGeneralDate
	 */
	public function getNow() {
		$date = getdate($this->time);
		return new self($date["year"], $date["mon"], $date["mday"], $date["hours"], $date["minutes"], $date["seconds"]);
	}

	/**
	 * תΪַħ
	 * 
	 * @return string 
	 */
	public function __toString() {
		return $this->toString();
	}

	/**
	 * ʽʱ
	 * 
	 * @param string $format Ҫĸʽ,ĬΪnulløʽY-m-d H:i:s
	 * @return string 
	 */
	public function toString($format = null) {
		return date($format ? $format : self::DEFAULT_FORMAT, $this->time);
	}

	/**
	 * жǷ
	 * 
	 * @return int  10
	 */
	public function isLeapYear() {
		return date('L', $this->time);
	}
}