<?php
/**
 * ͼƬ
 * 
 * ͼƬѹͼƬˮӡ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindImage.php 2973 2011-10-15 19:22:48Z yishuo $
 * @package utility
 */
class WindImage {
	
	/**
	 * ͼ
	 * 
	 * @param string $srcFile     		ԴͼƬ
	 * @param string $dstFile     		ͼλ
	 * @param int $dstW           		ͼ
	 * @param string $dstH        		ͼ߶
	 * @param string $isProportion      ͼǷȱ,ĬΪfalse
	 * @return array|boolean
	 */
	public static function makeThumb($srcFile, $dstFile, $dstW, $dstH, $isProportion = FALSE) {
		if (false === ($minitemp = self::getThumbInfo($srcFile, $dstW, $dstH, $isProportion))) return false;
		list($imagecreate, $imagecopyre) = self::getImgcreate($minitemp['type']);
		if (!$imagecreate) return false;
		$imgwidth = $minitemp['width'];
		$imgheight = $minitemp['height'];
		
		$srcX = $srcY = $dstX = $dstY =0;
		if (!$isProportion) {
			$dsDivision = $imgheight / $imgwidth;
			$fixDivision = $dstH / $dstW;
			if ($dsDivision > $fixDivision) {
				$tmp = $imgwidth * $fixDivision;
				$srcY = round(($imgheight - $tmp) / 2);
				$imgheight = $tmp;
			} else {
				$tmp = $imgheight / $fixDivision;
				$srcX = round(($imgwidth - $tmp) / 2); 
				$imgwidth = $tmp;
			}
		}
		$thumb = $imagecreate($minitemp['dstW'], $minitemp['dstH']);
		
		if (function_exists('imagecolorallocate') && function_exists('imagecolortransparent')) {
			$black = imagecolorallocate($thumb, 0, 0, 0);
			imagecolortransparent($thumb, $black);
		}
		$imagecopyre($thumb, $minitemp['source'], $dstX, $dstY, $srcX, $srcY, $minitemp['dstW'], $minitemp['dstH'], $imgwidth, $imgheight);
		self::makeImg($minitemp['type'], $thumb, $dstFile);
		imagedestroy($thumb);
		return array('width' => $minitemp['dstW'], 'height' => $minitemp['dstH'], 'type' => $minitemp['type']);
	}

	/**
	 * ͼƬˮӡ
	 * 
	 * ˮӡλÿΪ
	 * <code>
	 * array(0 => 'λ', 1 => '', 2 => '', 3 => '', 4 => 'ײ', 5 => 'ײ', 6 => 'ײ', 7 => 'λ')
	 * </code>
	 * 
	 * @param string $source            ͼƬԴļ
	 * @param int|array $waterPos  		ˮӡλ,ѡ0-7ƶʼλx,y,ĬΪ0λ
	 * @param string $waterImg     		ΪˮӡͼƬ,ĬΪ
	 * @param string $waterText    		Ϊˮӡ,ĬΪ
	 * @param array  $attribute       	ˮӡԣֻˮӡЧ
	 * <code>
	 *   array(0 => 'ļ'1 => 'ϵͳ', 2 => 'ɫ' 3 => 'С')
	 * </code>
	 * @param string $waterPct     		ˮӡ͸ȣ01000ȫ͸100ȫ͸ĬΪ50
	 * @param string $waterQuality   	ͼƬ--jpegĬΪ75
	 * @param string $dstsrc  			ĿļλãĬΪnull
	 * @return boolean
	 */
	public static function makeWatermark($source, $waterPos = 0, $waterImg = '', $waterText = '', $attribute = '', $waterPct = 50, $waterQuality = 75, $dstsrc = null) {
		$sourcedb = $waterdb = array();
		if (false === ($sourcedb = self::getImgInfo($source))) return false;
		if (!$waterImg && !$waterText) return false;
		imagealphablending($sourcedb['source'], true);
		if ($waterImg) {
			$waterdb = self::getImgInfo($waterImg);
			list($wX, $wY) = self::getWaterPos($waterPos, $sourcedb, $waterdb, 1);
			if ($waterdb['type'] == 'png') {
				$tmp = imagecreatetruecolor($sourcedb['width'], $sourcedb['height']);
				imagecopy($tmp, $sourcedb['source'], 0, 0, 0, 0, $sourcedb['width'], $sourcedb['height']);
				imagecopy($tmp, $waterdb['source'], $wX, $wY, 0, 0, $waterdb['width'], $waterdb['height']);
				$sourcedb['source'] = $tmp;
			} else {
				imagecopymerge($sourcedb['source'], $waterdb['source'], $wX, $wY, 0, 0, $waterdb['width'], $waterdb['height'], $waterPct);
			}
		} elseif ($waterText) {
			list($fontFile, $charset, $color, $waterFont) = self::checkAttribute($attribute);
			empty($waterFont) && $waterFont = 12;
			$temp = imagettfbbox($waterFont, 0, $fontFile, $waterText); //ȡʹ TrueType ıķΧ
			$waterdb['width'] = $temp[2] - $temp[6];
			$waterdb['height'] = $temp[3] - $temp[7];
			unset($temp);
			list($wX, $wY) = self::getWaterPos($waterPos, $sourcedb, $waterdb, 2);
			if (strlen($color) != 7) return false;
			$R = hexdec(substr($color, 1, 2));
			$G = hexdec(substr($color, 3, 2));
			$B = hexdec(substr($color, 5));
			self::changeCharset($charset) && $waterText = mb_convert_encoding($waterText, 'UTF-8', $charset);
			imagettftext($sourcedb['source'], $waterFont, 0, $wX, $wY, imagecolorallocate($sourcedb['source'], $R, $G, $B), $fontFile, $waterText);
		}
		$dstsrc && $source = $dstsrc;
		self::makeImg($sourcedb['type'], $sourcedb['source'], $source, $waterQuality);
		isset($waterdb['source']) && imagedestroy($waterdb['source']);
		imagedestroy($sourcedb['source']);
		return true;
	}
	
	/**
	 * ˮӡù
	 * 
	 * Ϊ
	 * <code>
	 *   array(0 => 'ļ'1 => 'ϵͳ', 2 => 'ɫ' 3 => 'С')
	 * </code>
	 * @param array $attribute õ
	 * @return array
	 */
	private static function checkAttribute($attribute) {
		$attribute = is_string($attribute) ? array($attribute) : $attribute;
		if (!isset($attribute[1]) || !$attribute[1]) $attribute[1] = 'UTF-8';
		if (!isset($attribute[2]) || !$attribute[2]) $attribute[2] = '#FF0000';
		if (!isset($attribute[3]) || !$attribute[3]) $attribute[3] = 12;
		return $attribute;
	}
	
	/**
	 * жǷҪת
	 * 
	 * жΪʽΪutf-8
	 * 
	 * @param string $charset 뷽ʽ
	 * @return boolean
	 */
	private static function changeCharset($charset) {
		$charset = strtolower($charset);
	    return !in_array($charset, array('utf8', 'utf-8'));
	}
	
	/**
	 * ôˮӡλ
	 * 
	 * 飬ԪطֱΪˮӡĿx͸߶y
	 * 
	 * @param int|array $pos ˮӡλ
	 * @param array $sourcedb ԭͼƬϢ
	 * @param array $waterdb  ˮӡͼƬϢ
	 * @param int $markType  ˮӡͣ1ΪͼƬˮӡ2Ϊˮӡ
	 * @return array
	 */
	private static function getWaterPos($waterPos, $sourcedb, $waterdb, $markType) {
		if (is_array($waterPos)) return $waterPos;
		$wX = $wY = 0;
		switch (intval($waterPos)) {
			case 0 :
				$wX = rand(0, ($sourcedb['width'] - $waterdb['width']));
				$wY = $markType == 1 ? rand(0, ($sourcedb['height'] - $waterdb['height'])) : rand($waterdb['height'], $sourcedb['height']);	
				break;
			case 1 :
				$wX = 5;
				$wY = $markType == 1 ? 5 : $waterdb['height'];
				break;
			case 2:
				$wX = ($sourcedb['width'] - $waterdb['width']) / 2;
				$wY = $markType == 1 ? 5 : $waterdb['height'];
				break;
			case 3:
				$wX = $sourcedb['width'] - $waterdb['width'] - 5;
				$wY = $markType == 1 ? 5 : $waterdb['height'];
				break;
			case 4:
				$wX = 5;
				$wY = $markType == 1 ? $sourcedb['height'] - $waterdb['height'] - 5 : $sourcedb['height'] - 5;
				break;
			case 5:
				$wX = ($sourcedb['width'] - $waterdb['width']) / 2;
				$wY = $markType == 1 ? $sourcedb['height'] - $waterdb['height'] - 5 : $sourcedb['height'] - 5;
				break;
			case 6:
				$wX = $sourcedb['width'] - $waterdb['width'] - 5;
				$wY = $markType == 1 ? $sourcedb['height'] - $waterdb['height'] - 5 : $sourcedb['height'] - 5;
				break;
			default:
				$wX = ($sourcedb['width'] - $waterdb['width']) / 2;
				$wY = $markType == 1 ? ($sourcedb['height'] - $waterdb['height']) / 2 : ($sourcedb['height'] + $waterdb['height']) / 2;
				break;
		}
		return array($wX, $wY);
	}
	
	/**
	 * ͼϢ
	 * 
	 * @param string $srcFile			Դļ
	 * @param int $dstW					ĿļĿ
	 * @param int $dstH					Ŀļĸ߶
	 * @param boolean $isProportion		Ƿ񶨱
	 * @return array|boolean    
	 */
	private static function getThumbInfo($srcFile, $dstW, $dstH, $isProportion= FALSE) {
		if (false === ($imgdata = self::getImgInfo($srcFile))) return false;
		if ($imgdata['width'] <= $dstW && $imgdata['height'] <= $dstH) return false;
	
		$imgdata['dstW'] = $dstW;
		$imgdata['dstH'] = $dstH;
		if (empty($dstW) && $dstH > 0 && $imgdata['height'] > $dstH) {
			$imgdata['dstW'] = !$isProportion ? $dstH : round($dstH / $imgdata['height'] * $imgdata['width']);
		} elseif (empty($dstH) && $dstW > 0 && $imgdata['width'] > $dstW) {
			$imgdata['dstH'] = !$isProportion ? $dstW : round($dstW / $imgdata['width'] * $imgdata['height']);
		} elseif ($dstW > 0 && $dstH > 0) {
			if (($imgdata['width'] / $dstW) < ($imgdata['height'] / $dstH)) {
				$imgdata['dstW'] = !$isProportion ? $dstW : round($dstH / $imgdata['height'] * $imgdata['width']);
			}
			if (($imgdata['width'] / $dstW) > ($imgdata['height'] / $dstH)) {
				$imgdata['dstH'] = !$isProportion ? $dstH : round($dstW / $imgdata['width'] * $imgdata['height']);
			}
		} else {
			$imgdata = false;
		}
		return $imgdata;
	}
	
	/**
	 * ͼƬϢ,ͼƬԴͼƬĸ߶ȺͿ
	 * 
	 * @param string $srcFile	ͼַ
	 * @return array|boolean
	 */
	public static function getImgInfo($srcFile) {
		if (false === ($imgdata = self::getImgSize($srcFile))) return false;
		$imgdata['type'] = self::getTypes($imgdata['type']);
		if (empty($imgdata) || !function_exists('imagecreatefrom' . $imgdata['type'])) return false;
		$imagecreatefromtype = 'imagecreatefrom' . $imgdata['type'];
		$imgdata['source'] = $imagecreatefromtype($srcFile);
		!$imgdata['width'] && $imgdata['width'] = imagesx($imgdata['source']);
		!$imgdata['height'] && $imgdata['height'] = imagesy($imgdata['source']);
		return $imgdata;
	}
	
	/**
	 * ͼƬͼ
	 * 
	 * <pre>
	 * ͼƬtype
	 * 1 = GIF2 = JPG3 = PNG4 = SWF5 = PSD6 = BMP7 = TIFF(intel byte order)8 = TIFF(motorola byte order)9 = JPC10 = JP2
	 * 11 = JPX12 = JB213 = SWC14 = IFF15 = WBMP16 = XBM
	 * </pre>
	 * 
	 * @param string $srcFile	ͼַ
	 * @param string $srcExt	ͼ׺ĬΪnull򽫻ͼƬַзȡ
	 * @return array|boolean	ͼͼ߶ȺͿ
	 */
	private static function getImgSize($srcFile, $srcExt = null) {
		empty($srcExt) && $srcExt = strtolower(substr(strrchr($srcFile, '.'), 1));
		$srcdata = array();
		$exts = array('jpg', 'jpeg', 'jpe', 'jfif');
		in_array($srcExt, $exts) &&  $srcdata['type'] = 2;
		if (false === ($info = getimagesize($srcFile))) return false;
		list($srcdata['width'], $srcdata['height'], $srcdata['type']) = $info;
		if (!$srcdata['type'] || ($srcdata['type'] == 1 && in_array($srcExt, $exts)))  return false;
		return $srcdata;
	}
	
	/**
	 * ôͼķ
	 * 
	 * @param string $imagetype		ͼƬ
	 * @return array
	 */
	private static function getImgcreate($imagetype) {
		if ($imagetype != 'gif' && function_exists('imagecreatetruecolor') && function_exists('imagecopyresampled')) {
			return array('imagecreatetruecolor', 'imagecopyresampled');
		}
		if (function_exists('imagecreate') && function_exists('imagecopyresized')) {
			return array('imagecreate', 'imagecopyresized');
		}
		return array('', '');
	}
	
	/**
	 * ͼ
	 * 
	 * @param string $type		ͼ
	 * @param resource $image	ͼԴ
	 * @param string $filename	ͼ񱣴
	 * @param int $quality 		jpegʱõĬΪ75
	 * @return boolean
	 */
	private static function makeImg($type, $image, $filename, $quality = '75') {
		$makeimage = 'image' . $type;
		if (!function_exists($makeimage)) return false;
		if ($type == 'jpeg') {
			$makeimage($image, $filename, $quality);
		} else {
			$makeimage($image, $filename);
		}
		return true;
	}
	
	/**
	 * ͼƬĶӦ
	 * 
	 * @param int $id	ͼƬID
	 * @return string
	 */
	private static function getTypes($id) {
		$imageTypes = array(1 => 'gif', 2 => 'jpeg', '3' => 'png', 6 => 'bmp');
		return isset($imageTypes[$id]) ? $imageTypes[$id] : '';
	}
}