<?php
Wind::import('WIND:utility.WindFile');
/**
 * 
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindPack.php 3647 2012-06-08 04:14:06Z yishuo $
 * @package utility
 */
class WindPack {
	
	/**
	 * ʹ
	 * 
	 * @var string 
	 */
	const STRIP_SELF = 'stripWhiteSpaceBySelf';
	
	/**
	 * phpĺ
	 * 
	 * @var string 
	 */
	const STRIP_PHP = 'stripWhiteSpaceByPhp';
	
	/**
	 * ͨtokenʽ
	 * 
	 * @var string 
	 */
	const STRIP_TOKEN = 'stripWhiteSpaceByToken';
	private $packList = array();
	private $contentInjectionPosition;
	private $contentInjectionCallBack = '';

	/**
	 * ļбд
	 * 
	 * @param mixed $fileList ļб
	 * @param string $dst  ļĴλ
	 * @param method $packMethod ķʽĬΪstripWhiteSpaceByPhp
	 * @param boolean $compress ǷѹķʽĬΪtrue
	 * @return boolean
	 */
	public function packFromFileList($fileList, $dst, $packMethod = WindPack::STRIP_PHP, $compress = true) {
		if (empty($dst) || empty($fileList)) return false;
		$content = array();
		$this->readContentFromFileList($fileList, $packMethod, $content);
		$replace = $compress ? ' ' : "\n";
		$content = implode($replace, $content);
		$content = $this->callBack($content, $replace);
		$content = $this->stripNR($content, $replace);
		$content = $this->stripPhpIdentify($content, '');
		return WindFile::write($dst, '<?php' . $replace . $content . '?>');
	}

	/**
	 * ͨphpʽȥָļעͼհ
	 * 
	 * @param string $filename ļ
	 * @return string
	 */
	public function stripWhiteSpaceByPhp($filename) {
		return php_strip_whitespace($filename);
	}

	/**
	 * ͨʽȥָļעͼհ
	 * 
	 * @param string $filename ļ
	 * @param boolean $compress ǷѹĬΪtrue
	 * @return string
	 */
	public function stripWhiteSpaceBySelf($filename, $compress = true) {
		$content = $this->getContentFromFile($filename);
		$content = $this->stripComment($content, '');
		return $this->stripSpace($content, ' ');
	}

	/**
	 * ͨtokenʽȥָļעͼհ
	 * 
	 * @param string $filename ļ
	 * @return string
	 */
	public function stripWhiteSpaceByToken($filename) {
		$content = $this->getContentFromFile($filename);
		$compressContent = '';
		$lastToken = 0;
		foreach (token_get_all($content) as $key => $token) {
			if (is_array($token)) {
				if (in_array($token[0], array(T_COMMENT, T_WHITESPACE, T_DOC_COMMENT))) {
					continue;
				}
				$compressContent .= ' ' . $token[1];
			} else {
				$compressContent .= $token;
			}
			$lastToken = $token[0];
		}
		return $compressContent;
	}

	/**
	 * ļбȡöӦÿļ 
	 * 
	 * @param mixed $fileList ļб
	 * @param method $packMethod  ʽĬΪstripWhiteSpaceByPhp
	 * @param array $content ļݣĬΪ
	 * @return array:
	 */
	public function readContentFromFileList(array $fileList, $packMethod = WindPack::STRIP_PHP, &$content = array()) {
		if (empty($fileList) || false === $this->isValidatePackMethod($packMethod)) return array();
		
		foreach ($fileList as $key => $value) {
			$parents = class_parents($key);
			$_fileList = $this->buildFileList($parents, $fileList);
			$this->readContentFromFileList($_fileList, $packMethod, $content);
			$implements = class_implements($key);
			$_fileList = $this->buildFileList($implements, $fileList);
			$this->readContentFromFileList($_fileList, $packMethod, $content);
			if (in_array($key, $this->packList)) continue;
			if (is_file($value)) {
				$content[] = $this->$packMethod($value);
				$this->packList[] = $key;
			}
		}
	}

	/**
	 * ȥע
	 * 
	 * @param string $content Ҫȥ
	 * @param mixed $replace Ҫ滻ı
	 * @return string
	 */
	public function stripComment($content, $replace = '') {
		return preg_replace('/(?:\/\*.*\*\/)*|(?:\/\/[^\r\n]*[\r\n])*/Us', $replace, $content);
	}

	/**
	 * ȥ
	 * 
	 * @param string $content Ҫȥ
	 * @param mixed $replace Ҫ滻ı
	 * @return string
	 */
	public function stripNR($content, $replace = array('\n','\r\n','\r')) {
		return preg_replace('/[\n\r]+/', $replace, $content);
	}

	/**
	 * ȥո
	 * 
	 * @param string $content Ҫȥ
	 * @param mixed $replace Ҫ滻ı,ĬΪ 
	 * @return string
	 */
	public function stripSpace($content, $replace = ' ') {
		return preg_replace('/[ ]+/', $replace, $content);
	}

	/**
	 * ȥphpʶ
	 * 
	 * @param string $content Ҫ
	 * @param mixed $replace phpʶ滻ΪֵĬΪ
	 * @return string
	 */
	public function stripPhpIdentify($content, $replace = '') {
		return preg_replace('/(?:<\?(?:php)*)|(\?>)/i', $replace, $content);
	}

	/**
	 * ָ滻ָӦ
	 * 
	 * @param string $content Ҫ
	 * @param string $rule    Ҫƥ
	 * @param $mixed $replace 滻ƥĽĬΪ
	 * @return string
	 */
	public function stripStrByRule($content, $rule, $replace = '') {
		return preg_replace("/$rule/", $replace, $content);
	}

	/**
	 * ȥļϢ
	 * 
	 * @param string $content Ҫ
	 * @param mixed $replace 滻ƥĽĬΪ
	 * @return string
	 */
	public function stripImport($content, $replace = '') {
		$str = preg_match_all('/L[\t ]*::[\t ]*import[\t ]*\([\t ]*[\'\"]([^$][\w\.:]+)[\"\'][\t ]*\)[\t ]*/', $content, 
			$matchs);
		if ($matchs[1]) {
			foreach ($matchs[1] as $key => $value) {
				$name = substr($value, strrpos($value, '.') + 1);
				if (preg_match("/(abstract[\t ]*|class|interface)[\t ]+$name/i", $content)) {
					$strip = str_replace(array('(', ')'), array('\(', '\)'), addslashes($matchs[0][$key])) . '[\t ]*;';
					$content = $this->stripStrByRule($content, $strip, $replace);
				}
			}
		}
		return $content;
	}

	/**
	 * ļȡ
	 *
	 * @param string $filename ļ
	 * @return string ļһЧļ򷵻false
	 */
	public function getContentFromFile($filename) {
		if (is_file($filename)) {
			$content = '';
			$fp = fopen($filename, "r");
			while (!feof($fp)) {
				$line = fgets($fp);
				if (in_array(strlen($line), array(2, 3)) && in_array(ord($line), array(9, 10, 13))) continue;
				$content .= $line;
			}
			fclose($fp);
			return $content;
		}
		return false;
	}

	/**
	 * ļб
	 *
	 * @param array $list     Ҫļб
	 * @param array $fileList ļб
	 * @return array $listд$fileListеļб
	 */
	private function buildFileList(array $list, $fileList) {
		$_temp = array();
		foreach ($list as $fileName) {
			foreach ($fileList as $key => $value) {
				if ($key == $fileName) {
					$_temp[$key] = $value;
					break;
				}
			}
		}
		return $_temp;
	}

	/**
	 * ûص
	 * 
	 * @author Qiong Wu
	 * @param array $contentInjectionCallBack ص
	 * @param string $position λ(before|after)ĬΪbefore
	 * @return void
	 */
	public function setContentInjectionCallBack($contentInjectionCallBack, $position = 'before') {
		if (!in_array($position, array('before', 'after'))) $position = 'before';
		$this->contentInjectionPosition = $position;
		$this->contentInjectionCallBack = $contentInjectionCallBack;
	}

	/**
	 * ص
	 * 
	 * @param string $content ص
	 * @param string $replace 滻ݣĬΪ
	 * @return string
	 */
	public function callBack($content, $replace = '') {
		if ($this->contentInjectionCallBack !== '') {
			$_content = call_user_func_array($this->contentInjectionCallBack, array($this->packList));
			if ($this->contentInjectionPosition == 'before') {
				$content = $replace . $_content . $content;
			} elseif ($this->contentInjectionPosition == 'after') {
				$content .= $replace . $_content . $replace;
			}
		}
		return $content;
	}

	/**
	 * Ч
	 *
	 * @param string $packMethod ķ
	 * @return boolean
	 */
	private function isValidatePackMethod($packMethod) {
		return method_exists($this, $packMethod) && in_array($packMethod, 
			array(WindPack::STRIP_PHP, WindPack::STRIP_SELF, WindPack::STRIP_TOKEN));
	}
}