<?php
Wind::import('WIND:utility.WindJson');

/**
 * ַ·˵Ȱȫ
 *
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindSecurity.php 3939 2013-05-29 06:22:57Z xiaoxia.xuxx $
 * @package utility
 */
class WindSecurity {

	/**
	 * jsonҳ
	 * ת
	 *
	 * @param mixed $source
	 * @param string $charset
	 * @return string
	 */
	public static function escapeEncodeJson($source, $charset = 'utf-8') {
		return WindJson::encode(is_string($source) ? self::escapeHTML($source) : self::escapeArrayHTML($source), $charset);
	}

	/**
	 * תַ
	 * 
	 * @param string $str תַ
	 * @return string
	 */
	public static function escapeHTML($str, $charset = 'ISO-8859-1') {
		if (!is_string($str)) return $str;
		return htmlspecialchars($str, ENT_QUOTES, $charset);
	}

	/**
	 * תַ
	 * 
	 * @param array $array תƵ
	 * @return array
	 */
	public static function escapeArrayHTML($array) {
		if (!is_array($array)) return self::escapeHTML($array);
		$_tmp = array();
		foreach ($array as $key => $value) {
			is_string($key) && $key = self::escapeHTML($key);
			$_tmp[$key] = is_array($value) ? self::escapeArrayHTML($value) : self::escapeHTML($value);
		}
		return $_tmp;
	}

	/**
	 * ַ
	 * 
	 * @param string $str Ҫַܵ
	 * @param string $key Կ
	 * @return string ܺĽ
	 */
	public static function encrypt($str, $key, $iv = '') {
		if (!$key || !is_string($key)) throw new WindException(
			'[utility.WindSecurity.encrypt] security key is required. ', WindException::ERROR_PARAMETER_TYPE_ERROR);
		if (!$str || !is_string($str)) throw new WindException(
			'[utility.WindSecurity.encrypt] security string is required.', WindException::ERROR_PARAMETER_TYPE_ERROR);
		
		$size = mcrypt_get_block_size(MCRYPT_DES, MCRYPT_MODE_CBC);
		$iv = substr(md5($iv ? $iv : $key), -$size);
		$pad = $size - (strlen($str) % $size);
		$str .= str_repeat(chr($pad), $pad);
		@$data = mcrypt_cbc(MCRYPT_DES, $key, $str, MCRYPT_ENCRYPT, $iv);
		return base64_encode($data);
	}

	/**
	 * ַ
	 * 
	 * @param string $str ַܵ
	 * @param string $key Կ
	 * @return string ܺĽ
	 */
	public static function decrypt($str, $key, $iv = '') {
		if (!$str || !is_string($str)) throw new WindException(
			'[utility.WindSecurity.decrypt] security string is required.', WindException::ERROR_PARAMETER_TYPE_ERROR);
		if (!$key || !is_string($key)) throw new WindException(
			'[utility.WindSecurity.decrypt] security key is required.', WindException::ERROR_PARAMETER_TYPE_ERROR);
		
		$size = mcrypt_get_block_size(MCRYPT_DES, MCRYPT_MODE_CBC);
		$iv = substr(md5($iv ? $iv : $key), -$size);
		$str = base64_decode($str);
		@$str = mcrypt_cbc(MCRYPT_DES, $key, $str, MCRYPT_DECRYPT, $iv);
		$pad = ord($str{strlen($str) - 1});
		if ($pad > strlen($str)) return false;
		if (strspn($str, chr($pad), strlen($str) - $pad) != $pad) return false;
		return substr($str, 0, -1 * $pad);
	}

	/**
	 * tokenƴ
	 * tokenƴ,ڱظύ.
	 * ʹõǰsessionIDԼǰʱ,Ψһһƴ,.
	 * 
	 * @deprecated
	 *
	 * @return string
	 */
	public static function createToken() {
		return self::generateGUID();
	}

	/**
	 * ȡΨһʶ,ʶĳΪ16ֽ,128λ.
	 * ݵǰʱsessionID,һΨһĴ.
	 * 
	 * @return string GUID,16ֽ
	 */
	public static function generateGUID() {
		return substr(md5(WindUtility::generateRandStr(8) . microtime()), -16);
	}

	/**
	 * ·ת
	 * 
	 * @param string $fileName ·
	 * @param boolean $ifCheck ǷҪļĬΪfalse
	 * @return string
	 */
	public static function escapePath($filePath, $ifCheck = false) {
		$_tmp = array("'" => '', '#' => '', '=' => '', '`' => '', '$' => '', '%' => '', '&' => '', ';' => '');
		$_tmp['://'] = $_tmp["\0"] = '';
		$ifCheck && $_tmp['..'] = '';
		if (strtr($filePath, $_tmp) == $filePath) return preg_replace('/[\/\\\]{1,}/i', '/', $filePath);
		throw new WindException('[utility.WindSecurity.escapePath] file path is illegal');
	}
}