<?php
/**
 * ַʽ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindString.php 3760 2012-10-11 08:02:25Z yishuo $
 * @package utility
 */
class WindString {
	const UTF8 = 'utf-8';
	const GBK = 'gbk';

	/**
	 * ȡַ,ַ֧,ĬΪutf-8
	 * 
	 * @param string $string Ҫȡַ
	 * @param int $start     ʼȡ
	 * @param int $length    ȡĳ
	 * @param string $charset ԭ,ĬΪUTF8
	 * @param boolean $dot    ǷʾʡԺ,ĬΪfalse
	 * @return string ȡִ
	 */
	public static function substr($string, $start, $length, $charset = self::UTF8, $dot = false) {
		switch (strtolower($charset)) {
			case self::GBK:
				$string = self::substrForGbk($string, $start, $length, $dot);
				break;
			case self::UTF8:
				$string = self::substrForUtf8($string, $start, $length, $dot);
				break;
			default:
				$string = substr($string, $start, $length);
		}
		return $string;
	}

	/**
	 * ȡַ
	 * 
	 * @param string $string  Ҫַ
	 * @param string $charset ԭʼ,ĬΪUTF8
	 * @return int
	 */
	public static function strlen($string, $charset = self::UTF8) {
		switch (strtolower($charset)) {
			case self::GBK:
				$count = self::strlenForGbk($string);
				break;
			case self::UTF8:
				$count = self::strlenForUtf8($string);
				break;
			default:
				$count = strlen($string);
		}
		return $count;
	}

	/**
	 * ֵתΪַ
	 *
	 * @param mixed $input   
	 * @param string $indent ,ĬΪ''
	 * @return string
	 */
	public static function varToString($input, $indent = '') {
		switch (gettype($input)) {
			case 'string':
				return "'" . str_replace(array("\\", "'"), array("\\\\", "\\'"), $input) . "'";
			case 'array':
				$output = "array(\r\n";
				foreach ($input as $key => $value) {
					$output .= $indent . "\t" . self::varToString($key, $indent . "\t") . ' => ' . self::varToString(
						$value, $indent . "\t");
					$output .= ",\r\n";
				}
				$output .= $indent . ')';
				return $output;
			case 'boolean':
				return $input ? 'true' : 'false';
			case 'NULL':
				return 'NULL';
			case 'integer':
			case 'double':
			case 'float':
				return "'" . (string) $input . "'";
		}
		return 'NULL';
	}

	/**
	 * json
	 *
	 * @param mixed $value Ҫܵ
	 * @param string $charset ַ
	 * @return string ܺ
	 */
	public static function jsonEncode($value, $charset = self::UTF8) {
		Wind::import('Wind:utility.WindJson');
		return WindJson::encode($value, $charset);
	}

	/**
	 * jsonʽݽ
	 *
	 * @param string $value ܵ
	 * @param string $charset ַܺ
	 * @return mixed ܺ
	 */
	public static function jsonDecode($value, $charset = self::UTF8) {
		Wind::import('Wind:utility.WindJson');
		return WindJson::decode($value, true, $charset);
	}

	/**
	 * utf8ʽȡַ
	 * 
	 * @param string $string  Ҫȡַ
	 * @param int $start      ʼȡ
	 * @param int $length     ȡĳȣĬΪnullȡַȫ
	 * @param boolean $dot    ǷʾʡԺţĬΪfalse
	 * @return string
	 */
	public static function substrForUtf8($string, $start, $length = null, $dot = false) {
		$l = strlen($string);
		$p = $s = 0;
		if (0 !== $start) {
			while ($start-- && $p < $l) {
				$c = $string[$p];
				if ($c < "\xC0")
					$p++;
				elseif ($c < "\xE0")
					$p += 2;
				elseif ($c < "\xF0")
					$p += 3;
				elseif ($c < "\xF8")
					$p += 4;
				elseif ($c < "\xFC")
					$p += 5;
				else
					$p += 6;
			}
			$s = $p;
		}
		
		if (empty($length)) {
			$t = substr($string, $s);
		} else {
			$i = $length;
			while ($i-- && $p < $l) {
				$c = $string[$p];
				if ($c < "\xC0")
					$p++;
				elseif ($c < "\xE0")
					$p += 2;
				elseif ($c < "\xF0")
					$p += 3;
				elseif ($c < "\xF8")
					$p += 4;
				elseif ($c < "\xFC")
					$p += 5;
				else
					$p += 6;
			}
			$t = substr($string, $s, $p - $s);
		}
		
		$dot && ($p < $l) && $t .= "...";
		return $t;
	}

	/**
	 * gbkʽȡַ
	 * 
	 * @param string $string  Ҫȡַ
	 * @param int $start      ʼȡ
	 * @param int $length     ȡĳȣĬΪnullȡַȫ
	 * @param boolean $dot    ǷʾʡԺţĬΪfalse
	 * @return string
	 */
	public static function substrForGbk($string, $start, $length = null, $dot = false) {
		$l = strlen($string);
		$p = $s = 0;
		if (0 !== $start) {
			while ($start-- && $p < $l) {
				if ($string[$p] > "\x80")
					$p += 2;
				else
					$p++;
			}
			$s = $p;
		}
		
		if (empty($length)) {
			$t = substr($string, $s);
		} else {
			$i = $length;
			while ($i-- && $p < $l) {
				if ($string[$p] > "\x80")
					$p += 2;
				else
					$p++;
			}
			$t = substr($string, $s, $p - $s);
		}
		
		$dot && ($p < $l) && $t .= "...";
		return $t;
	}

	/**
	 * utf8ȡַ
	 * 
	 * @param string $string     Ҫַ
	 * @return int
	 */
	public static function strlenForUtf8($string) {
		$l = strlen($string);
		$p = $c = 0;
		while ($p < $l) {
			$a = $string[$p];
			if ($a < "\xC0")
				$p++;
			elseif ($a < "\xE0")
				$p += 2;
			elseif ($a < "\xF0")
				$p += 3;
			elseif ($a < "\xF8")
				$p += 4;
			elseif ($a < "\xFC")
				$p += 5;
			else
				$p += 6;
			$c++;
		}
		return $c;
	}

	/**
	 * gbkȡַ
	 * 
	 * @param string $string     Ҫַ
	 * @return int
	 */
	public static function strlenForGbk($string) {
    $l = strlen($string);
    $p = $c = 0;
    while ($p < $l) {
        if ($string[$p] > "\x80"){
            $p += 2;
            $c += 2; //add by phpwind.net.cn 2014.04.28 For GBK char strlen
        }else{
            $p++;
            $c++;
        }
    }
    return $c ;
}
}