<?php
/**
 * url,Эurl
 * 
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindUrlHelper.php 3928 2013-01-29 10:21:53Z yishuo $
 * @package web
 */
class WindUrlHelper {

	/**
	 * url
	 * 
	 * $absolute === trueurlЭ鲿ʱ,ĬϼϵǰӦõЭ鲿.
	 * @param string $url ҪϷԵurl
	 * @param boolean $absolute ǷΪ·
	 * @return string
	 */
	public static function checkUrl($url, $absolute = true) {
		if ($absolute) {
			$_baseUrl = $absolute === true ? Wind::getComponent('request')->getBaseUrl(true) : $absolute;
			if (strpos($url, '://') === false) {
				$url = trim($_baseUrl, '/') . '/' . trim($url, '/');
			}
		}
		return $url;
	}

	/**
	 * urlַתΪʽ
	 * 
	 * Чͬ'argsToUrl'෴
	 * @param string $url
	 * @param boolean $decode ǷҪurl봦
	 * @param string $separator urlķָ
	 * @return array
	 */
	public static function urlToArgs($url, $decode = true, $separator = '&=') {
		if (strlen($separator) !== 2) return array();
		if (false !== $pos = strpos($url, '?')) $url = substr($url, $pos + 1);
		$url = explode($separator[0], trim($url, $separator[0]));
		$args = array();
		if ($separator[0] === $separator[1]) {
			$_count = count($url);
			for ($i = 0; $i < $_count; $i += 2) {
				if (!isset($url[$i + 1])) {
					$args[] = $decode ? rawurldecode($url[$i]) : $url[$i];
					continue;
				}
				$_k = $decode ? rawurldecode($url[$i]) : $url[$i];
				$_v = $decode ? rawurldecode($url[$i + 1]) : $url[$i + 1];
				$args[$_k] = $_v;
			}
		} else {
			foreach ($url as $value) {
				if (strpos($value, $separator[1]) === false) {
					$args[] = $decode ? rawurldecode($value) : $value;
					continue;
				}
				list($__k, $__v) = explode($separator[1], $value);
				$args[$__k] = $decode && $__v ? rawurldecode($__v) : $__v;
			}
		}
		return $args;
	}

	/**
	 * ʽĲбתΪUrlʽurlб봦
	 * 
	 * <code>:array('b'=>'b','c'=>'index','d'=>'d')
	 * ָ: '&='
	 * ת:&b=b&c=index&d=d
	 * ָΪ: '/' תΪ: /b/b/c/index/d/d/</code>
	 * @param array $args
	 * @param boolean $encode Ƿurl ĬֵΪtrue 
	 * @param string $separator urlָ ֧˫ַ,ǰһַڷָ,һַڷֵָ
	 * @return string
	 */
	public static function argsToUrl($args, $encode = true, $separator = '&=', $key = null) {
		if (strlen($separator) !== 2) return;
		$_tmp = '';
		foreach ((array) $args as $_k => $_v) {
			if ($key !== null) $_k = $key . '[' . $_k . ']';
			if (is_array($_v)) {
				$_tmp .= self::argsToUrl($_v, $encode, $separator, $_k) . $separator[0];
				continue;
			}
			$_v = $encode ? rawurlencode($_v) : $_v;
			if (is_int($_k)) {
				$_v && $_tmp .= $_v . $separator[0];
				continue;
			}
			$_k = ($encode ? rawurlencode($_k) : $_k);
			$_tmp .= $_k . $separator[1] . $_v . $separator[0];
		}
		return trim($_tmp, $separator[0]);
	}

	/**
	 * ControllerPath,ؽĽ
	 * 
	 * ֵ:array(action,controller,module,args)
	 * <code>actionʽ:'/module/controller/action/?a=a&b=b&c=c&',ǰб߷ָmcaϢ,ʺŷָб.</code>
	 * @param string $controllerPath
	 * @param array $args ĬֵΪ
	 * @return array
	 */
	public static function resolveAction($action, $args = array()) {
		list($action, $_args) = explode('?', $action . '?');
		$args = array_merge($args, ($_args ? self::urlToArgs($_args, false) : array()));
		$action = explode('/', trim($action, '/') . '/');
		end($action);
		return array(prev($action), prev($action), prev($action), $args);
	}

	/**
	 * 첢Urlַ
	 * 
	 * ǷurlдֱӦurl
	 * @param string $action ִеĲ
	 * @param array $args Ĳ
	 * @param string $anchor urlê
	 * @param AbstractWindRoute $route
	 * @param boolean $absolute Ƿ񷵻ؾԵַ
	 * @return string urlַ
	 */
	public static function createUrl($action, $args = array(), $anchor = '', $route = null, $absolute = true) {
		/* @var $router AbstractWindRouter */
		$router = Wind::getComponent('router');
		$url = $router->assemble($action, $args, $route);
		$url .= $anchor ? '#' . $anchor : '';
		return self::checkUrl($url, $absolute);
	}
}
?>