<?php
/**
 * ͨù߿
 *
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindUtility.php 3859 2012-12-18 09:25:51Z yishuo $
 * @package utility
 */
class WindUtility {

	/**
	 * ʽ
	 *
	 * ʽʽ: namespace:arg1.arg2.arg3.arg4.arg5==value
	 * : array($namespace, $param1, $operator, $param1)
	 *
	 * @param string $expression
	 *        	ıʽ
	 * @return array ؽıʽ,ɱʽĸɵ:
	 *         <ul>
	 *         <li>һԪ: ռ</li>
	 *         <li>ڶԪ: ʽ߲</li>
	 *         <li>Ԫ: ʽĲ</li>
	 *         <li>ĸԪأ ʽұ߲</li>
	 *         </ul>
	 */
	public static function resolveExpression($expression) {
		$operators = array('==', '!=', '<', '>', '<=', '>=');
		$operatorsReplace = array('#==#', '#!=#', '#<#', '#>#', '#<=#', '#>=#');
		list($p, $o, $v2) = explode('#', str_replace($operators, $operatorsReplace, $expression));
		if (strpos($p, ":") !== false)
			list($_namespace, $p) = explode(':', trim($p, ':'));
		else
			$_namespace = '';
		return array($_namespace, $p, $o, $v2);
	}

	/**
	 * ִм򵥵ʽ
	 *
	 * ִֻ===<><=>=򵥵ıȽ
	 *
	 * @param string $v1
	 *        	ߵĲ
	 * @param string $v2
	 *        	ұߵĲ
	 * @param string $operator
	 *        	
	 * @return boolean
	 */
	public static function evalExpression($v1, $v2, $operator) {
		switch ($operator) {
			case '==':
				return $v1 == $v2;
			case '!=':
				return $v1 != $v2;
			case '<':
				return $v1 < $v2;
			case '>':
				return $v1 > $v2;
			case '<=':
				return $v1 <= $v2;
			case '>=':
				return $v1 >= $v2;
			default:
				return false;
		}
		return false;
	}

	/**
	 * ݹϲ
	 *
	 * @param array $array1
	 *        	1
	 * @param array $array2
	 *        	2
	 * @return array ϲ
	 */
	public static function mergeArray($array1, $array2) {
		foreach ($array2 as $key => $value) {
			if (!isset($array1[$key])) {
				$array1[$key] = $value;
			} elseif (is_array($array1[$key]) && is_array($value)) {
				$array1[$key] = self::mergeArray($array1[$key], $array2[$key]);
			} elseif (is_numeric($key) && $array1[$key] !== $array2[$key]) {
				$array1[] = $value;
			} else
				$array1[$key] = $value;
		}
		return $array1;
	}

	/**
	 * ַĸСд
	 *
	 * @param string $str
	 *        	ַ
	 * @return string شַ
	 */
	public static function lcfirst($str) {
		$str[0] = strtolower($str[0]);
		return $str;
	}

	/**
	 * ַ
	 *
	 * @param int $length
	 *        	ĳ
	 * @return string õִ
	 */
	public static function generateRandStr($length) {
		$mt_string = 'AzBy0CxDwEv1FuGtHs2IrJqK3pLoM4nNmOlP5kQjRi6ShTgU7fVeW8dXcY9bZa';
		$randstr = '';
		for ($i = 0; $i < $length; $i++) {
			$randstr .= $mt_string[mt_rand(0, 61)];
		}
		return $randstr;
	}

	/**
	 * ͨװ֤
	 *
	 * @param string $field
	 *        	ֶ֤
	 * @param string $validator
	 *        	֤
	 * @param array $args
	 *        	֤дݵ,ڴֵֶ֤ĺ,ĬΪ
	 * @param string $default
	 *        	֤ʧõĬֵ,ĬΪnull
	 * @param string $message
	 *        	֤ʧǷصĴϢ,ĬΪִ
	 * @return array ֤
	 *         <ul>
	 *         <li>field: ֶ֤</li>
	 *         <li>validator: ֤</li>
	 *         <li>args: ֤дݵ,ڴֵֶ֤ĺ,ȱʡΪ</li>
	 *         <li>default: ֤ʧõĬֵ,ȱʡΪnull</li>
	 *         <li>message: ֤ʧǷصĴϢ,ĬΪ'ʾXX֤ʧ'</li>
	 *         </ul>
	 */
	public static function buildValidateRule($field, $validator, $args = array(), $default = null, $message = '') {
		return array(
			'field' => $field, 
			'validator' => $validator, 
			'args' => (array) $args, 
			'default' => $default, 
			'message' => ($message ? $message : 'ʾ\'' . $field . '\'֤ʧ'));
	}

	/**
	 * ַеĲ滻
	 *
	 * úŻphp strtr()ʵ, ڽ鷽ʽַ滻ʱ֧ģʽַ滻:
	 *
	 * @example <pre>
	 *          1. echo WindUtility::strtr("I Love {you}",array('{you}' =>
	 *          'lili'));
	 *          : I Love lili
	 *          2. echo WindUtility::strtr("I Love
	 *          #0,#1",array('lili','qiong'));
	 *          : I Love lili,qiong
	 *          <pre>
	 * @see WindLangResource::getMessage()
	 * @param string $str        	
	 * @param string $from        	
	 * @param string $to
	 *        	ѡ,ĬֵΪ''
	 * @return string
	 */
	public static function strtr($str, $from, $to = '') {
		if (is_string($from)) return strtr($str, $from, $to);
		if (isset($from[0])) {
			foreach ($from as $key => $value) {
				$from['#' . $key] = $value;
				unset($from[$key]);
			}
		}
		return !empty($from) ? strtr($str, $from) : $str;
	}
}