<?php
/**
 * ֤ͨ
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindValidator.php 2973 2011-10-15 19:22:48Z yishuo $
 * @package utility
 */
class WindValidator {

	/**
	 * ֤Ƿǵ绰
	 * 
	 * --绰ĸʽڹǰǰ0ǰ+ţ
	 * ֧0-4λ
	 * ֧0-6λ
	 * 绰֧412λ
	 * 
	 * @param string $phone ֤ĵ绰
	 * @return boolean ֤ͨ򷵻true򷵻false
	 */
	public static function isTelPhone($phone) {
		return 0 < preg_match('/^\+?[0\s]*[\d]{0,4}[\-\s]?\d{0,6}[\-\s]?\d{4,12}$/', $phone);
	}

	/**
	 * ֤Ƿֻ
	 * 
	 * -ֻ
	 *
	 * @param string $number ֤ĺ
	 * @return boolean ֤ʧܷfalse,֤ɹtrue
	 */
	public static function isTelNumber($number) {
		return 0 < preg_match('/^\+?[0\s]*[\d]{0,4}[\-\s]?\d{4,12}$/', $number);
	}

	/**
	 * ֤ǷQQ
	 * 
	 * QQ1-9ֿͷҳ5-15Ϊִ
	 *
	 * @param string $qq ֤qq
	 * @return boolean ֤ɹtrue򷵻false
	 */
	public static function isQQ($qq) {
		return 0 < preg_match('/^[1-9]\d{4,14}$/', $qq);
	}

	/**
	 * ֤Ƿ
	 * 
	 * 4-8ȵִ
	 *
	 * @param string $zipcode ֤ʱ
	 * @return boolean ֤ɹtrue򷵻false
	 */
	public static function isZipcode($zipcode) {
		return 0 < preg_match('/^\d{4,8}$/', $zipcode);
	}

	/**
	 * ֤ǷкϷemail
	 * 
	 * @param string $string   ַ
	 * @param array $matches  ᱻĽ,ĬΪarray()
	 * @param boolean $ifAll  Ƿȫʽƥ䣬ĬΪfalseһƥ
	 * @return boolean ƥɹtrue򷵻false
	 */
	public static function hasEmail($string, &$matches = array(), $ifAll = false) {
		return 0 < self::validateByRegExp("/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/", $string);
	}

	/**
	 * ֤ǷǺϷemail
	 * 
	 * @param string $string ִ֤
	 * @return boolean email򷵻true򷵻false
	 */
	public static function isEmail($string) {
		return 0 < preg_match("/^\w+(?:[-+.']\w+)*@\w+(?:[-.]\w+)*\.\w+(?:[-.]\w+)*$/", $string);
	}

	/**
	 * ֤ǷкϷ֤
	 * 
	 * @param string $string   ַ
	 * @param array $matches  ᱻĽ,ĬΪarray()
	 * @param boolean $ifAll  Ƿȫʽƥ䣬ĬΪfalseһƥ
	 * @return boolean ƥɹtrue򷵻false
	 */
	public static function hasIdCard($string, &$matches = array(), $ifAll = false) {
		return 0 < self::validateByRegExp("/\d{17}[\d|X]|\d{15}/", $string, $matches, $ifAll);
	}

	/**
	 * ֤ǷǺϷ֤
	 * 
	 * @param string $string ִ֤
	 * @return boolean ǺϷ֤򷵻true򷵻false
	 */
	public static function isIdCard($string) {
		return 0 < preg_match("/^(?:\d{17}[\d|X]|\d{15})$/", $string);
	}

	/**
	 * ֤ǷкϷURL
	 * 
	 * @param string $string   ַ
	 * @param array $matches  ᱻĽ,ĬΪarray()
	 * @param boolean $ifAll  Ƿȫʽƥ䣬ĬΪfalseһƥ
	 * @return boolean ƥɹtrue򷵻false
	 */
	public static function hasUrl($string, &$matches = array(), $ifAll = false) {
		return 0 < self::validateByRegExp('/http(s)?:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?/', $string, $matches, $ifAll);
	}

	/**
	 * ֤ǷǺϷurl
	 * 
	 * @param string $string ִ֤
	 * @return boolean ǺϷurl򷵻true򷵻false
	 */
	public static function isUrl($string) {
		return 0 < preg_match('/^(?:http(?:s)?:\/\/(?:[\w-]+\.)+[\w-]+(?:\:\d+)*+(?:\/[\w- .\/?%&=]*)?)$/', $string);
	}

	/**
	 * ֤Ƿ
	 * 
	 * @param string $string   ַ
	 * @param array $matches  ᱻĽ,ĬΪarray()
	 * @param boolean $ifAll  Ƿȫʽƥ䣬ĬΪfalseһƥ
	 * @return boolean ƥɹtrue򷵻false
	 */
	public static function hasChinese($string, &$matches = array(), $ifAll = false) {
		return 0 < self::validateByRegExp('/[\x{4e00}-\x{9fa5}]+/u', $string, $matches, $ifAll);
	}

	/**
	 * ֤Ƿ
	 * 
	 * @param string $string ִ֤
	 * @return boolean 򷵻true򷵻false
	 */
	public static function isChinese($string) {
		return 0 < preg_match('/^[\x{4e00}-\x{9fa5}]+$/u', $string);
	}

	/**
	 * ֤Ƿhtml
	 * 
	 * @param string $string   ַ
	 * @param array $matches  ᱻĽ,ĬΪarray()
	 * @param boolean $ifAll  Ƿȫʽƥ䣬ĬΪfalseһƥ
	 * @return boolean ƥɹtrue򷵻false
	 */
	public static function hasHtml($string, &$matches = array(), $ifAll = false) {
		return 0 < self::validateByRegExp('/<(.*)>.*|<(.*)\/>/', $string, $matches, $ifAll);
	}

	/**
	 * ֤ǷǺϷhtml
	 * 
	 * @param string $string ִ֤
	 * @return boolean ǺϷhtml򷵻true򷵻false
	 */
	public static function isHtml($string) {
		return 0 < preg_match('/^<(.*)>.*|<(.*)\/>$/', $string);
	}

	/**
	 * ֤ǷкϷipv4ַ
	 * 
	 * @param string $string    ַ
	 * @param array $matches   ᱻĽ,ĬΪarray()
	 * @param boolean $ifAll   Ƿȫʽƥ䣬ĬΪfalseһƥ
	 * @return boolean ƥɹtrue򷵻false
	 */
	public static function hasIpv4($string, &$matches = array(), $ifAll = false) {
		return 0 < self::validateByRegExp('/((25[0-5]|2[0-4]\d|1\d{2}|0?[1-9]\d|0?0?\d)\.){3}(25[0-5]|2[0-4]\d|1\d{2}|0?[1-9]\d|0?0?\d)/', $string, $matches, $ifAll);
	}

	/**
	 * ֤ǷǺϷIP
	 * 
	 * @param string $string ִ֤
	 * @return boolean ǺϷIP򷵻true򷵻false
	 */
	public static function isIpv4($string) {
		return 0 < preg_match('/(?:(?:25[0-5]|2[0-4]\d|1\d{2}|0?[1-9]\d|0?0?\d)\.){3}(?:25[0-5]|2[0-4]\d|1\d{2}|0?[1-9]\d|0?0?\d)/', $string);
	}

	/**
	 * ֤ǷкϷipV6
	 *
	 * @param string $string  ַ
	 * @param array $matches ᱻĽ,ĬΪarray()
	 * @param boolean $ifAll Ƿȫʽƥ䣬ĬΪfalseһƥ
	 * @return boolean ƥɹtrue򷵻false
	 */
	public static function hasIpv6($string, &$matches = array(), $ifAll = false) {
		return 0 < self::validateByRegExp('/\A((([a-f0-9]{1,4}:){6}|
										::([a-f0-9]{1,4}:){5}|
										([a-f0-9]{1,4})?::([a-f0-9]{1,4}:){4}|
										(([a-f0-9]{1,4}:){0,1}[a-f0-9]{1,4})?::([a-f0-9]{1,4}:){3}|
										(([a-f0-9]{1,4}:){0,2}[a-f0-9]{1,4})?::([a-f0-9]{1,4}:){2}|
										(([a-f0-9]{1,4}:){0,3}[a-f0-9]{1,4})?::[a-f0-9]{1,4}:|
										(([a-f0-9]{1,4}:){0,4}[a-f0-9]{1,4})?::
									)([a-f0-9]{1,4}:[a-f0-9]{1,4}|
										(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}
										([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])
									)|((([a-f0-9]{1,4}:){0,5}[a-f0-9]{1,4})?::[a-f0-9]{1,4}|
										(([a-f0-9]{1,4}:){0,6}[a-f0-9]{1,4})?::
									)
								)\Z/ix', $string, $matches, $ifAll);
	}

	/**
	 * ֤ǷǺϷipV6
	 *
	 * @param string $string ִ֤
	 * @return boolean ǺϷipV6򷵻true򷵻false
	 */
	public static function isIpv6($string) {
		return 0 < preg_match('/\A(?:(?:(?:[a-f0-9]{1,4}:){6}|
										::(?:[a-f0-9]{1,4}:){5}|
										(?:[a-f0-9]{1,4})?::(?:[a-f0-9]{1,4}:){4}|
										(?:(?:[a-f0-9]{1,4}:){0,1}[a-f0-9]{1,4})?::(?:[a-f0-9]{1,4}:){3}|
										(?:(?:[a-f0-9]{1,4}:){0,2}[a-f0-9]{1,4})?::(?:[a-f0-9]{1,4}:){2}|
										(?:(?:[a-f0-9]{1,4}:){0,3}[a-f0-9]{1,4})?::[a-f0-9]{1,4}:|
										(?:(?:[a-f0-9]{1,4}:){0,4}[a-f0-9]{1,4})?::
									)(?:[a-f0-9]{1,4}:[a-f0-9]{1,4}|
										(?:(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}
										(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])
									)|(?:(?:(?:[a-f0-9]{1,4}:){0,5}[a-f0-9]{1,4})?::[a-f0-9]{1,4}|
										(?:(?:[a-f0-9]{1,4}:){0,6}[a-f0-9]{1,4})?::
									)
								)\Z/ix', $string);
	}

	/**
	 * ֤Ƿпͻ˽ű
	 * 
	 * @param string $string  ַ
	 * @param array $matches ᱻĽ,ĬΪarray()
	 * @param boolean $ifAll Ƿȫʽƥ䣬ĬΪfalseһƥ
	 * @return boolean ƥɹtrue򷵻false
	 */
	public static function hasScript($string, &$matches = array(), $ifAll = false) {
		return 0 < self::validateByRegExp('/<script(.*?)>([^\x00]*?)<\/script>/', $string, $matches, $ifAll);
	}

	/**
	 * ֤ǷǺϷĿͻ˽ű
	 * 
	 * @param string $string ִ֤
	 * @return boolean ǺϷĿͻ˽ű򷵻true򷵻false
	 */
	public static function isScript($string) {
		return 0 < preg_match('/<script(?:.*?)>(?:[^\x00]*?)<\/script>/', $string);
	}

	/**
	 * ֤ǷǷǸ
	 * 
	 * @param int $number Ҫ֤ 
	 * @return boolean ڵ0ַtrue򷵻false
	 */
	public static function isNonNegative($number) {
		return is_numeric($number) && 0 <= $number;
	}

	/**
	 * ֤Ƿ
	 * 
	 * @param int $number Ҫ֤
	 * @return boolean ִ0򷵻true򷵻false
	 */
	public static function isPositive($number) {
		return is_numeric($number) && 0 < $number;
	}

	/**
	 * ֤ǷǸ
	 * 
	 * @param int $number  Ҫ֤
	 * @return boolean С0򷵻true򷵻false
	 */
	public static function isNegative($number) {
		return is_numeric($number) && 0 > $number;
	}

	/**
	 * ֤ǷǲΪ
	 *
	 * @param mixed $value жϵ
	 * @return boolean Ϊ򷵻false,Ϊշtrue
	 */
	public static function isRequired($value) {
		return !empty($value);
	}

	/**
	 * ַ֤ĳ
	 * 
	 * @param string $string Ҫַ֤
	 * @param string $length ָĺϷĳ
	 * @param string $charset ַĬΪutf-8
	 * @return boolean ȴڸĳ򷵻true򷵻false
	 */
	public static function isLegalLength($string, $length, $charset = 'utf8') {
		Wind::import('WIND:utility.WindString');
		return WindString::strlen($string, $charset) > (int) $length;
	}

	/**
	 *  $string ַ $regExp ʽƥݡ
	 * 
	 * @param string $regExp  Ĺ() 
	 * @param string $string   ַ
	 * @param array $matches ᱻĽĬΪarray()
	 * @param boolean $ifAll   Ƿȫʽƥ䣬ĬΪfalseȫƥ
	 * @return int ƥĴ
	 */
	private static function validateByRegExp($regExp, $string, &$matches = array(), $ifAll = false) {
		return $ifAll ? preg_match_all($regExp, $string, $matches) : preg_match($regExp, $string, $matches);
	}
}