<?php
/**
 * ģǩ
 * 
 * ̳ͨиó,չģıǩ.չģıǩʱʵ'compile'.
 * ÷һmatchıǩݽнؽĽ.
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AbstractWindTemplateCompiler.php 3533 2012-05-08 08:24:20Z yishuo $
 * @package viewer
 */
abstract class AbstractWindTemplateCompiler extends WindHandlerInterceptor {
	/**
	 * @var array
	 */
	protected $tags= array();
	/**
	 * @var WindViewTemplate
	 */
	protected $windViewTemplate = null;
	/**
	 * @var WindViewerResolver
	 */
	protected $windViewerResolver = null;
	/**
	 * @var WindHttpRequest
	 */
	protected $request = null;
	/**
	 * @var WindHttpResponse
	 */
	protected $response = null;
	/**
	 * @var array
	 */
	protected $_propertiesCache = array();

	/**
	 * ʼǩ
	 * 
	 * @param string $tags
	 * @param WindViewTemplate $windViewTemplate
	 * @param WindViewerResolver $windViewerResolver
	 * @param WindHttpRequest $request
	 * @param WindHttpResponse $response
	 */
	public function __construct($tags, $windViewTemplate, $windViewerResolver, $request, $response) {
		$this->tags = $tags;
		$this->windViewTemplate = $windViewTemplate;
		$this->windViewerResolver = $windViewerResolver;
		$this->request = $request;
		$this->response = $response;
	}

	/**
	 * ݱ,һݽб봦ر
	 * 
	 * @param string $key 
	 * @param string $content ģ
	 * @return string 
	 */
	abstract public function compile($key, $content);

	/**
	 * ǰԤ
	 * 
	 * @return void
	 */
	protected function preCompile() {}

	/**
	 * 
	 * 
	 * @return void
	 */
	protected function postCompile() {}

	/**
	 * ظñǩֵ֧б,ҪǸ÷ʵֶԱǩĽ֧
	 * 
	 * @return array
	 */
	protected function getProperties() {
		return array();
	}

	/**
	 * ǩֵ
	 * 
	 * @param string $content
	 */
	protected function compileProperty($content) {
		foreach ($this->getProperties() as $value) {
			if (!$value || !property_exists($this, $value)) continue;
			if (!isset($this->_propertiesCache[$value])) {
				$this->_propertiesCache[$value] = $this->$value;
			}
			preg_match('/(?<=' . preg_quote($value) . '=([\'\"]))(.*?)(?=\1)/ie', $content, $result);
			$this->$value = $result ? $result[0] : $this->_propertiesCache[$value];
		}
	}

	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::preHandle()
	 */
	public function preHandle() {
		if ($this->windViewTemplate === null) return;
		$this->preCompile();
		foreach ($this->tags as $key => $value) {
			if (!$value[0] || !$value[1]) continue;
			$this->compileProperty($value[1]);
			$_output = $this->compile($value[0], $value[1]);
			$this->windViewTemplate->setCompiledBlockData($value[0], $_output);
		}
		$this->postCompile();
	}

	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::postHandle()
	 */
	public function postHandle() {}

	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::handle()
	 */
	public function handle() {
		$args = func_get_args();
		call_user_func_array(array($this, 'preHandle'), $args);
		if (null !== ($handler = $this->interceptorChain->getHandler())) {
			call_user_func_array(array($handler, 'handle'), $args);
		}
		call_user_func_array(array($this, 'postHandle'), $args);
	}

	/**
	 * @return WindViewTemplate
	 */
	protected function getWindViewTemplate() {
		return $this->windViewTemplate;
	}

}

?>