<?php
Wind::import('WIND:utility.WindFile');
/**
 * ģඨ
 * 
 * ģĳඨ,ְ:ģļ,ر.
 * ֻһӿҪʵ<i>doCompile</i>,ģֻһĹӿ<i>compile</i>.
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AbstractWindViewTemplate.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package viewer
 */
abstract class AbstractWindViewTemplate extends WindModule {

	/**
	 * ģݱʵ,رģ
	 * 
	 * @param string $content ģ
	 * @param WindViewerResolver $windViewerResolver
	 * @return string
	 */
	abstract protected function doCompile($content, $windViewerResolver = null);

	/**
	 * ͼȾ
	 * 
	 * @param string $templateFile | ģļ
	 * @param WindViewerResolver $windViewerResolver
	 */
	public function compile($templateFile, $windViewerResolver) {
		$_output = $this->getTemplateFileContent($templateFile);
		$_output = $this->compileDelimiter($_output);
		$_output = $this->doCompile($_output, $windViewerResolver);
		return $_output;
	}

	/**
	 * Ⱦ
	 *
	 * @param string $stream
	 * @param WindViewerResolver $windViewerResolver
	 */
	public function compileStream($stream, $windViewerResolver) {
		$_output = $this->compileDelimiter($stream);
		$_output = $this->doCompile($_output, $windViewerResolver);
		return $_output;
	}

	/**
	 * @param string content
	 * @return string
	 */
	protected function compileDelimiter($content) {
		$content = preg_replace('/<!--[{#]/i', "<?php ", $content);
		$content = preg_replace('/[#}]-->/i', "?>", $content);
		
		/*$content = str_replace(array('<!--{', '<!--#'), '<?php ', $content);
		$content = str_replace(array('}-->', '#-->'), '?>', $content);*/
		return $content;
	}

	/**
	 * ģļݣĿǰֱֻ֧ļȡ
	 * 
	 * @param string $templateFile
	 * @return string
	 */
	private function getTemplateFileContent($templateFile) {
		if (false === ($content = WindFile::read($templateFile))) {
			throw new WindViewException('[viewer.AbstractWindViewTemplate.getTemplateFileContent] Unable to open the template file \'' . $templateFile . '\'.');
		}
		return $content;
	}
}
?>