<?php
Wind::import('WIND:utility.WindFolder');
Wind::import('WIND:viewer.IWindView');
/**
 * ͼ
 * 
 * <i>WindView</i>ǻͼ,ְ𣺽ͼȾ.<br>
 * ʵԽӿ<i>IWindView</i>,<i>WindViewerResolver</i>ͼȾ<br/>
 * <i>WindView</i>ַ֧ḻϢͨ޸ıͼΪ.<i>template-dir</i>
 * :ģĿ¼,֧ռʽ:WIND:template,ռΪʱԵǰapprootpathΪĬռ;<i>template-ext</i>
 * :ģ׺,ĬΪhtm,ͨøֵıģĺ׺;<i>is-compile</i>
 * :ǷģԶ,ԶʱݱļǷڻǷѾжǷҪ±.֧'0''1',ĬֵΪ'0'.<i>compile-dir</i>
 * :ģĿ¼,ͬ'template-dir'.(ע:Ŀ¼ҪдȨ).
 * Ĭ֧£<code> array(
 * 'template-dir' => 'template',
 * 'template-ext' => 'htm',
 * 'is-compile' => '0',
 * 'compile-dir' => 'DATA:template',
 * 'compile-ext' => 'tpl', //ģ׺
 * 'layout' => '', //ļ
 * 'theme' => '', //λ
 * 'htmlspecialchars' => 'true', //Ƿģй
 * )
 * </code>
 * øʽ<code>
 * 'windView' => array('path' => 'WIND:viewer.WindView',
 * 'scope' => 'prototype',	//ע:ռΪ'prototype'
 * 'config' => array(
 * 'template-dir' => 'template',
 * 'template-ext' => 'htm',
 * 'is-compile' => '0',
 * 'compile-dir' => 'compile.template',
 * 'compile-ext' => 'tpl',
 * 'layout' => '',
 * 'theme' => ''),
 * 'properties' => array(
 * 'viewResolver' => array('ref' => 'viewResolver')
 * ))</code>
 * <note><b>ע:</b>Ĭͼ,ͨ޸޸Ĭͼ.(ϸοö)</note>
 * 
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license {@link http://www.windframework.com}
 * @version $Id: WindView.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package viewer
 */
class WindView extends WindModule implements IWindView {
	/**
	 * ģĿ¼
	 * 
	 * ֧ռʽ:<i>WIND:template</i>,
	 * ռΪʱԵǰ<i>app</i><i>rootpath</i>ΪĬռ
	 * @var string
	 */
	public $templateDir;
	/**
	 * ģļչ
	 * 
	 * @var string
	 */
	public $templateExt;
	/**
	 * ģ
	 * 
	 * @var string
	 */
	public $templateName;
	/**
	 * Ƿģhtmlַ
	 * 
	 * @var boolean
	 */
	public $htmlspecialchars = true;
	/**
	 * ǷģԶ
	 * 
	 * ֵ01<ol>
	 * <li>0   ر,ģ</li>
	 * <li>1  ģ</li></ol>
	 * @var int
	 */
	public $isCompile = 0;
	/**
	 * ģļĿ¼,Ŀ¼ͬ<i>templateDir</i>
	 * 
	 * @var string
	 */
	public $compileDir;
	/**
	 * ģļɺ׺,ĬֵΪ'tpl'
	 * 
	 * @var string
	 */
	public $compileExt = 'tpl';
	/**
	 * ģ岼ļ
	 * 
	 * @var string
	 */
	public $layout;
	/**
	 * Ľṹ
	 *
	 * @var string
	 */
	public $themePackPattern = '{pack}.{theme}';
	
	/**
	 * Ŀ¼
	 * array('theme' => '', 'package' => '');
	 * @var string
	 */
	protected $theme = array();
	/**
	 * ͼ,ͨøı
	 * 
	 * @var WindViewerResolver
	 */
	protected $viewResolver = null;
	/**
	 * ͼֹ
	 *
	 * @var WindLayout
	 */
	protected $windLayout = null;
	
	/* (non-PHPdoc)
	 * @see IWindView::render()
	 */
	public function render($display = false) {
		if (!$this->templateName) return;
		
		/* @var $viewResolver WindViewerResolver */
		$viewResolver = $this->_getViewResolver();
		$viewResolver->setWindView($this);
		if ($viewResolver === null) throw new WindException(
			'[viewer.WindView.render] View renderer initialization failure.');
		$viewResolver->windAssign($this->getResponse()->getData($this->templateName));
		if ($display === false) {
			if ($this->layout) {
				/* @var $layout WindLayout */
				$layout = $this->_getWindLayout();
				$layout->parser($this->layout, $viewResolver);
			} else
				$viewResolver->windFetch();
		} else {
			$viewResolver->windFetch();
		}
	}
	
	/* (non-PHPdoc)
	 * @see WindModule::setConfig()
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		if ($this->_config) {
			$this->templateDir = $this->getConfig('template-dir', '', $this->templateDir);
			$this->templateExt = $this->getConfig('template-ext', '', $this->templateExt);
			$this->compileDir = $this->getConfig('compile-dir', '', $this->compileDir);
			$this->compileExt = $this->getConfig('compile-ext', '', $this->compileExt);
			$this->isCompile = $this->getConfig('is-compile', '', $this->isCompile);
			$this->layout = $this->getConfig('layout', '', $this->layout);
			$this->themePackPattern = $this->getConfig('themePackPattern', '', 
				$this->themePackPattern);
			$this->htmlspecialchars = $this->getConfig('htmlspecialchars', '', 
				$this->htmlspecialchars);
			$this->setThemePackage($this->getConfig('theme-package'));
		}
	}

	/**
	 * ģ·Ϣ
	 * 
	 * ģ߼,ģľ·Ϣ,֧ռ䷽ʽģϢ.<code>
	 * $template='templateName'; //return $templateDir/templateName.$ext
	 * $template='subTemplateDir.templateName'; //return $templateDir/subTemplateDir/templateName.$ext
	 * $template='namespace:templateName'; //return namespace:templateName.$ext</code>
	 * <note><b>ע:</b>$templateΪ򷵻صǰģ·Ϣ.ģļ׺ͨ޸ý޸.</note>
	 * @param string $template ģ, ĬֵΪ , Ϊ򷵻صǰģľԵַ
	 * @param string $ext ģ׺, ĬֵΪ, Ϊ򷵻ʹĬϵĺ׺
	 * @param boolean $createCompileDir true
	 * @return array(templatePath, compilePath, currentThemeKey)
	 */
	public function getViewTemplate($template = '', $ext = '') {
		$template || $template = $this->templateName;
		$ext || $ext = $this->templateExt;
		$compilePath = $templatePath = '';
		if ($this->templateDir && false === strpos($template, ':')) {
			$template = $this->templateDir . '.' . $template;
		}
		$_template = false !== ($pos = strpos($template, ':')) ? substr($template, $pos + 1) : $template;
		$currentThemeKey = null;
		foreach ($this->theme as $currentThemeKey => $theme) {
			$_templatePath = strtr($this->themePackPattern, 
				array('{pack}' => $theme[1], '{theme}' => $theme[0])) . '.' . $_template;
			$_templatePath = Wind::getRealPath($_templatePath, $ext, true);
			isset($_compileDir) || $_compileDir = $theme[0];
			if (is_file($_templatePath)) {
				$templatePath = $_templatePath;
				break;
			}
		}
		$templatePath === '' && $templatePath = Wind::getRealPath($template, $ext, true);
		$compilePath = $this->compileDir . '.' . (isset($_compileDir) ? $_compileDir . '.' : '') . $_template;
		$compilePath = Wind::getRealPath($compilePath, $this->compileExt, true);
		//WindFolder::mkRecur(dirname($compilePath));
		return array($templatePath, $compilePath, $currentThemeKey);
	}

	/**
	 * ȡǰ
	 *
	 * @param string $type (all)
	 * @return array(theme,package)
	 */
	public function getTheme($key = 'all') {
		if ($key === 'all') return $this->theme;
		return $this->theme[$key];
	}

	/**
	 * ÷Ϣ
	 * 
	 * @param string $theme
	 * @param string $package
	 */
	public function setTheme($theme, $package) {
		array_unshift($this->theme, array($theme, $package));
	}
}