<?php
Wind::import('WIND:viewer.AbstractWindViewTemplate');
Wind::import('WIND:utility.WindFile');
/**
 * ģ
 * 
 * ְ𣺽ģ,һҪģļַ,ȡģݲб봦Ȼ󷵻ظ.
 * Ϣ,ͨconfigǩʵֱǩչ֧:<code>
 * 'template' => array(
 * 'path' => 'WIND:viewer.compiler.WindViewTemplate',
 * 'scope' => 'prototype',
 * 'config' => array('resource' => ''),
 * )
 * <config>
 * //Ϣ
 * <support-tags>
 * <!-- ǩãname: ǩ֣ tag:ıǩ pattern:ƥʽ   compiler:ļ-->
 * <!--<tag name='' tag='' pattern='' compiler='' /> -->
 * </support-tags>
 * </config>
 * </code>
 * չΪ'test'ıǩչ,Ҫǩ,ƥñǩʽ(Ϊ,ΪĬϵǩƥ,ͨ뱣Ϊ),
 * Լڽñǩıǩ(ǩҪ̳AbstractWindTemplateCompiler):<code>
 * <support-tags>
 * <tag name='test' tag='test' pattern='<(test)[^<>\n]*(\/>|>[^<>]*<\/\1>)' compiler='TEST:TestTemplateCompiler' />
 * </support-tags>
 * </code>
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindViewTemplate.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package viewer
 * @subpackage compiler
 */
class WindViewTemplate extends AbstractWindViewTemplate {
	/**
	 * matchģļ
	 *
	 * @var array
	 */
	protected $compiledBlockData = array();
	/**
	 * @var WindHandlerInterceptorChain
	 */
	protected $windHandlerInterceptorChain = null;
	protected $_compilerCache = array();

	/* (non-PHPdoc)
	 * @see AbstractWindViewTemplate::doCompile()
	 */
	protected function doCompile($content, $windViewerResolver = null) {
		try {
			$content = $this->registerTags($content, $windViewerResolver);
			if ($this->windHandlerInterceptorChain !== null) {
				$this->windHandlerInterceptorChain->getHandler()->handle();
			}
			foreach (array_reverse($this->compiledBlockData) as $key => $value) {
				if (!$key) continue;
				$content = str_replace($this->getBlockTag($key), ($value ? $value : ' '), $content);
			}
			$content = preg_replace('/\?>(\s|\n)*?<\?php/i', "\r\n", $content);
			return $content;
		} catch (Exception $e) {
			throw new WindViewException(
				'[viewer.WindViewTemplate.doCompile] compile fail.' . $e->getMessage(), 
				WindViewException::ERROR_SYSTEM_ERROR);
		}
	}

	/**
	 * עֵ֧ıǩעģ
	 * 
	 * ģ,ƥ䵽ıǩݿעᵽӦıǩвʼǩ.
	 * @param string $content
	 * @param WindViewerResolver $windViewerResolver
	 * @return string 
	 */
	private function registerTags($content, $windViewerResolver = null) {
		foreach ((array) $this->getTags() as $key => $value) {
			$compiler = isset($value['compiler']) ? $value['compiler'] : '';
			$regex = isset($value['pattern']) ? $value['pattern'] : '';
			$tag = isset($value['tag']) ? $value['tag'] : '';
			if (!$compiler || !$tag) continue;
			if ($regex === '') $regex = '/<(' . preg_quote($tag) . ')(.*?)(\/>|>(.*?)<\/\1>)/is';
			$content = $this->creatTagCompiler($content, $compiler, $regex, $windViewerResolver);
		}
		return $content;
	}

	/**
	 * ӦǩĽʵ,ص.
	 * 
	 * @param string content ģ
	 * @param string compiler ǩ
	 * @param string regex ʽ
	 * @param WindViewerResolver $windViewerResolver ĬΪnull
	 * @return string شģ
	 */
	private function creatTagCompiler($content, $compiler, $regex, $windViewerResolver = null) {
		$content = preg_replace_callback($regex, array($this, '_creatTagCompiler'), $content);
		if ($this->windHandlerInterceptorChain === null) {
			$this->windHandlerInterceptorChain = new WindHandlerInterceptorChain();
		}
		$_compilerClass = Wind::import($compiler);
		$this->windHandlerInterceptorChain->addInterceptors(
			new $_compilerClass($this->_compilerCache, $this, $windViewerResolver, 
				$this->getRequest(), $this->getResponse()));
		$this->_compilerCache = array();
		return $content;
	}

	/**
	 * صǰעıǩ
	 * 
	 * @return array
	 */
	protected function getTags() {
		$_tags['internal'] = $this->createTag('internal', 'WIND:viewer.compiler.WindTemplateCompilerInternal', 
			'/<\?php.*?\?>/is');
		/*ǩڸλ*/
		$_tags['template'] = $this->createTag('template', 
			'WIND:viewer.compiler.WindTemplateCompilerTemplate');
		//$_tags['page'] = $this->createTag('page', 'WIND:viewer.compiler.WindTemplateCompilerPage');
		$_tags['action'] = $this->createTag('action', 
			'WIND:viewer.compiler.WindTemplateCompilerAction');
		//$_tags['component'] = $this->createTag('component', 'WIND:viewer.compiler.WindTemplateCompilerComponent');
		$_tags['token'] = $this->createTag('token', 
			'WIND:viewer.compiler.WindTemplateCompilerToken');
		$_tags['lang'] = $this->createTag('lang', 'WIND:viewer.compiler.WindTemplateCompilerLang');
		$_tags = array_merge($_tags, $this->getConfig('support-tags', '', array()));
		/*ǩ*/
		$_tags['expression'] = $this->createTag('expression', 
			'WIND:viewer.compiler.WindTemplateCompilerEcho', '/({@|{\$[\w$]{1})[^}{@\n]*}/i');
		
		$_tags = array_merge($_tags, $this->getConfig('support-tags-end', '', array()));
		//$_tags['echo'] = $this->createTag('echo', 'WIND:viewer.compiler.WindTemplateCompilerEcho', '/\$[\w_]+/i');
		/* ǩǶױ */
		//$_tags['script1'] = $this->createTag('script1', 'WIND:viewer.compiler.WindTemplateCompilerScript', '/<!--\[[\w\s]*\]>(.|\n)*<!\[[\w\s]*\]-->/Ui');
		//$_tags['script'] = $this->createTag('script', 'WIND:viewer.compiler.WindTemplateCompilerScript', '/<(script)[^<>\n]*(\/>|>(.|\n)*<\/\1>)/Ui');
		//$_tags['link'] = $this->createTag('link', 'WIND:viewer.compiler.WindTemplateCompilerCss');
		//$_tags['style'] = $this->createTag('style', 'WIND:viewer.compiler.WindTemplateCompilerCss');
		return $_tags;
	}

	/**
	 * tag
	 * 
	 * @param string $tag ǩ
	 * @param string $class 
	 * @param stirng $pattern ʽ,ƥǩ ĬΪ
	 * @return array
	 */
	private function createTag($tag, $class, $pattern = '') {
		return array('tag' => $tag, 'pattern' => $pattern, 'compiler' => $class);
	}

	/**
	 * ǩƥ䵽ģõУرʶλõģнռΪ
	 * 
	 * @param string $content
	 * @return mixed
	 */
	private function _creatTagCompiler($content) {
		$_content = $content[0];
		if (!$_content) return '';
		
		$key = $this->getCompiledBlockKey();
		$this->_compilerCache[] = array($key, $_content);
		return $this->getBlockTag($key);
	}

	/**
	 * ģ洢бǩ
	 * Key 'HhQWFLtU0LSA3nLPLHHXMtTP3EfMtN3FsxLOR1nfYC5OiZTQri' Ϊ
	 * <pw-wind key='HhQWFLtU0LSA3nLPLHHXMtTP3EfMtN3FsxLOR1nfYC5OiZTQri' />
	 * ģнλñʶ
	 * 
	 * @param string $key 
	 * @return string|mixed 
	 */
	private function getBlockTag($key) {
		return '#' . $key . '#';
	}

	/**
	 * зֺ뻺Keyֵ,KeyֵΪһ50λַ,ظʱ
	 * 
	 * @return string
	 */
	protected function getCompiledBlockKey() {
		$key = WindUtility::generateRandStr(50);
		if (key_exists($key, $this->compiledBlockData)) {
			return $this->getCompiledBlockKey();
		}
		return $key;
	}

	/**
	 * رKeyֵ.keyֵΪʱȫ
	 * 
	 * @param string $key
	 * @return string|array
	 */
	public function getCompiledBlockData($key = '') {
		if ($key)
			return isset($this->compiledBlockData[$key]) ? $this->compiledBlockData[$key] : '';
		else
			return $this->compiledBlockData;
	}

	/**
	 * keyֵģ
	 * 
	 * @param string $key 
	 * @param string $compiledBlockData 
	 * @return void
	 */
	public function setCompiledBlockData($key, $compiledBlockData) {
		if ($key) $this->compiledBlockData[$key] = $compiledBlockData;
	}

}

?>