<?php
Wind::import('WIND:viewer.resolver.WindNormalViewerResolver');
Wind::import('WIND:viewer.exception.WindViewException');
/**
 * ͼȾ
 * ʵ˽ӿ<i>IWindViewerResolver</i>,ҪְǽͼȾȾͼ.
 * ֲֹ֧Լͨ<i>WindViewTemplate</i>֧ͼģ롣
 * :<code>
 * 'viewResolver' => array(
 * 'path' => 'WIND:viewer.WindViewerResolver',
 * 'scope' => 'prototype',
 * 'properties' => array(
 * 'windLayout' => array(
 * 'ref' => 'layout',
 * )))</code>
 * <note><b>ע:</b>ĬͼȾ,ͨcomponentý޸</note>
 * <note>WindViewWindViewerResolver໥ʹõ,WindViewһͼȾʼһViewerResolver󲢽һͼȾƽö.
 * ViewerResolverڽͼȾʱ״̬ϢģϢԼϢWindView.ViewerResolverеWindViewǴViewerResolverǸ.
 * ǿͨ޸viewcomponentע벻ͬViewerResolverʵ.
 * </note>
 * 
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindViewerResolver.php 3908 2013-01-18 03:37:53Z yishuo $
 * @package viewer
 */
class WindViewerResolver extends WindNormalViewerResolver implements IWindViewerResolver {
	private $currentThemeKey = null;
	
	/*
	 * (non-PHPdoc) @see IWindViewerResolver::windFetch()
	 */
	public function windFetch($template = '') {
		$template || $template = $this->windView->templateName;
		if (!$template) return '';
		list($compileFilePath) = $this->compile($template);
		WindRender::render($compileFilePath, $this->vars, $this);
	}

	/**
	 * ģ岢رģַ
	 * <pre>
	 * <i>$output==true</i>رļ·ַ,ɱļ;
	 * <i>$output==false</i>رļ·ַ,ɱļ
	 * </pre>
	 * 
	 * @param string $template ģ 
	 * @param string $suffix ģ׺ ĬΪ
	 * @param boolean $readOnly Ƿֱģ,ֵtrue,false ĬֵΪfalse
	 * @param boolean $forceOutput ǷǿƷģ,ĬΪǿ
	 * @return array(compileFile,content) <pre>
	 *         <i>compileFile</i>ģļԵַ,
	 *         <i>content</i>ģ,<i>$output</i>
	 *         ΪfalseʱcontentдcompileFile</pre>
	 */
	public function compile($template, $suffix = '', $readOnly = false, $forceOutput = false) {
		list($templateFile, $compileFile, $this->currentThemeKey) = $this->windView->getViewTemplate(
			$template, $suffix);
		if (!is_file($templateFile)) {
			throw new WindViewException(
				'[viewer.resolver.WindViewerResolver.compile] ' . $templateFile, 
				WindViewException::VIEW_NOT_EXIST);
		}
		
		if (!$this->checkReCompile($templateFile, $compileFile)) {
			return array(
				$compileFile, 
				($forceOutput || $readOnly ? WindFile::read($compileFile) : ''));
		}
		/* @var $_windTemplate WindViewTemplate */
		$_windTemplate = Wind::getComponent('template');
		$_output = $_windTemplate->compile($templateFile, $this);
		if (false === $readOnly) {
			WindFolder::mkRecur(dirname($compileFile));
			WindFile::write($compileFile, $_output);
		}
		return array($compileFile, $_output);
	}

	/**
	 * ģ񣬸÷صǰֵ
	 * 
	 * @return NULL int
	 */
	public function getCurrentThemeKey() {
		return $this->currentThemeKey;
	}

	/**
	 * ǷҪ±,Ҫ뷵falseҪ뷵true
	 * Ƿ½бȡ'Wind::$isDebug''isCompile','Wind::$isDebug'ǿܲ'DEBUG'Ƴ,'DEBUG'ʱɱģ.
	 * 'isCompile'һֵ'WindView',ûͨý޸.'isCompile'Ϊ'1'ʱ,һж,ļڻѾʱģ±.
	 * 'isCompile'Ϊ'0',򲻶ģļ±.
	 * 
	 * @param string $templateFilePath ģ·
	 * @param string $compileFilePath ·
	 * @return boolean
	 */
	private function checkReCompile($templateFilePath, $compileFilePath) {
		if (Wind::$isDebug) return true;
		if ($this->getWindView()->isCompile) {
			if (!is_file($compileFilePath)) return true;
			$_c_m_t = filemtime($compileFilePath);
			if ((int) $_c_m_t <= (int) filemtime($templateFilePath)) return true;
		}
		return false;
	}
}
